/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.codegen.types;

import jdk.nashorn.internal.codegen.CompilerConstants;
import jdk.nashorn.internal.codegen.types.BitwiseType;
import jdk.nashorn.internal.codegen.types.Type;
import org.objectweb.asm.MethodVisitor;

class IntType
extends BitwiseType {
    private static final CompilerConstants.Call TO_STRING = CompilerConstants.staticCallNoLookup(Integer.class, "toString", String.class, Integer.TYPE);
    private static final CompilerConstants.Call VALUE_OF = CompilerConstants.staticCallNoLookup(Integer.class, "valueOf", Integer.class, Integer.TYPE);

    protected IntType() {
        super("int", Integer.TYPE, 2, 1);
    }

    @Override
    public Type nextWider() {
        return LONG;
    }

    @Override
    public Class<?> getBoxedType() {
        return Integer.class;
    }

    @Override
    public Type ldc(MethodVisitor method, Object c) {
        assert (c instanceof Integer);
        int value = (Integer)c;
        switch (value) {
            case -1: {
                method.visitInsn(2);
                break;
            }
            case 0: {
                method.visitInsn(3);
                break;
            }
            case 1: {
                method.visitInsn(4);
                break;
            }
            case 2: {
                method.visitInsn(5);
                break;
            }
            case 3: {
                method.visitInsn(6);
                break;
            }
            case 4: {
                method.visitInsn(7);
                break;
            }
            case 5: {
                method.visitInsn(8);
                break;
            }
            default: {
                if (value == (byte)value) {
                    method.visitIntInsn(16, value);
                    break;
                }
                if (value == (short)value) {
                    method.visitIntInsn(17, value);
                    break;
                }
                method.visitLdcInsn(c);
            }
        }
        return Type.INT;
    }

    @Override
    public Type convert(MethodVisitor method, Type to) {
        if (to.isEquivalentTo(this)) {
            return to;
        }
        if (to.isNumber()) {
            method.visitInsn(135);
        } else if (to.isLong()) {
            method.visitInsn(133);
        } else if (!to.isBoolean()) {
            if (to.isString()) {
                IntType.invokeStatic(method, TO_STRING);
            } else if (to.isObject()) {
                IntType.invokeStatic(method, VALUE_OF);
            } else assert (false) : "Illegal conversion " + this + " -> " + to;
        }
        return to;
    }

    @Override
    public Type add(MethodVisitor method) {
        method.visitInsn(96);
        return INT;
    }

    @Override
    public Type shr(MethodVisitor method) {
        method.visitInsn(124);
        return INT;
    }

    @Override
    public Type sar(MethodVisitor method) {
        method.visitInsn(122);
        return INT;
    }

    @Override
    public Type shl(MethodVisitor method) {
        method.visitInsn(120);
        return INT;
    }

    @Override
    public Type and(MethodVisitor method) {
        method.visitInsn(126);
        return INT;
    }

    @Override
    public Type or(MethodVisitor method) {
        method.visitInsn(128);
        return INT;
    }

    @Override
    public Type xor(MethodVisitor method) {
        method.visitInsn(130);
        return INT;
    }

    @Override
    public Type load(MethodVisitor method, int slot) {
        assert (slot != -1);
        method.visitVarInsn(21, slot);
        return INT;
    }

    @Override
    public void store(MethodVisitor method, int slot) {
        assert (slot != -1);
        method.visitVarInsn(54, slot);
    }

    @Override
    public Type sub(MethodVisitor method) {
        method.visitInsn(100);
        return INT;
    }

    @Override
    public Type mul(MethodVisitor method) {
        method.visitInsn(104);
        return INT;
    }

    @Override
    public Type div(MethodVisitor method) {
        method.visitInsn(108);
        return INT;
    }

    @Override
    public Type rem(MethodVisitor method) {
        method.visitInsn(112);
        return INT;
    }

    @Override
    public Type neg(MethodVisitor method) {
        method.visitInsn(116);
        return INT;
    }

    @Override
    public void _return(MethodVisitor method) {
        method.visitInsn(172);
    }

    @Override
    public Type loadUndefined(MethodVisitor method) {
        method.visitLdcInsn((Object)0);
        return INT;
    }

    @Override
    public Type loadEmpty(MethodVisitor method) {
        assert (false) : "unsupported operation";
        return null;
    }

    @Override
    public Type cmp(MethodVisitor method, boolean isCmpG) {
        assert (false) : "unsupported operation";
        return null;
    }

    @Override
    public Type cmp(MethodVisitor method) {
        assert (false) : "unsupported operation";
        return null;
    }
}

