/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.codegen;

import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import jdk.nashorn.internal.codegen.CompileUnit;
import jdk.nashorn.internal.codegen.Compiler;
import jdk.nashorn.internal.codegen.CompilerConstants;
import jdk.nashorn.internal.codegen.Frame;
import jdk.nashorn.internal.codegen.MethodEmitter;
import jdk.nashorn.internal.codegen.WeighNodes;
import jdk.nashorn.internal.ir.Block;
import jdk.nashorn.internal.ir.BreakNode;
import jdk.nashorn.internal.ir.ContinueNode;
import jdk.nashorn.internal.ir.DoWhileNode;
import jdk.nashorn.internal.ir.ForNode;
import jdk.nashorn.internal.ir.FunctionNode;
import jdk.nashorn.internal.ir.LabelNode;
import jdk.nashorn.internal.ir.LiteralNode;
import jdk.nashorn.internal.ir.Node;
import jdk.nashorn.internal.ir.ReturnNode;
import jdk.nashorn.internal.ir.SplitNode;
import jdk.nashorn.internal.ir.SwitchNode;
import jdk.nashorn.internal.ir.WhileNode;
import jdk.nashorn.internal.ir.visitor.NodeVisitor;
import jdk.nashorn.internal.runtime.Source;
import jdk.nashorn.internal.runtime.options.Options;

public class Splitter
extends NodeVisitor {
    private final Compiler compiler;
    private final FunctionNode functionNode;
    private final CompileUnit scriptCompileUnit;
    private final Map<Node, Long> weightCache = new HashMap<Node, Long>();
    public static final long SPLIT_THRESHOLD = Options.getIntProperty("nashorn.compiler.splitter.threshold", 32768);

    public Splitter(Compiler compiler, FunctionNode functionNode, CompileUnit scriptCompileUnit) {
        this.compiler = compiler;
        this.functionNode = functionNode;
        this.scriptCompileUnit = scriptCompileUnit;
    }

    void split() {
        long weight = WeighNodes.weigh(this.functionNode);
        if (weight >= SPLIT_THRESHOLD) {
            Compiler.LOG.info("Splitting '" + this.functionNode.getName() + "' as its weight " + weight + " exceeds split threshold " + SPLIT_THRESHOLD);
            this.functionNode.accept(this);
            if (this.functionNode.isSplit()) {
                weight = WeighNodes.weigh(this.functionNode, this.weightCache);
            }
            if (weight >= SPLIT_THRESHOLD) {
                weight = this.splitBlock(this.functionNode);
            }
            if (this.functionNode.isSplit()) {
                this.functionNode.accept(new SplitFlowAnalyzer());
            }
        }
        assert (this.functionNode.getCompileUnit() == null) : "compile unit already set";
        if (this.functionNode.isScript()) {
            assert (this.scriptCompileUnit != null) : "script compile unit is null";
            this.functionNode.setCompileUnit(this.scriptCompileUnit);
            this.scriptCompileUnit.addWeight(weight + 40L);
        } else {
            this.functionNode.setCompileUnit(this.findUnit(weight));
        }
        List<FunctionNode> functions = this.functionNode.getFunctions();
        for (FunctionNode function : functions) {
            new Splitter(this.compiler, function, this.scriptCompileUnit).split();
        }
    }

    protected CompileUnit findUnit(long weight) {
        return this.compiler.findUnit(weight);
    }

    private long splitBlock(Block block) {
        this.functionNode.setIsSplit();
        ArrayList<Node> splits = new ArrayList<Node>();
        ArrayList<Node> statements = new ArrayList<Node>();
        long statementsWeight = 0L;
        for (Node statement : block.getStatements()) {
            long weight = WeighNodes.weigh(statement, this.weightCache);
            if ((statementsWeight + weight >= SPLIT_THRESHOLD || statement.isTerminal()) && !statements.isEmpty()) {
                splits.add(this.createBlockSplitNode(block, statements, statementsWeight));
                statements = new ArrayList();
                statementsWeight = 0L;
            }
            if (statement.isTerminal()) {
                splits.add(statement);
                continue;
            }
            statements.add(statement);
            statementsWeight += weight;
        }
        if (!statements.isEmpty()) {
            splits.add(this.createBlockSplitNode(block, statements, statementsWeight));
        }
        block.setStatements(splits);
        return WeighNodes.weigh(block, this.weightCache);
    }

    private SplitNode createBlockSplitNode(Block parent, List<Node> statements, long weight) {
        Source source = parent.getSource();
        long token = parent.getToken();
        int finish = parent.getFinish();
        String name = this.compiler.uniqueName(CompilerConstants.SPLIT_PREFIX.tag());
        Block newBlock = new Block(source, token, finish, parent, this.functionNode);
        newBlock.setFrame(new Frame(parent.getFrame()));
        newBlock.setStatements(statements);
        SplitNode splitNode = new SplitNode(name, this.functionNode, newBlock);
        splitNode.setCompileUnit(this.compiler.findUnit(weight + 40L));
        return splitNode;
    }

    @Override
    public Node enter(Block block) {
        if (block.isCatchBlock()) {
            return null;
        }
        long weight = WeighNodes.weigh(block, this.weightCache);
        if (weight < SPLIT_THRESHOLD) {
            this.weightCache.put(block, weight);
            return null;
        }
        return block;
    }

    @Override
    public Node leave(Block block) {
        assert (!block.isCatchBlock());
        long weight = WeighNodes.weigh(block, this.weightCache);
        if (weight >= SPLIT_THRESHOLD) {
            weight = this.splitBlock(block);
        }
        this.weightCache.put(block, weight);
        return block;
    }

    @Override
    public Node leave(LiteralNode literal) {
        long weight = WeighNodes.weigh(literal);
        if (weight < SPLIT_THRESHOLD) {
            return literal;
        }
        this.functionNode.setIsSplit();
        if (literal instanceof LiteralNode.ArrayLiteralNode) {
            LiteralNode.ArrayLiteralNode arrayLiteralNode = (LiteralNode.ArrayLiteralNode)literal;
            Node[] value = (Node[])arrayLiteralNode.getValue();
            int[] postsets = arrayLiteralNode.getPostsets();
            ArrayList<LiteralNode.ArrayLiteralNode.ArrayUnit> units = new ArrayList<LiteralNode.ArrayLiteralNode.ArrayUnit>();
            long totalWeight = 0L;
            int lo = 0;
            for (int i = 0; i < postsets.length; ++i) {
                int postset = postsets[i];
                Node element = value[postset];
                weight = WeighNodes.weigh(element);
                if ((totalWeight += weight) < SPLIT_THRESHOLD) continue;
                CompileUnit unit = this.compiler.findUnit(totalWeight - weight);
                units.add(new LiteralNode.ArrayLiteralNode.ArrayUnit(unit, lo, i));
                lo = i;
                totalWeight = weight;
            }
            if (lo != postsets.length) {
                CompileUnit unit = this.compiler.findUnit(totalWeight);
                units.add(new LiteralNode.ArrayLiteralNode.ArrayUnit(unit, lo, postsets.length));
            }
            arrayLiteralNode.setUnits(units);
        }
        return literal;
    }

    @Override
    public Node enter(FunctionNode node) {
        List<Node> statements = node.getStatements();
        for (Node statement : statements) {
            statement.accept(this);
        }
        return null;
    }

    static class SplitFlowAnalyzer
    extends NodeVisitor {
        private final Deque<SplitNode> splitStack;
        private final Map<Node, SplitNode> targetNodes = new HashMap<Node, SplitNode>();

        SplitFlowAnalyzer() {
            this.splitStack = new LinkedList<SplitNode>();
        }

        @Override
        public Node enter(LabelNode labelNode) {
            this.registerJumpTarget(labelNode.getBreakNode());
            this.registerJumpTarget(labelNode.getContinueNode());
            return labelNode;
        }

        @Override
        public Node enter(WhileNode whileNode) {
            this.registerJumpTarget(whileNode);
            return whileNode;
        }

        @Override
        public Node enter(DoWhileNode doWhileNode) {
            this.registerJumpTarget(doWhileNode);
            return doWhileNode;
        }

        @Override
        public Node enter(ForNode forNode) {
            this.registerJumpTarget(forNode);
            return forNode;
        }

        @Override
        public Node enter(SwitchNode switchNode) {
            this.registerJumpTarget(switchNode);
            return switchNode;
        }

        @Override
        public Node enter(ReturnNode returnNode) {
            for (SplitNode split : this.splitStack) {
                split.setHasReturn(true);
            }
            return returnNode;
        }

        @Override
        public Node enter(ContinueNode continueNode) {
            this.searchJumpTarget(continueNode.getTargetNode(), continueNode.getTargetLabel());
            return continueNode;
        }

        @Override
        public Node enter(BreakNode breakNode) {
            this.searchJumpTarget(breakNode.getTargetNode(), breakNode.getTargetLabel());
            return breakNode;
        }

        @Override
        public Node enter(SplitNode splitNode) {
            this.splitStack.addFirst(splitNode);
            return splitNode;
        }

        @Override
        public Node leave(SplitNode splitNode) {
            assert (splitNode == this.splitStack.peekFirst());
            this.splitStack.removeFirst();
            return splitNode;
        }

        private void registerJumpTarget(Node targetNode) {
            SplitNode splitNode = this.splitStack.peekFirst();
            if (splitNode != null) {
                this.targetNodes.put(targetNode, splitNode);
            }
        }

        private void searchJumpTarget(Node targetNode, MethodEmitter.Label targetLabel) {
            SplitNode targetSplit = this.targetNodes.get(targetNode);
            for (SplitNode split : this.splitStack) {
                if (split == targetSplit) break;
                List<MethodEmitter.Label> externalTargets = split.getExternalTargets();
                if (externalTargets.contains((Object)targetLabel)) continue;
                split.addExternalTarget(targetLabel);
            }
        }
    }
}

