/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.idm.remote.server.efm4.impl.push;

import de.proveo.idm.remote.server.communication.api.ClientListener;
import de.proveo.idm.remote.server.communication.api.ClientWatchdog;
import de.proveo.idm.remote.server.efm4.impl.push.PushConnectionImpl;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;

public class ConnectionReader
extends Thread {
    private static final Logger log = Logger.getLogger(ConnectionReader.class.getName());
    private static final long MISSING_EVENT_RECONNECT_WAIT_TIME = 60000L;
    private static final long MISSING_EVENT_RECEIVE_WAIT_TIME = 20000L;
    private final List<ClientListener> clientListeners = new ArrayList<ClientListener>();
    private final Object clientListenersLock = new Object();
    private final Object missingEventsLock = new Object();
    private final Map<Integer, Long> missingEvents = new HashMap<Integer, Long>();
    private int lastEventNumber = 0;
    private volatile boolean compression = true;
    private volatile boolean running = true;
    private PushConnectionImpl pushConnection;
    private ObjectInputStream objectInputStream;
    private ClientWatchdog clientWatchdog;

    public ConnectionReader(PushConnectionImpl pushConnection, ObjectInputStream ois, ClientWatchdog clientWatchdog) {
        super("ConnectionReader");
        this.pushConnection = pushConnection;
        this.objectInputStream = ois;
        this.clientWatchdog = clientWatchdog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addClientListener(ClientListener clientListener) {
        Object object = this.clientListenersLock;
        synchronized (object) {
            this.clientListeners.add(clientListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeClientListener(ClientListener clientListener) {
        Object object = this.clientListenersLock;
        synchronized (object) {
            this.clientListeners.remove(clientListener);
        }
    }

    public boolean isRunning() {
        return this.running;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        this.running = false;
        Object object = this.clientListenersLock;
        synchronized (object) {
            this.clientListeners.clear();
        }
        log.info("ConnectionReader disconnected, will be deleted by garbage collector!");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        block8: {
            String method = "run(): ";
            try {
                while (this.running) {
                    try {
                        Object event = this.objectInputStream.readObject();
                        if (this.compression) {
                            event = this.uncompressEvent(event);
                        }
                        if (event == null || !this.running) continue;
                        this.forwardEvent(event);
                    }
                    catch (IOException ioe) {
                        if (!this.running) {
                            log.log(Level.INFO, "{0}Connection closed", method);
                            continue;
                        }
                        if (this.clientWatchdog == null) continue;
                        log.log(Level.INFO, "{0}Error while reading from ObjectInputStream", method);
                        this.clientWatchdog.onConnectionError((Throwable)ioe);
                    }
                    catch (ClassNotFoundException cnfe) {
                        log.log(Level.SEVERE, method + "runs into ClassNotFoundException:", cnfe);
                    }
                }
            }
            catch (Throwable ex) {
                log.log(Level.SEVERE, "Unexpected exception while reading from HTTP stream", ex);
                if (!this.running || this.clientWatchdog == null) break block8;
                this.clientWatchdog.onConnectionError(ex);
            }
        }
        this.running = false;
    }

    protected void finalize() throws Throwable {
        log.log(Level.INFO, "{0} deleted by garbage collector!", this.toString());
        super.finalize();
    }

    private Object uncompressEvent(Object event) {
        Object uncompressedEvent;
        try {
            ByteArrayInputStream arrayInputStream = new ByteArrayInputStream((byte[])event);
            GZIPInputStream gZIPinputStream = new GZIPInputStream(arrayInputStream);
            ObjectInputStream ois = new ObjectInputStream(gZIPinputStream);
            uncompressedEvent = ois.readObject();
            gZIPinputStream.close();
            ois.close();
        }
        catch (Throwable e) {
            log.log(Level.INFO, "The received event seems to be uncompressed, deactivating compression and returning the original Object", e);
            this.compression = false;
            return event;
        }
        return uncompressedEvent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void forwardEvent(Object event) {
        block36: {
            String method = "forwardEvent(): ";
            try {
                long currentTime = System.currentTimeMillis();
                if (this.clientWatchdog != null) {
                    this.clientWatchdog.onEventReceived(currentTime);
                }
                if (event instanceof String) {
                    if (((String)event).equals("p")) {
                        log.log(Level.FINE, "{0}client received ping signal", method);
                        this.clientWatchdog.onPingReceived(currentTime);
                    } else {
                        log.log(Level.SEVERE, "{0}client received unknown string object ''{1}''", new Object[]{method, event});
                    }
                    return;
                }
                if (event instanceof Long) {
                    long serverTime = (Long)event;
                    if (serverTime > 0L) {
                        ArrayList<ClientListener> clientListenersCopy2;
                        log.log(Level.FINE, "{0}client received server timestamp for time sync", method);
                        Iterator iterator = this.clientListenersLock;
                        synchronized (iterator) {
                            clientListenersCopy2 = new ArrayList<ClientListener>(this.clientListeners);
                        }
                        for (ClientListener cl : clientListenersCopy2) {
                            cl.onServerTime(serverTime);
                        }
                    } else {
                        log.log(Level.SEVERE, "{0}client received Ping with server time ''{1}''", new Object[]{method, serverTime});
                    }
                    return;
                }
                if (event instanceof Map) {
                    ArrayList<ClientListener> clientListenersCopy;
                    Iterator clientListenersCopy2;
                    Map eventMap = (Map)event;
                    if (eventMap.containsKey("EventNumber")) {
                        Integer eventNumber = (Integer)eventMap.get("EventNumber");
                        log.log(Level.FINE, "Current event number: {0}", eventNumber);
                        if (eventNumber - 1 != this.lastEventNumber) {
                            clientListenersCopy2 = this.missingEventsLock;
                            synchronized (clientListenersCopy2) {
                                if (this.missingEvents.containsKey(eventNumber)) {
                                    log.log(Level.INFO, "{0}Received missing event number ''{1}''. Removing it from list of missing events.", new Object[]{method, eventNumber});
                                    this.missingEvents.remove(eventNumber);
                                } else {
                                    int missingEventNumberRange = eventNumber - this.lastEventNumber;
                                    for (int i = 1; i < missingEventNumberRange; ++i) {
                                        int en = this.lastEventNumber + i;
                                        log.log(Level.SEVERE, "{0}Missing event number: ''{1}''. Last event number was ''{2}'', but current event''s number is ''{3}''! Remember event number and wait {4}s for receiving it ...", new Object[]{method, en, this.lastEventNumber, eventNumber, 20L});
                                        this.missingEvents.put(en, System.currentTimeMillis());
                                    }
                                }
                            }
                        }
                        if (eventNumber > this.lastEventNumber) {
                            this.lastEventNumber = eventNumber;
                        }
                    } else if (this.lastEventNumber > 0) {
                        log.log(Level.WARNING, "Received an event without any event number information: {0}", event);
                    }
                    clientListenersCopy2 = this.clientListenersLock;
                    synchronized (clientListenersCopy2) {
                        clientListenersCopy = new ArrayList<ClientListener>(this.clientListeners);
                    }
                    for (ClientListener cl : clientListenersCopy) {
                        cl.onEvent(eventMap);
                    }
                }
                Object object = this.missingEventsLock;
                synchronized (object) {
                    if (!this.missingEvents.isEmpty()) {
                        long lastReconnect;
                        boolean reconnect = false;
                        for (int eventNumber : this.missingEvents.keySet()) {
                            long time = this.missingEvents.get(eventNumber);
                            if (System.currentTimeMillis() - time <= 20000L) continue;
                            reconnect = true;
                            break;
                        }
                        if (reconnect && (lastReconnect = System.currentTimeMillis() - this.pushConnection.getLastSuccessfulConnectionTimestamp()) > 60000L) {
                            this.missingEvents.clear();
                            log.log(Level.INFO, "{0}Cutting connection because of missing event(s) some time ago ...", method);
                            if (this.running && this.clientWatchdog != null) {
                                this.clientWatchdog.onMissingEvent();
                            }
                            log.log(Level.INFO, "{0}Connection cutted. MapObserver will reconnect ...", method);
                        }
                    }
                }
            }
            catch (Throwable e) {
                log.log(Level.SEVERE, method + "Error while trying to handle and forward event!", e);
                if (!this.running || this.clientWatchdog == null) break block36;
                this.clientWatchdog.onConnectionError(e);
            }
        }
    }
}

