/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.idm.remote.server.efm4.impl;

import de.proveo.idm.remote.server.communication.api.ClientListener;
import de.proveo.idm.remote.server.communication.api.ClientWatchdog;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;

public class ReplayConnectionReader
extends Thread {
    private static final Logger log = Logger.getLogger(ReplayConnectionReader.class.getName());
    private volatile boolean compression = true;
    private volatile boolean running = true;
    private final ClientListener clientListener;
    private final ObjectInputStream objectInputStream;
    private final ClientWatchdog clientWatchdog;

    public ReplayConnectionReader(ObjectInputStream ois, ClientWatchdog clientWatchdog, ClientListener clientListener) {
        super("ReplayConnectionReader");
        this.objectInputStream = ois;
        this.clientWatchdog = clientWatchdog;
        this.clientListener = clientListener;
    }

    public boolean isRunning() {
        return this.running;
    }

    public void disconnect() {
        this.running = false;
        log.info("ReplayConnectionReader disconnected, will be deleted by garbage collector!");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        block8: {
            String method = "run(): ";
            try {
                while (this.running) {
                    try {
                        Object event = this.objectInputStream.readObject();
                        if (this.compression) {
                            event = this.uncompressEvent(event);
                        }
                        if (event == null || !this.running) continue;
                        this.forwardEvent(event);
                    }
                    catch (IOException ioe) {
                        if (!this.running) {
                            log.log(Level.INFO, "{0}Connection closed", method);
                            continue;
                        }
                        log.log(Level.INFO, "{0}Error while reading from ObjectInputStream", method);
                        if (this.clientWatchdog == null) continue;
                        this.clientWatchdog.onConnectionError((Throwable)ioe);
                    }
                    catch (ClassNotFoundException cnfe) {
                        log.log(Level.SEVERE, method + "runs into ClassNotFoundException:", cnfe);
                    }
                }
            }
            catch (Throwable ex) {
                log.log(Level.SEVERE, "Unexpected exception while reading from HTTP stream", ex);
                if (!this.running || this.clientWatchdog == null) break block8;
                this.clientWatchdog.onConnectionError(ex);
            }
        }
        this.running = false;
    }

    protected void finalize() throws Throwable {
        log.log(Level.INFO, "{0} deleted by garbage collector!", this.toString());
        super.finalize();
    }

    private Object uncompressEvent(Object event) {
        Object uncompressedEvent;
        try {
            ByteArrayInputStream arrayInputStream = new ByteArrayInputStream((byte[])event);
            GZIPInputStream gZIPinputStream = new GZIPInputStream(arrayInputStream);
            ObjectInputStream ois = new ObjectInputStream(gZIPinputStream);
            uncompressedEvent = ois.readObject();
            gZIPinputStream.close();
            ois.close();
        }
        catch (Throwable e) {
            log.log(Level.INFO, "The received event seems to be uncompressed, deactivating compression and returning the original Object", e);
            this.compression = false;
            return event;
        }
        return uncompressedEvent;
    }

    private void forwardEvent(Object event) {
        block12: {
            String method = "forwardEvent(): ";
            try {
                long currentTime = System.currentTimeMillis();
                if (this.clientWatchdog != null) {
                    this.clientWatchdog.onEventReceived(currentTime);
                }
                if (event instanceof String) {
                    if (((String)event).equals("p")) {
                        log.log(Level.FINE, "{0}client received ping signal", method);
                        this.clientWatchdog.onPingReceived(currentTime);
                    } else {
                        log.log(Level.SEVERE, "{0}client received unknown string object ''{1}''", new Object[]{method, event});
                    }
                } else if (event instanceof Long) {
                    long serverTime = (Long)event;
                    if (serverTime > 0L) {
                        log.log(Level.FINE, "{0}client received server timestamp for time sync", method);
                        this.clientListener.onServerTime(serverTime);
                    } else {
                        log.log(Level.SEVERE, "{0}client received Ping with server time ''{1}''", new Object[]{method, serverTime});
                    }
                } else if (event instanceof Map) {
                    Map eventMap = (Map)event;
                    this.clientListener.onEvent(eventMap);
                }
            }
            catch (Throwable e) {
                log.log(Level.SEVERE, method + "Error while trying to handle and forward event!", e);
                if (!this.running || this.clientWatchdog == null) break block12;
                this.clientWatchdog.onConnectionError(e);
            }
        }
    }
}

