/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.idm.remote.server.efm4.impl;

import de.proveo.domain.values.datasync.DatasyncMetainfoValue;
import de.proveo.domain.values.datasync.DatasyncResourceValue;
import de.proveo.domain.values.datasync.DatasyncStatusValue;
import de.proveo.domain.values.datasync.DatasyncTaskValue;
import de.proveo.domain.values.infoman.MetaInfoKey;
import de.proveo.idm.core.gui.navigation.api.Credentials;
import de.proveo.idm.core.gui.navigation.api.Device;
import de.proveo.idm.remote.server.api.RemoteDeviceId;
import de.proveo.idm.remote.server.api.RemoteInfoman;
import de.proveo.idm.remote.server.api.RemoteUpdateAdapter;
import de.proveo.idm.remote.server.efm4.impl.EFMServer4;
import de.proveo.idm.remote.server.efm4.impl.InfomanSoftwareDescriptionValueAdapter;
import de.proveo.idm.remote.server.services.ShaSumGenerator;
import de.proveo.wwt.logic.ejb.general.infoman.setup.update.ScheduledInfomanUpdateValue;
import de.proveo.wwt.logic.ejb.general.infoman.software.InfomanSoftwareDescriptionValue;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.openide.util.Exceptions;

public class RemoteUpdateAdapterImpl
implements RemoteUpdateAdapter {
    private static final Logger log = Logger.getLogger(RemoteUpdateAdapterImpl.class.getName());
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private final EFMServer4 server;

    public RemoteUpdateAdapterImpl(EFMServer4 server) {
        this.server = server;
    }

    public synchronized Collection<DatasyncResourceValue> getAvailableSoftware() throws Exception {
        ArrayList<DatasyncResourceValue> ret = new ArrayList<DatasyncResourceValue>();
        try {
            List software = (List)this.server.executeCall("GetAvailableInfomanSoftware", this.prepareCall());
            for (InfomanSoftwareDescriptionValue value : software) {
                ret.add(new InfomanSoftwareDescriptionValueAdapter(value));
            }
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return ret;
    }

    public Collection<DatasyncResourceValue> getAvailableSoftware(Device.DeviceType deviceType) throws Exception {
        return new ArrayList<DatasyncResourceValue>();
    }

    public Collection<DatasyncResourceValue> getAvailableResources(String filter) throws Exception {
        return new ArrayList<DatasyncResourceValue>();
    }

    public Collection<DatasyncResourceValue> getAvailableResources(Device.DeviceType deviceType, String resourceType) throws Exception {
        return new ArrayList<DatasyncResourceValue>();
    }

    public Collection<DatasyncResourceValue> getAvailableDatasyncResources() throws Exception {
        return new ArrayList<DatasyncResourceValue>();
    }

    public DatasyncTaskValue createTask(Device.DeviceType deviceType, DatasyncTaskValue task) throws Exception {
        return this.executeRemoteUpdate(task);
    }

    public List<DatasyncTaskValue> createTasks(Device.DeviceType deviceType, List<DatasyncTaskValue> tasks, DatasyncResourceValue resource) throws Exception {
        ArrayList<DatasyncTaskValue> ret = new ArrayList<DatasyncTaskValue>();
        for (DatasyncTaskValue task : tasks) {
            task.addResources(resource);
            ret.add(this.executeRemoteUpdate(task));
        }
        return ret;
    }

    public void editTask(DatasyncTaskValue task) throws Exception {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public DatasyncStatusValue cancelTask(DatasyncTaskValue task, String remark) throws Exception {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public DatasyncResourceValue uploadResource(String identifier, DatasyncResourceValue value) throws Exception {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public DatasyncResourceValue updateResource(DatasyncResourceValue value) throws Exception {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public byte[] getResourceContent(long resourceId) throws Exception {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Map<RemoteDeviceId, Collection<DatasyncTaskValue>> getTasks() throws Exception {
        HashMap<RemoteDeviceId, Collection<DatasyncTaskValue>> map = new HashMap<RemoteDeviceId, Collection<DatasyncTaskValue>>();
        Collection infomans = this.server.getServerUnits();
        for (RemoteInfoman infoman : infomans) {
            RemoteDeviceId id = infoman.getId();
            Collection<DatasyncTaskValue> tasks = this.getTasks(id);
            if (tasks == null || tasks.isEmpty()) continue;
            map.put(id, tasks);
        }
        return map;
    }

    public Collection<DatasyncTaskValue> getTasks(RemoteDeviceId remoteInfomanId) throws Exception {
        return null;
    }

    public DatasyncTaskValue getTask(long taskId) throws Exception {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public DatasyncStatusValue getTaskStatus(long taskId) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private DatasyncTaskValue executeRemoteUpdate(DatasyncTaskValue task) throws Exception {
        long unitId = task.getClientId();
        List resources = task.getResources();
        DatasyncResourceValue configurationUpdateValue = new DatasyncResourceValue();
        InfomanSoftwareDescriptionValueAdapter softwareUpdateValue = null;
        if (resources.size() == 1) {
            DatasyncResourceValue resource = (DatasyncResourceValue)resources.get(0);
            if (resource instanceof InfomanSoftwareDescriptionValueAdapter) {
                softwareUpdateValue = (InfomanSoftwareDescriptionValueAdapter)resource;
            } else {
                configurationUpdateValue = resource;
            }
        } else if (resources.size() == 2) {
            DatasyncResourceValue resource1 = (DatasyncResourceValue)resources.get(0);
            DatasyncResourceValue resource2 = (DatasyncResourceValue)resources.get(1);
            if (resource1 instanceof InfomanSoftwareDescriptionValueAdapter) {
                softwareUpdateValue = (InfomanSoftwareDescriptionValueAdapter)resource1;
            } else {
                configurationUpdateValue = resource1;
            }
            if (resource2 instanceof InfomanSoftwareDescriptionValueAdapter) {
                if (softwareUpdateValue != null) {
                    throw new IllegalArgumentException("Got two software updates and no configuration!");
                }
                softwareUpdateValue = (InfomanSoftwareDescriptionValueAdapter)resource2;
            } else {
                if (configurationUpdateValue.equals(resource1)) {
                    throw new IllegalArgumentException("Got two configuration updates and no software!");
                }
                configurationUpdateValue = resource2;
            }
        } else {
            throw new IllegalArgumentException("Unexpected amount of resources: " + resources.size());
        }
        ScheduledInfomanUpdateValue updateValue = new ScheduledInfomanUpdateValue();
        updateValue.setConfiguration(configurationUpdateValue.getResource());
        updateValue.setConfigurationChecksum(configurationUpdateValue.getChecksum());
        updateValue.setConfigurationName(configurationUpdateValue.getResourceName());
        updateValue.setScheduledTime(task.getValidFrom());
        if (configurationUpdateValue.getResource() != null) {
            List metaInfos = configurationUpdateValue.getMetainfos();
            if (metaInfos != null) {
                updateValue.setConfigurationChecksumType(RemoteUpdateAdapterImpl.extractMetaInfo(MetaInfoKey.CHECKSUM_TYPE.toString(), metaInfos));
                updateValue.setConfigurationContentType(RemoteUpdateAdapterImpl.extractMetaInfo(MetaInfoKey.CONTENT_TYPE.toString(), metaInfos));
            } else {
                log.warning("Update contains configuration, but meta info is missing!");
            }
        }
        HashMap<String, Object> callValues = new HashMap<String, Object>();
        callValues.putAll(this.prepareCall());
        callValues.put("unitId", unitId);
        callValues.put("updateValue", updateValue);
        ScheduledInfomanUpdateValue value = (ScheduledInfomanUpdateValue)this.server.executeCall("CreatePlanedInfomanUpdate", callValues);
        if (softwareUpdateValue != null) {
            InfomanSoftwareDescriptionValue isdv = softwareUpdateValue.getResourceInstance();
            long softwareId = isdv.getId();
            callValues = new HashMap();
            callValues.putAll(this.prepareCall());
            callValues.put("planedUpdateId", value.getId());
            callValues.put("infomanSoftwareId", softwareId);
            this.server.executeCall("SetInfomanSoftwareForPlanedUpdate", callValues);
        }
        return task;
    }

    private static String extractMetaInfo(String key, List<DatasyncMetainfoValue> values) throws Exception {
        for (DatasyncMetainfoValue value : values) {
            if (!key.equals(value.getKey())) continue;
            return value.getValue();
        }
        return null;
    }

    private Map<String, Object> prepareCall() throws Exception {
        Credentials credentials = this.server.getIDMCredentials();
        HashMap<String, Object> map = new HashMap<String, Object>();
        String password = new String(credentials.getPassword());
        String hash = ShaSumGenerator.plainStringToSHA1((String)password);
        map.put("username", credentials.getUsername());
        map.put("password", hash.toCharArray());
        return map;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    public boolean hasTasks() {
        return false;
    }
}

