/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.idm.remote.server.efm4.impl;

import de.proveo.client.configuration.api.Configuration;
import de.proveo.client.configuration.api.ConfigurationChangedListener;
import de.proveo.client.configuration.api.ConfigurationParameters;
import de.proveo.client.configuration.api.ConfigurationProvider;
import de.proveo.idm.core.gui.navigation.api.AppearancePreferencesProvider;
import de.proveo.idm.core.gui.navigation.api.Credentials;
import de.proveo.idm.core.gui.util.DialogUtil;
import de.proveo.idm.licensing.api.PermissionHandler;
import de.proveo.idm.licensing.api.PermissionHandlerFactory;
import de.proveo.idm.remote.server.api.RemoteMapAdapter;
import de.proveo.idm.remote.server.communication.api.ClientWatchdog;
import de.proveo.idm.remote.server.communication.api.CommunicationConstants;
import de.proveo.idm.remote.server.communication.api.ConnectionStatistics;
import de.proveo.idm.remote.server.communication.api.ServletConnection;
import de.proveo.idm.remote.server.communication.api.UnitTreeNode;
import de.proveo.idm.remote.server.communication.api.exceptions.ReplayDataNotLoadedException;
import de.proveo.idm.remote.server.efm4.impl.ClientReplayWatchdog;
import de.proveo.idm.remote.server.efm4.impl.EFMServer4;
import de.proveo.idm.remote.server.efm4.impl.ReplayClientListener;
import de.proveo.idm.remote.server.efm4.impl.ReplayConnectionReader;
import de.proveo.idm.remote.server.efm4.impl.push.PushConnectionImpl;
import de.proveo.idm.remote.server.push.api.DataStorageProxy;
import de.proveo.idm.remote.server.push.api.PushConnection;
import de.proveo.idm.remote.server.services.ShaSumGenerator;
import de.proveo.util.date.DateUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import javax.security.auth.login.LoginException;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public class RemoteMapAdapterImpl
implements RemoteMapAdapter,
PreferenceChangeListener,
ConfigurationChangedListener {
    private static final Logger log = Logger.getLogger(RemoteMapAdapterImpl.class.getName());
    private static final long RECONNECT_ERROR_WAITTIME = 120000L;
    private static final long RECONNECT_MINIMUM_LAST_CONNECT = 10000L;
    private static final int RECONNECT_MAXIMUM = 5;
    private static final String PARAM_USERNAME = "username";
    private static final String PARAM_PASSWORD = "password";
    private static final String PARAM_AIRPORT_ID = "airportId";
    private static final String PARAM_AREAS = "areas";
    private static final String PARAM_SEND_DELETED = "sendDeleted";
    private static final String PARAM_SEND_AIRPORTMAP_AREAS = "sendAirportMapAreas";
    private static final String PARAM_SEND_GEOFENCING_AREAS = "sendGeoFencingAreas";
    private final Object replayDataLock = new Object();
    private ServletConnection replayServletConnection = null;
    private ServletConnection servletConnection = null;
    private ObjectInputStream objectInputStream = null;
    private ReplayConnectionReader replayConnectionReader = null;
    private ClientWatchdog replayWatchdog = null;
    private DateUtil clientDateUtil;
    private Map<String, String> servletParameters = null;
    private Map replayData = null;
    private volatile boolean reconnecting = false;
    private long lastSuccessfulConnect = 0L;
    private int reconnectTries = 0;
    private long reconnectWaitTime = 1000L;
    private int reconnectLongTimePeriodeTries = 0;
    private Configuration configuration = null;
    private EFMServer4 server;

    public RemoteMapAdapterImpl(EFMServer4 server) {
        this.server = server;
        this.initClientDateUtil();
        Preferences prefs = NbPreferences.forModule(AppearancePreferencesProvider.class);
        prefs.addPreferenceChangeListener(this);
        ConfigurationProvider cp = this.server.getConfigurationProvider();
        cp.addConfigurationChangedListener((ConfigurationChangedListener)this);
        this.configuration = cp.getActiveConfiguration();
    }

    private void _stopPolling() {
        if (this.replayConnectionReader != null) {
            this.replayConnectionReader.disconnect();
            this.replayConnectionReader = null;
        }
        if (this.replayServletConnection != null) {
            this.replayServletConnection.close();
            this.replayServletConnection = null;
        }
    }

    public void configurationChanged(Configuration oldConfig, Configuration newConfig) {
        this.configuration = newConfig;
    }

    protected UnitTreeNode builUnitNode(Map treeNodes) {
        UnitTreeNode node = null;
        for (Object tmp : treeNodes.keySet()) {
            long unitId;
            block9: {
                if (tmp != null && tmp.toString().trim().length() > 0) {
                    try {
                        unitId = (Long)tmp;
                        break block9;
                    }
                    catch (ClassCastException ex) {
                        log.log(Level.WARNING, "Could not find unitId in unit tree, read this: {0}", tmp);
                        continue;
                    }
                }
                log.log(Level.WARNING, "Could not find unitId in unit tree, read this: {0}", tmp);
                continue;
            }
            Map valuesMap = (Map)treeNodes.get(unitId);
            tmp = valuesMap.get("name");
            String unitName = "";
            if (tmp != null) {
                unitName = (String)tmp;
            }
            tmp = valuesMap.get("imageName");
            String imageName = null;
            if (tmp != null) {
                imageName = (String)tmp;
            }
            tmp = valuesMap.get("allowsChildren");
            boolean allowsChildren = false;
            if (tmp != null) {
                allowsChildren = (Boolean)tmp;
            }
            if (allowsChildren) {
                ArrayList children = (ArrayList)valuesMap.get("children");
                node = new UnitTreeNode((Object)unitName, unitId, imageName, true, false);
                if (children == null) continue;
                for (Map child : children) {
                    UnitTreeNode childTreeNode = this.builUnitNode(child);
                    node.add((MutableTreeNode)childTreeNode);
                }
                continue;
            }
            node = new UnitTreeNode((Object)unitName, unitId, imageName, true, false);
        }
        return node;
    }

    private void createReplayConnectionReader(ObjectInputStream objectInputStream, ConnectionStatistics connectionStatistics) {
        if (this.replayConnectionReader != null) {
            this.replayConnectionReader.disconnect();
            this.replayConnectionReader = null;
        }
        if (this.replayWatchdog == null) {
            this.replayWatchdog = new ClientReplayWatchdog(this, connectionStatistics);
            this.replayWatchdog.start();
        }
        this.replayConnectionReader = new ReplayConnectionReader(objectInputStream, this.replayWatchdog, new ReplayClientListener(this, connectionStatistics));
        this.replayConnectionReader.start();
    }

    public String executeServletCall(String path, Map<String, String> parameters) throws Exception {
        String urlString = this.prepareServletCall(path, parameters);
        return this.servletConnection.readString(urlString);
    }

    public Object executeServletCallObject(String path, Map<String, String> parameters) throws Exception {
        String urlString = this.prepareServletCall(path, parameters);
        return this.servletConnection.readObject(urlString);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Long getAirportId(CommunicationConstants.AreaMode areaMode) throws Throwable {
        String username = null;
        char[] password = null;
        Credentials credentials = this.server.getIDMCredentials();
        if (credentials != null) {
            username = credentials.getUsername();
            password = credentials.getPassword();
        }
        if (username == null) return null;
        if (password == null) {
            return null;
        }
        char[] passwordHash = ShaSumGenerator.plainStringToSHA1((String)new String(password)).toCharArray();
        PermissionHandler ph = PermissionHandlerFactory.getDefault();
        HashMap<String, Object> callValues = new HashMap<String, Object>();
        callValues.put(PARAM_USERNAME, username);
        callValues.put(PARAM_PASSWORD, passwordHash);
        callValues.put(PARAM_SEND_DELETED, ph.isSuperadmin((Object)this.server.getServerData()) || ph.hasPermissionForRoles((Object)this.server.getServerData(), new String[]{"section.airportmapgenerator_admin"}));
        if (CommunicationConstants.AreaMode.NONE.equals((Object)areaMode)) {
            callValues.put(PARAM_SEND_AIRPORTMAP_AREAS, false);
            callValues.put(PARAM_SEND_GEOFENCING_AREAS, false);
        } else {
            log.log(Level.INFO, "WORKING MODE: {0}", areaMode.toString());
            boolean geoFencingAreas = CommunicationConstants.AreaMode.GEO_FENCING.equals((Object)areaMode);
            callValues.put(PARAM_SEND_AIRPORTMAP_AREAS, !geoFencingAreas);
            callValues.put(PARAM_SEND_GEOFENCING_AREAS, geoFencingAreas);
        }
        Long airportId = -1L;
        Object result = null;
        result = this.server.executeCall("GetUnitGroupsTree", callValues);
        if (result == null) return null;
        if (result instanceof Throwable) {
            throw (Throwable)result;
        }
        if (result instanceof HashMap) {
            HashMap unitTreeNode = (HashMap)result;
            UnitTreeNode treeNode = this.builUnitNode(unitTreeNode);
            DefaultTreeModel treeModel = new DefaultTreeModel((TreeNode)treeNode);
            JPanel panel = new JPanel(new BorderLayout());
            JTree tree = new JTree(treeModel);
            JScrollPane scrollPane = new JScrollPane(tree);
            JLabel warningLbl = new JLabel(NbBundle.getMessage(RemoteMapAdapterImpl.class, (String)"RemoteMapAdapterImpl.txtChooseAirportWarning"));
            JLabel warning2Lbl = new JLabel(NbBundle.getMessage(RemoteMapAdapterImpl.class, (String)"RemoteMapAdapterImpl.txtChooseAirportWarning2"));
            panel.add((Component)scrollPane, "North");
            panel.add((Component)warningLbl, "Center");
            panel.add((Component)warning2Lbl, "South");
            Object n = DialogUtil.showOkCancelQuestionDialog((Object)panel, (String)NbBundle.getMessage(RemoteMapAdapterImpl.class, (String)"RemoteMapAdapterImpl.txtChooseAirport"));
            if (DialogUtil.OK_OPTION != n) return 0L;
            TreePath treePath = tree.getSelectionPath();
            if (treePath == null) return airportId;
            Object selection = treePath.getLastPathComponent();
            if (selection == null) return airportId;
            UnitTreeNode selectedGroup = (UnitTreeNode)selection;
            airportId = selectedGroup.getUnitID();
            if (airportId != 0L) return airportId;
            return null;
        }
        if (!(result instanceof Long)) throw new UnsupportedOperationException("Server returned unexpected value: '" + result + "'");
        return (Long)result;
    }

    public Map<Integer, Map<String, Object>> getAreas(Long airportId, CommunicationConstants.AreaMode areaMode, boolean fetchDeletedAreas) throws IOException, LoginException {
        String username = null;
        char[] password = null;
        Credentials credentials = this.server.getIDMCredentials();
        if (credentials != null) {
            username = credentials.getUsername();
            password = credentials.getPassword();
        }
        if (username == null || password == null) {
            return null;
        }
        char[] passwordHash = ShaSumGenerator.plainStringToSHA1((String)new String(password)).toCharArray();
        Map ht = null;
        HashMap<String, Object> callValues = new HashMap<String, Object>();
        callValues.put(PARAM_USERNAME, username);
        callValues.put(PARAM_PASSWORD, passwordHash);
        callValues.put(PARAM_SEND_DELETED, fetchDeletedAreas);
        if (CommunicationConstants.AreaMode.NONE.equals((Object)areaMode)) {
            callValues.put(PARAM_SEND_AIRPORTMAP_AREAS, false);
            callValues.put(PARAM_SEND_GEOFENCING_AREAS, false);
        } else {
            boolean geoFencingAreas = CommunicationConstants.AreaMode.GEO_FENCING.equals((Object)areaMode);
            callValues.put(PARAM_SEND_AIRPORTMAP_AREAS, !geoFencingAreas);
            callValues.put(PARAM_SEND_GEOFENCING_AREAS, geoFencingAreas);
        }
        if (airportId == null || airportId >= 0L) {
            callValues.put(PARAM_AIRPORT_ID, airportId);
        }
        try {
            Object ret = this.server.executeCall("GetAreas", callValues);
            if (ret != null) {
                ht = (Map)ret;
            }
        }
        catch (LoginException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new IOException(ex);
        }
        return ht;
    }

    public DateUtil getClientDateUtil() {
        return this.clientDateUtil;
    }

    public PushConnection getPushConnection(DataStorageProxy dataStorageProxy) {
        return new PushConnectionImpl(this, dataStorageProxy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getReplayData(long from, long to, ConnectionStatistics connectionStatistics) throws Exception {
        Credentials credentials = this.server.getIDMCredentials();
        this.servletParameters = this.getServletParameters(this.configuration, this.clientDateUtil, this.getTopicSelectors(this.configuration), credentials.getUsername(), credentials.getPassword());
        this.servletParameters.put("beginTime", Long.toString(from));
        this.servletParameters.put("endTime", Long.toString(to));
        this.initReplayConnection(this.servletParameters, connectionStatistics);
        Object object = this.replayDataLock;
        synchronized (object) {
            try {
                this.replayDataLock.wait();
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
        }
        if (this.replayWatchdog != null) {
            this.replayWatchdog.cancel(true);
            this.replayWatchdog = null;
        }
        this._stopPolling();
        this.servletParameters = null;
        return this.replayData;
    }

    protected EFMServer4 getServer() {
        return this.server;
    }

    public Map<String, String> getServletParameters(Configuration configuration, DateUtil clientDateUtil, String topicSelectors, String username, char[] password) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put(PARAM_USERNAME, username.toLowerCase());
        parameters.put(PARAM_PASSWORD, new String(password));
        parameters.put("clientId", (String)configuration.getValue(ConfigurationParameters.PARAM_TEMP_WWT_CLIENT_ID));
        parameters.put("jaas", Boolean.toString(true));
        parameters.put("compress", Boolean.toString(true));
        parameters.put("TypeOfInterest", topicSelectors);
        parameters.put("xmlSchemas", this.getXMLSchemas());
        parameters.put("unitGroupId", Long.toString((Long)configuration.getValue(ConfigurationParameters.PARAM_WWT_UNIT_GROUP_ENTRY_ID)));
        parameters.put("appVersion", (String)configuration.getValue(ConfigurationParameters.PARAM_TEMP_APPLICATION_VERSION));
        long timestamp = (Long)configuration.getValue(ConfigurationParameters.PARAM_TEMP_APPLICATION_START_TIME);
        parameters.put("appStartTime", Long.toString(timestamp));
        parameters.put("appStartTimeHumanReadable", clientDateUtil.getDateTime(timestamp));
        timestamp = (Long)configuration.getValue(ConfigurationParameters.PARAM_TEMP_APPLICATION_LOGIN_TIME);
        parameters.put("appLoginTime", Long.toString(timestamp));
        parameters.put("appLoginTimeHumanReadable", clientDateUtil.getDateTime(timestamp));
        parameters.put("osName", (String)configuration.getValue(ConfigurationParameters.PARAM_TEMP_OS_NAME));
        parameters.put("osHostName", (String)configuration.getValue(ConfigurationParameters.PARAM_TEMP_OS_HOST_NAME));
        parameters.put("osUserName", (String)configuration.getValue(ConfigurationParameters.PARAM_TEMP_OS_USER_NAME));
        parameters.put("javaRuntimeVersion", (String)configuration.getValue(ConfigurationParameters.PARAM_TEMP_JAVA_RUNTIME_VERSION));
        parameters.put("javaHome", (String)configuration.getValue(ConfigurationParameters.PARAM_TEMP_JAVA_HOME));
        parameters.put("reconnectTries", "0");
        parameters.put("reconnectTime", "0");
        return parameters;
    }

    private String getTopicSelectors(Configuration config) {
        PermissionHandler ph;
        boolean topicSelectorUseEvents;
        boolean topicSelectorNotifies;
        boolean topicSelectorStands;
        String method = "getTopicSelectors(): ";
        String topicSelectors = "";
        boolean topicSelectorUnits = (Boolean)config.getValue(ConfigurationParameters.PARAM_OBSERVABLE_TOPIC_SELECTOR_UNITS);
        if (topicSelectorUnits) {
            log.log(Level.FINE, "{0}Adding observable topic selector: units", method);
            topicSelectors = "units";
        }
        if (topicSelectorStands = ((Boolean)config.getValue(ConfigurationParameters.PARAM_OBSERVABLE_TOPIC_SELECTOR_STANDS)).booleanValue()) {
            log.log(Level.FINE, "{0}Adding observable topic selector: stands", method);
            topicSelectors = topicSelectors.length() == 0 ? "stands" : topicSelectors + ",stands";
        }
        if (topicSelectorNotifies = ((Boolean)config.getValue(ConfigurationParameters.PARAM_OBSERVABLE_TOPIC_SELECTOR_NOTIFIES)).booleanValue()) {
            log.log(Level.FINE, "{0}Adding observable topic selector: notify_messages", method);
            topicSelectors = topicSelectors.length() == 0 ? "notify_messages" : topicSelectors + ",notify_messages";
        }
        if (topicSelectorUseEvents = ((Boolean)config.getValue(ConfigurationParameters.PARAM_OBSERVABLE_TOPIC_SELECTOR_USE_EVENTS)).booleanValue()) {
            log.log(Level.FINE, "{0}Adding observable topic selector: use_messages", method);
            topicSelectors = topicSelectors.length() == 0 ? "use_messages" : topicSelectors + ",use_messages";
        }
        if ((ph = PermissionHandlerFactory.getDefault()).isSuperadmin((Object)this.server.getServerData()) || ph.hasPermissionForRoles((Object)this.server.getServerData(), new String[]{"section.airportmap_admin"})) {
            log.log(Level.FINE, "{0}Adding selector(s) for admin", method);
            log.log(Level.FINE, "{0}Adding observable topic selector: infoman_messages", method);
            log.log(Level.FINE, "{0}Adding observable topic selector: server_errors", method);
            if (topicSelectors.length() == 0) {
                log.log(Level.INFO, "{0}You will only receive infoman messages and server errors!!! No other observable topic selectors are configured!", method);
                topicSelectors = "infoman_messages";
            } else {
                topicSelectors = topicSelectors + ",infoman_messages";
            }
            topicSelectors = topicSelectors.length() == 0 ? "server_errors" : topicSelectors + ",server_errors";
        } else if (topicSelectors.equals("")) {
            log.log(Level.SEVERE, "{0}No observable topic selectors configured! You won''t receive any information!", method);
        }
        log.log(Level.INFO, "{0}Built topic selector: {1}", new Object[]{method, topicSelectors});
        return topicSelectors;
    }

    private String getXMLSchemas() {
        StringBuilder schemaNamespaces = new StringBuilder();
        Map<String, Map<String, String>> schemas = this.getXMLSchemasMap();
        Iterator<String> ite = schemas.keySet().iterator();
        while (ite.hasNext()) {
            String schemaNamespace = ite.next();
            schemaNamespaces.append(schemaNamespace);
            Map<String, String> params = schemas.get(schemaNamespace);
            if (params != null && !params.isEmpty()) {
                schemaNamespaces.append("(");
                StringBuilder parameters = new StringBuilder();
                for (String paramName : params.keySet()) {
                    parameters.append(paramName);
                    parameters.append("=");
                    parameters.append(params.get(paramName));
                    parameters.append(" ");
                }
                schemaNamespaces.append(parameters.toString().trim());
                schemaNamespaces.append(")");
            }
            if (!ite.hasNext()) continue;
            schemaNamespaces.append(",");
        }
        return schemaNamespaces.toString();
    }

    public Map<String, Map<String, String>> getXMLSchemasMap() {
        HashMap<String, Map<String, String>> ret = new HashMap<String, Map<String, String>>();
        ret.put("http://proveo.de/xml/fleet-management/statemodel-1.0", null);
        ret.put("http://proveo.de/xml/fleet-management/statemodel-layer-mapping-1.0", null);
        ret.put("http://proveo.de/xml/fleet-management/measurement-1.0", null);
        return ret;
    }

    private void initClientDateUtil() {
        Locale locale = Locale.getDefault();
        TimeZone timezone = TimeZone.getTimeZone(this.server.getTimeZoneID());
        Preferences prefs = NbPreferences.forModule(AppearancePreferencesProvider.class);
        String timezoneID = prefs.get("AppearancePreferencesProvider.timezone", "");
        if (timezoneID.length() > 0) {
            timezone = TimeZone.getTimeZone(timezoneID);
            if (!timezoneID.equals(timezone.getID())) {
                log.log(Level.SEVERE, "Unknown time zone in properties: ''{0}'' ! time zone now set to ''{1}''", new Object[]{timezoneID, timezone.getID()});
            }
        } else {
            log.fine("No time zone in properties, use default from server");
        }
        this.clientDateUtil = new DateUtil(locale, timezone);
        this.clientDateUtil.setDatetimePattern(prefs.get("AppearancePreferencesProvider.dateTimePattern", "dd MMM yy HH:mm:ss"));
        this.clientDateUtil.setDurationPattern(prefs.get("AppearancePreferencesProvider.durationPattern", "D 0H:0m:0s"));
    }

    private void initReplayConnection(Map<String, String> servletParameters, ConnectionStatistics connectionStatistics) throws Exception {
        String method = "initReplayConnection(): ";
        if (this.replayConnectionReader != null) {
            this.replayConnectionReader.disconnect();
        }
        if (this.replayServletConnection != null) {
            this.replayServletConnection.close();
        }
        URL serverURL = this.server.getConnectionURL();
        String protocol = serverURL.getProtocol();
        int port = serverURL.getPort();
        if ("https".equals(protocol) && (port == 80 || port == 8080)) {
            log.log(Level.WARNING, "{0}https (SSL) and port {1} are uncommon ! Mistake in properties ?", new Object[]{method, port});
        }
        String servletPath = "datain/replay";
        URL url = new URL(serverURL.getProtocol(), serverURL.getHost(), serverURL.getPort(), "/" + servletPath);
        this.replayServletConnection = new ServletConnection(url);
        this.replayServletConnection.connect();
        log.log(Level.INFO, "{0}setup ObjectInputStream with parameters for client side filter", method);
        this.objectInputStream = this.replayServletConnection.getObjectInputStream(servletParameters);
        if (this.objectInputStream == null) {
            log.log(Level.SEVERE, "{0}ObjectInputStream is null", method);
            throw new ReplayDataNotLoadedException();
        }
        this.createReplayConnectionReader(this.objectInputStream, connectionStatistics);
    }

    @Override
    public void preferenceChange(PreferenceChangeEvent evt) {
        if ("AppearancePreferencesProvider.timezone".equals(evt.getKey()) || "AppearancePreferencesProvider.dateTimePattern".equals(evt.getKey()) || "AppearancePreferencesProvider.durationPattern".equals(evt.getKey())) {
            this.initClientDateUtil();
        }
    }

    private String prepareServletCall(String path, Map<String, String> parameters) throws Exception {
        if (this.server.getIDMCredentials() == null) {
            throw new IllegalStateException("Cannot execute call, no user is currently logged in.");
        }
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        URL serverURL = this.server.getConnectionURL();
        URL url = new URL(serverURL.getProtocol(), serverURL.getHost(), serverURL.getPort(), path);
        if (this.servletConnection == null) {
            this.servletConnection = new ServletConnection(url);
            this.servletConnection.connect();
        }
        return this.servletConnection.addParametersToUrl(url, parameters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reconnectReplayPolling(ConnectionStatistics connectionStatistics) {
        String method = "reconnectReplayPolling(): ";
        if (this.reconnecting) {
            log.log(Level.INFO, "{0}reconnect is already running, break.", method);
            return;
        }
        this.reconnecting = true;
        this._stopPolling();
        long now = System.currentTimeMillis();
        if (now - this.lastSuccessfulConnect > 10000L) {
            log.log(Level.INFO, "{0}Normal reconnect: Last successful reconnect was {1}s ago.", new Object[]{method, (now - this.lastSuccessfulConnect) / 1000L});
            if (this.reconnectTries > 1) {
                this.reconnectWaitTime = 1000L;
            }
            this.reconnectTries = 0;
        } else {
            if (this.lastSuccessfulConnect == 0L) {
                log.log(Level.WARNING, "{0}Critical reconnect: Never ever had a successful connection!!! {1} reconnect(s) till a long time period for the next reconnect!", new Object[]{method, 5 - this.reconnectTries});
            } else if (5 - this.reconnectTries > 0) {
                log.log(Level.WARNING, "{0}Critical reconnect: Last successful connect was {1}s ago! {2} reconnect(s) till a long time period for the next reconnect!", new Object[]{method, (now - this.lastSuccessfulConnect) / 1000L, 5 - this.reconnectTries});
            }
            this.reconnectWaitTime = (long)(this.reconnectTries + 1) * 1000L;
        }
        ++this.reconnectTries;
        if (5 - this.reconnectTries <= 0) {
            log.log(Level.WARNING, "{0}Could not get a connection after {1} reconnects. Set reconnect wait time to {2}!", new Object[]{method, 5 + this.reconnectLongTimePeriodeTries, 120L});
            ++this.reconnectLongTimePeriodeTries;
            this.reconnectWaitTime = 120000L;
        } else {
            this.reconnectLongTimePeriodeTries = 0;
        }
        log.log(Level.INFO, "{0}trying to reconnect in {1}s ...", new Object[]{method, this.reconnectWaitTime / 1000L});
        try {
            try {
                Thread.sleep(this.reconnectWaitTime);
                if (this.reconnectWaitTime < 60000L) {
                    this.reconnectWaitTime += 1000L;
                }
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
            String beginTime = this.servletParameters.get("beginTime");
            String endTime = this.servletParameters.get("endTime");
            Credentials credentials = this.server.getIDMCredentials();
            this.servletParameters = this.getServletParameters(this.configuration, this.clientDateUtil, this.getTopicSelectors(this.configuration), credentials.getUsername(), credentials.getPassword());
            this.servletParameters.put("beginTime", beginTime);
            this.servletParameters.put("endTime", endTime);
            this.servletParameters.put("reconnectTries", Long.toString(this.reconnectTries));
            long timestamp = System.currentTimeMillis();
            this.servletParameters.put("reconnectTime", Long.toString(timestamp));
            this.servletParameters.put("reconnectTimeHumanReadable", this.clientDateUtil.getDateTime(timestamp));
            this.initReplayConnection(this.servletParameters, connectionStatistics);
            log.log(Level.INFO, "{0}reconnect successful.", method);
            this.reconnectWaitTime = 1000L;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, method + "reconnect NOT successful! Runs into:", e);
        }
        finally {
            this.reconnecting = false;
            if (this.replayConnectionReader == null || !this.replayConnectionReader.isAlive()) {
                this.createReplayConnectionReader(this.objectInputStream, connectionStatistics);
            }
        }
        log.log(Level.INFO, "{0}ServletConnection created.", method);
    }

    public void setAreas(Map<String, Map<String, Object>> areas, Long airportId) throws IOException, LoginException {
        String username = null;
        char[] password = null;
        Credentials credentials = this.server.getIDMCredentials();
        if (credentials != null) {
            username = credentials.getUsername();
            password = credentials.getPassword();
        }
        if (username == null || password == null) {
            return;
        }
        char[] passwordHash = ShaSumGenerator.plainStringToSHA1((String)new String(password)).toCharArray();
        HashMap<String, Object> callValues = new HashMap<String, Object>();
        callValues.put(PARAM_USERNAME, username);
        callValues.put(PARAM_PASSWORD, passwordHash);
        callValues.put(PARAM_AREAS, areas);
        if (airportId == null || airportId >= 0L) {
            callValues.put(PARAM_AIRPORT_ID, airportId);
        }
        try {
            this.server.executeCall("SetAreas", callValues);
        }
        catch (LoginException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            throw new IOException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setReplayData(Map replayData) {
        this.replayData = replayData;
        Object object = this.replayDataLock;
        synchronized (object) {
            this.replayDataLock.notifyAll();
        }
    }
}

