/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.idm.remote.server.efm4.impl;

import de.proveo.domain.values.datasync.DatasyncMetainfoValue;
import de.proveo.domain.values.datasync.DatasyncResourceValue;
import de.proveo.domain.values.infoman.MetaInfoKey;
import de.proveo.wwt.logic.ejb.general.infoman.software.InfomanSoftwareDescriptionValue;
import java.util.ArrayList;
import java.util.List;

public class InfomanSoftwareDescriptionValueAdapter
extends DatasyncResourceValue {
    private final InfomanSoftwareDescriptionValue resource;
    private List<DatasyncMetainfoValue> metaInfo;
    private long validFrom = 0L;
    private long validTill = 0L;

    public InfomanSoftwareDescriptionValueAdapter(InfomanSoftwareDescriptionValue resource) {
        this.resource = resource;
        this.metaInfo = InfomanSoftwareDescriptionValueAdapter.createMetaInfo(resource);
    }

    public InfomanSoftwareDescriptionValue getResourceInstance() {
        return this.resource;
    }

    public String getChecksum() {
        return this.resource.getChecksum();
    }

    public List<DatasyncMetainfoValue> getMetainfos() {
        return this.metaInfo;
    }

    public byte[] getResource() {
        throw new UnsupportedOperationException("Not supported");
    }

    public long getResourceId() {
        return this.resource.getId();
    }

    public String getResourceName() {
        return this.resource.getVersionName();
    }

    public boolean isHasMetaInfo() {
        return this.metaInfo != null && !this.metaInfo.isEmpty();
    }

    public void setChecksum(String checksum) {
        this.resource.setChecksum(checksum);
    }

    public void setMetainfos(List<DatasyncMetainfoValue> metainfos) {
        this.metaInfo = metainfos;
    }

    public void setResource(byte[] resource) {
        throw new UnsupportedOperationException("Not supported");
    }

    public void setResourceId(long resourceId) {
        this.resource.setId(resourceId);
    }

    public void setResourceName(String resourceName) {
        this.resource.setFilename(resourceName);
    }

    public long getValidFrom() {
        return this.validFrom;
    }

    public void setValidFrom(long validFrom) {
        this.validFrom = validFrom;
    }

    public long getValidTill() {
        return this.validTill;
    }

    public void setValidTill(long validTill) {
        this.validTill = validTill;
    }

    public String toString() {
        return this.resource.toString();
    }

    private static ArrayList<DatasyncMetainfoValue> createMetaInfo(InfomanSoftwareDescriptionValue resource) {
        ArrayList<DatasyncMetainfoValue> infos = new ArrayList<DatasyncMetainfoValue>();
        DatasyncMetainfoValue info = new DatasyncMetainfoValue();
        info.setKey(MetaInfoKey.CHECKSUM_TYPE.toString());
        info.setValue(resource.getChecksumType());
        infos.add(info);
        info = new DatasyncMetainfoValue();
        info.setKey(MetaInfoKey.CHECKSUM.toString());
        info.setValue(resource.getChecksum());
        infos.add(info);
        info = new DatasyncMetainfoValue();
        info.setKey(MetaInfoKey.CONTENT_TYPE.toString());
        info.setValue(resource.getContentType());
        infos.add(info);
        info = new DatasyncMetainfoValue();
        info.setKey(MetaInfoKey.FILE_NAME.toString());
        info.setValue(resource.getFilename());
        infos.add(info);
        info = new DatasyncMetainfoValue();
        info.setKey(MetaInfoKey.DESCRIPTION.toString());
        info.setValue(resource.getDescription());
        infos.add(info);
        info = new DatasyncMetainfoValue();
        info.setKey(MetaInfoKey.SOFTWARE_VERSION.toString());
        info.setValue(resource.getVersionName());
        infos.add(info);
        info = new DatasyncMetainfoValue();
        info.setKey(MetaInfoKey.TYPE.toString());
        info.setValue("INFOMAN_SOFTWARE");
        infos.add(info);
        return infos;
    }
}

