/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.idm.remote.server.efm4.impl;

import de.proveo.idm.remote.server.communication.api.ClientWatchdog;
import de.proveo.idm.remote.server.communication.api.ConnectionStatistics;
import de.proveo.idm.remote.server.efm4.impl.RemoteMapAdapterImpl;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ClientReplayWatchdog
extends Thread
implements ClientWatchdog {
    private static final Logger log = Logger.getLogger(ClientReplayWatchdog.class.getName());
    private static final long EXPECTED_PING_RECEIVE_TIME = 30000L;
    private static final long DEFAULT_CHECK_INTERVAL = 60000L;
    private static final long DEFAULT_CONNECTION_TIMEOUT = 90000L;
    private final Object lock = new Object();
    private long checkInterval = 60000L;
    private long connectionTimeout = 90000L;
    private volatile boolean shouldStop = false;
    private volatile boolean idling = false;
    private long lastEventReceived = -1L;
    private RemoteMapAdapterImpl remoteMapAdapter;
    private ConnectionStatistics connectionStatistics;

    public ClientReplayWatchdog(RemoteMapAdapterImpl remoteMapAdapter, ConnectionStatistics connectionStatistics) {
        super("ClientReplayWatchdog");
        this.remoteMapAdapter = remoteMapAdapter;
        this.connectionStatistics = connectionStatistics;
        this.lastEventReceived = System.currentTimeMillis();
    }

    public void onPingReceived(long timestamp) {
        this.lastEventReceived = timestamp;
        if (this.connectionStatistics != null) {
            this.connectionStatistics.addPingEvent();
        }
    }

    public void onEventReceived(long timestamp) {
        this.lastEventReceived = timestamp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onConnectionError(Throwable ex) {
        log.log(Level.WARNING, "Will reconnect, because connection runs into", ex);
        Object object = this.lock;
        synchronized (object) {
            this.idling = true;
        }
        log.info("Reconnect polling ...");
        this.remoteMapAdapter.reconnectReplayPolling(this.connectionStatistics);
        log.info("Polling reconnected.");
        object = this.lock;
        synchronized (object) {
            this.idling = false;
            this.lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMissingEvent() {
        log.warning("Will reconnect, because of an missing event!");
        Object object = this.lock;
        synchronized (object) {
            this.idling = true;
        }
        log.info("Reconnect polling ...");
        this.remoteMapAdapter.reconnectReplayPolling(this.connectionStatistics);
        log.info("Polling reconnected.");
        object = this.lock;
        synchronized (object) {
            this.idling = false;
            this.lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel(boolean force) {
        this.shouldStop = true;
        if (!this.idling) {
            Object object = this.lock;
            synchronized (object) {
                this.lock.notifyAll();
            }
        }
        if (force) {
            this.interrupt();
        }
    }

    public void setCheckInterval(long checkInterval) {
        this.checkInterval = checkInterval;
    }

    public void setConnectionTimeout(long connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        String method = this.getName() + ".run(): ";
        log.log(Level.INFO, "{0} started.", method);
        this.shouldStop = false;
        while (!this.shouldStop) {
            try {
                boolean i;
                Thread.sleep(this.checkInterval);
                Object object = this.lock;
                synchronized (object) {
                    i = this.idling;
                }
                if (!i) {
                    this.checkConnection();
                    continue;
                }
                object = this.lock;
                synchronized (object) {
                    this.lock.wait();
                }
            }
            catch (InterruptedException ie) {
                log.log(Level.INFO, method + "Watchdog runs while sleeping or waiting into", ie);
            }
        }
        log.log(Level.INFO, "{0}was stopped.", method);
    }

    private void checkConnection() {
        String method = "checkConnection(): ";
        long now = System.currentTimeMillis();
        if (this.lastEventReceived != -1L && now - this.lastEventReceived > this.connectionTimeout) {
            log.log(Level.WARNING, "{0}Connection inactive! Last Ping was {1}s ago! Perform reconnect ...", new Object[]{method, (now - this.lastEventReceived) / 1000L});
            this.remoteMapAdapter.reconnectReplayPolling(this.connectionStatistics);
            log.info("Reconnect performed.");
        }
    }
}

