/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.browser.webview.ext;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Semaphore;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.embed.swing.JFXPanel;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.ScrollPane;
import javafx.scene.input.ContextMenuEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.paint.Paint;
import javafx.scene.web.PopupFeatures;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebEvent;
import javafx.scene.web.WebHistory;
import javafx.scene.web.WebView;
import javafx.util.Callback;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import netscape.javascript.JSException;
import org.netbeans.core.HtmlBrowserComponent;
import org.netbeans.core.browser.api.WebBrowser;
import org.netbeans.core.browser.api.WebBrowserEvent;
import org.netbeans.core.browser.api.WebBrowserListener;
import org.netbeans.core.browser.webview.BrowserCallback;
import org.netbeans.core.browser.webview.HtmlBrowserImpl;
import org.netbeans.core.browser.webview.MessageDispatcherImpl;
import org.netbeans.core.browser.webview.ext.ScriptExecutorImpl;
import org.netbeans.core.browser.webview.ext.WebBrowserEventImpl;
import org.netbeans.core.browser.webview.ext.WebKitDebuggingTransport;
import org.netbeans.core.browser.webview.ext.ZoomAndResizeImpl;
import org.netbeans.modules.web.browser.api.BrowserSupport;
import org.netbeans.modules.web.browser.api.PageInspector;
import org.netbeans.modules.web.browser.api.WebBrowserFeatures;
import org.netbeans.modules.web.browser.spi.EnhancedBrowser;
import org.netbeans.modules.web.webkit.debugging.spi.Factory;
import org.netbeans.modules.web.webkit.debugging.spi.TransportImplementation;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.HtmlBrowser;
import org.openide.filesystems.FileObject;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;
import org.openide.windows.TopComponent;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSSerializer;

public class WebBrowserImpl
extends WebBrowser
implements BrowserCallback,
EnhancedBrowser {
    private JFXPanel container;
    private String urlToLoad;
    private final PropertyChangeSupport propSupport = new PropertyChangeSupport(this);
    private final List<WebBrowserListener> browserListners = new ArrayList<WebBrowserListener>();
    private final Object LOCK = new Object();
    private WebView browser;
    private String status;
    private boolean initialized;
    private Color defaultPanelColor = Color.LIGHT_GRAY;
    private Lookup lookup;
    private final InstanceContent lookupContent = new InstanceContent();
    private final Object LOOKUP_LOCK = new Object();
    private String currentLocation = null;
    private String currentTitle = null;
    private boolean isBackward = false;
    private boolean isForward = false;
    private final JToolBar toolbar = new JToolBar();
    private final JPopupMenu contextMenu = new JPopupMenu();
    private final Semaphore INIT_LOCK = new Semaphore(-1);
    private Lookup projectContext;
    private Method setZoomMethod;
    private Method getZoomMethod;
    static final String PAGE_INSPECTION_PREFIX = "NetBeans-Page-Inspection";
    private double preferredWidth = -1.0;
    private double preferredHeight = -1.0;

    public WebBrowserImpl() {
        this(null);
    }

    private WebBrowserImpl(WebView webView) {
        this.browser = webView;
        this.INIT_LOCK.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    WebEngine getEngine() {
        WebEngine res = null;
        try {
            this.INIT_LOCK.acquire();
            assert (this.browser != null);
            res = this.browser.getEngine();
        }
        catch (InterruptedException iE) {
            Exceptions.printStackTrace((Throwable)iE);
        }
        finally {
            this.INIT_LOCK.release();
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Component getComponent() {
        Object object = this.LOCK;
        synchronized (object) {
            if (null == this.container) {
                this.container = new JFXPanel();
                this.defaultPanelColor = new JPanel().getBackground();
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        WebBrowserImpl.this.createBrowser();
                    }
                });
                this.initContextMenu();
                this.initialized = true;
            }
        }
        return this.container;
    }

    private void issue217410Hack(final WebView view) {
        view.setOnMouseExited((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                String script = "var event = document.createEvent('MouseEvents');\nevent.initMouseEvent(\n    'mouseout', true, true, window,\n    0, 0, 0, 0, 0,\n    false, false, false, false,\n    0, null);\nwindow.dispatchEvent(event);";
                try {
                    view.getEngine().executeScript(script);
                }
                catch (JSException ex) {
                    Logger logger = Logger.getLogger(WebBrowserImpl.class.getName());
                    logger.log(Level.INFO, "Error while executing JavaScript for hack #217410", ex);
                }
            }
        });
    }

    public Lookup getLookup() {
        if (this.lookup == null) {
            this.lookup = this.createLookup();
        }
        return this.lookup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshActiveNode() {
        Object object = this.LOOKUP_LOCK;
        synchronized (object) {
            URL url = null;
            try {
                url = new URL(this.currentLocation);
            }
            catch (Exception e) {
                // empty catch block
            }
            Lookup lkp = null == url ? Lookup.EMPTY : Lookups.singleton((Object)url);
            Lookup[] lookups = new Lookup[null == this.projectContext ? 1 : 2];
            lookups[0] = lkp;
            if (null != this.projectContext) {
                lookups[1] = this.projectContext;
            }
            AbstractNode node = new AbstractNode(Children.LEAF, (Lookup)new ProxyLookup(lookups));
            this.lookupContent.set(Collections.singleton(node), null);
        }
    }

    private Lookup createLookup() {
        WebKitDebuggingTransport transport = new WebKitDebuggingTransport(this);
        Lookup l = Lookups.fixed((Object[])new Object[]{new MessageDispatcherImpl(), new ScriptExecutorImpl(this), transport, Factory.createWebKitDebugging((TransportImplementation)transport), new ZoomAndResizeImpl(this), this.toolbar, this.contextMenu});
        return new ProxyLookup(new Lookup[]{l, new AbstractLookup((AbstractLookup.Content)this.lookupContent)});
    }

    public boolean ignoreChange(FileObject fo) {
        return BrowserSupport.ignoreChangeDefaultImpl((FileObject)fo);
    }

    public void reloadDocument() {
        if (!this.isInitialized()) {
            return;
        }
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                WebBrowserImpl.this.getEngine().reload();
            }
        });
    }

    public void stopLoading() {
        if (!this.isInitialized()) {
            return;
        }
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                WebBrowserImpl.this.getEngine().getLoadWorker().cancel();
            }
        });
    }

    public void setURL(String url) {
        if (!this.isInitialized()) {
            this.urlToLoad = url;
            return;
        }
        this._setURL(url);
    }

    private void _setURL(final String url) {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                String fullUrl = url;
                if (!(url.startsWith("http://") || url.startsWith("https://") || url.startsWith("file:/") || url.startsWith("jar:file:/"))) {
                    fullUrl = "http://" + url;
                }
                WebBrowserImpl.this.getEngine().load(fullUrl);
            }
        });
    }

    public String getURL() {
        String url = this.currentLocation;
        if (url == null) {
            url = this.urlToLoad;
        }
        return url;
    }

    public String getStatusMessage() {
        if (!this.isInitialized()) {
            return null;
        }
        return this.status;
    }

    public String getTitle() {
        return this.currentTitle;
    }

    public boolean isForward() {
        return this.isForward;
    }

    public void forward() {
        if (this.isInitialized()) {
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    WebBrowserImpl.this.getEngine().getHistory().go(1);
                }
            });
        }
    }

    public boolean isBackward() {
        return this.isBackward;
    }

    public void backward() {
        if (this.isInitialized()) {
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    WebBrowserImpl.this.getEngine().getHistory().go(-1);
                }
            });
        }
    }

    public boolean isHistory() {
        return false;
    }

    public void showHistory() {
        throw new UnsupportedOperationException();
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.propSupport.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.propSupport.removePropertyChangeListener(l);
    }

    public void setContent(final String content) {
        if (!this.isInitialized()) {
            return;
        }
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                WebBrowserImpl.this.getEngine().loadContent(content);
            }
        });
    }

    public Document getDocument() {
        Document document = null;
        if (this.isInitialized()) {
            document = this.runInFXThread(new Callable<Document>(){

                @Override
                public Document call() throws Exception {
                    return WebBrowserImpl.this.getEngine().getDocument();
                }
            });
        }
        return document;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Object object = this.LOCK;
        synchronized (object) {
            this.browserListners.clear();
            if (this.isInitialized()) {
                this.container.removeAll();
                this.initialized = false;
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        WebBrowserImpl.this.browser.getEngine().loadContent("<html><body>");
                        WebBrowserImpl.this.browser = null;
                    }
                });
            }
            this.container = null;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                WebBrowserImpl.this.propSupport.firePropertyChange("browser.was.closed", null, null);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWebBrowserListener(WebBrowserListener l) {
        List<WebBrowserListener> list = this.browserListners;
        synchronized (list) {
            this.browserListners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeWebBrowserListener(WebBrowserListener l) {
        List<WebBrowserListener> list = this.browserListners;
        synchronized (list) {
            this.browserListners.remove(l);
        }
    }

    public Map<String, String> getCookie(String domain, String name, String path) {
        throw new UnsupportedOperationException();
    }

    public void deleteCookie(String domain, String name, String path) {
        throw new UnsupportedOperationException();
    }

    public void addCookie(Map<String, String> cookie) {
        throw new UnsupportedOperationException();
    }

    public Object executeJavaScript(final String script) {
        Object result = null;
        if (this.isInitialized()) {
            result = this.runInFXThread(new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    return WebBrowserImpl.this.getEngine().executeScript(script);
                }
            });
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isInitialized() {
        Object object = this.LOCK;
        synchronized (object) {
            return this.initialized;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean fireBrowserEvent(int type, String url) {
        WebBrowserEventImpl event = new WebBrowserEventImpl(type, this, url);
        this.urlToLoad = url;
        List<WebBrowserListener> list = this.browserListners;
        synchronized (list) {
            for (WebBrowserListener l : this.browserListners) {
                l.onDispatchEvent((WebBrowserEvent)event);
            }
        }
        return event.isCancelled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fireBrowserEvent(int type, AWTEvent e, org.w3c.dom.Node n) {
        WebBrowserEventImpl event = new WebBrowserEventImpl(type, this, e, n);
        List<WebBrowserListener> list = this.browserListners;
        synchronized (list) {
            for (WebBrowserListener l : this.browserListners) {
                l.onDispatchEvent((WebBrowserEvent)event);
            }
        }
    }

    private void createBrowser() {
        Platform.setImplicitExit((boolean)false);
        if (null == this.browser) {
            WebView view = new WebView();
            this.initBrowser(view);
            this.issue217410Hack(view);
            this.browser = view;
            this.INIT_LOCK.release();
        }
        if (null != this.container) {
            BorderPane pane = new BorderPane();
            pane.setCenter((Node)this.browser);
            Scene scene = new Scene((Parent)pane);
            scene.setFill((Paint)this.getSceneFillColor());
            this.container.setScene(scene);
        }
        if (null != this.urlToLoad) {
            this._setURL(this.urlToLoad);
            this.urlToLoad = null;
        }
    }

    private void initBrowser(WebView view) {
        view.setMinSize(100.0, 100.0);
        view.setContextMenuEnabled(false);
        final WebEngine eng = view.getEngine();
        eng.setOnStatusChanged((EventHandler)new EventHandler<WebEvent<String>>(){

            public void handle(WebEvent<String> e) {
                final String oldStatus = WebBrowserImpl.this.status;
                WebBrowserImpl.this.status = (String)e.getData();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        WebBrowserImpl.this.propSupport.firePropertyChange("statusMessage", oldStatus, WebBrowserImpl.this.status);
                    }
                });
            }
        });
        eng.locationProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, final String oldValue, final String newValue) {
                WebBrowserImpl.this.currentLocation = eng.getLocation();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        WebBrowserImpl.this.refreshActiveNode();
                        WebBrowserImpl.this.propSupport.firePropertyChange("url", oldValue, newValue);
                    }
                });
            }
        });
        eng.titleProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, final String oldValue, final String newValue) {
                WebBrowserImpl.this.currentTitle = eng.getTitle();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        WebBrowserImpl.this.propSupport.firePropertyChange("title", oldValue, newValue);
                    }
                });
            }
        });
        eng.setOnAlert((EventHandler)new EventHandler<WebEvent<String>>(){

            public void handle(WebEvent<String> event) {
                WebBrowserImpl.this.processAlert((String)event.getData());
            }
        });
        eng.getHistory().getEntries().addListener((ListChangeListener)new ListChangeListener<WebHistory.Entry>(){

            public void onChanged(ListChangeListener.Change<? extends WebHistory.Entry> change) {
                WebBrowserImpl.this._updateBackAndForward();
            }
        });
        eng.getHistory().currentIndexProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> ov, Number t, Number t1) {
                WebBrowserImpl.this._updateBackAndForward();
            }
        });
        eng.getLoadWorker().runningProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> ov, Boolean t, Boolean t1) {
                final boolean isLoading = eng.getLoadWorker().isRunning();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        WebBrowserImpl.this.propSupport.firePropertyChange("loading", !isLoading, isLoading);
                    }
                });
            }
        });
        eng.getLoadWorker().exceptionProperty().addListener((ChangeListener)new ChangeListener<Throwable>(){

            public void changed(ObservableValue<? extends Throwable> ov, Throwable t, Throwable t1) {
                if (null == t1) {
                    return;
                }
                String location = eng.getLocation();
                WebBrowserImpl.this.reportInvalidUrl(location, t1);
            }
        });
        eng.setCreatePopupHandler((Callback)new Callback<PopupFeatures, WebEngine>(){

            public WebEngine call(PopupFeatures p) {
                if (p.hasMenu() && p.hasStatus() && p.hasToolbar() && p.isResizable()) {
                    return WebBrowserImpl.this._createNewBrowserWindow();
                }
                return eng;
            }
        });
        view.setOnContextMenuRequested((EventHandler)new EventHandler<ContextMenuEvent>(){

            public void handle(ContextMenuEvent t) {
                int x = (int)t.getX();
                int y = (int)t.getY();
                final int screenX = (int)t.getScreenX();
                final int screenY = (int)t.getScreenY();
                String script = "document.elementFromPoint(" + x + ", " + y + ")";
                Object res = eng.executeScript(script);
                final Element elemUnderCursor = res instanceof Element ? (Element)res : null;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        WebBrowserImpl.this.showContextMenu(screenX, screenY, elemUnderCursor);
                    }
                });
            }
        });
    }

    private void processAlert(String message) {
        if (message.startsWith(PAGE_INSPECTION_PREFIX)) {
            message = message.substring(PAGE_INSPECTION_PREFIX.length());
            MessageDispatcherImpl dispatcher = (MessageDispatcherImpl)((Object)this.getLookup().lookup(MessageDispatcherImpl.class));
            if (dispatcher != null) {
                dispatcher.dispatchMessage("inspect", message);
            }
        } else {
            DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)new NotifyDescriptor.Message((Object)message));
        }
    }

    private <T> T runInFXThread(final Callable<T> task) {
        Object result;
        block5: {
            result = null;
            try {
                if (Platform.isFxApplicationThread()) {
                    result = task.call();
                    break block5;
                }
                final Object[] resultWrapper = new Object[1];
                final CountDownLatch latch = new CountDownLatch(1);
                Platform.runLater((Runnable)new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            resultWrapper[0] = task.call();
                        }
                        catch (Exception ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                        finally {
                            latch.countDown();
                        }
                    }
                });
                try {
                    latch.await();
                }
                catch (InterruptedException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                result = resultWrapper[0];
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return (T)result;
    }

    private void initComponentPopupMenu(JComponent browserComponent) {
        if (PageInspector.getDefault() != null) {
            String inspectPage = NbBundle.getMessage(WebBrowserImpl.class, (String)"WebBrowserImpl.inspectPage");
            JPopupMenu menu = new JPopupMenu();
            menu.add(new AbstractAction(inspectPage){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PageInspector inspector = PageInspector.getDefault();
                    if (inspector == null) {
                        Logger logger = Logger.getLogger(WebBrowserImpl.class.getName());
                        logger.log(Level.INFO, "No PageInspector found: ignoring the request for page inspection!");
                    } else {
                        inspector.inspectPage((Lookup)new ProxyLookup(new Lookup[]{WebBrowserImpl.this.getLookup(), WebBrowserImpl.this.projectContext}));
                    }
                }
            });
            browserComponent.setComponentPopupMenu(menu);
        }
    }

    private void showContextMenu(int screenX, int screenY, Element elementUnderCursor) {
        if (null == this.browser) {
            return;
        }
        Point p = new Point(screenX, screenY);
        SwingUtilities.convertPointFromScreen(p, (Component)this.container);
        this.contextMenu.show((Component)this.container, p.x, p.y);
    }

    private void initContextMenu() {
        this.contextMenu.add(new AbstractAction(NbBundle.getMessage(WebBrowserImpl.class, (String)"Menu_BACK")){

            @Override
            public void actionPerformed(ActionEvent e) {
                WebBrowserImpl.this.backward();
            }

            @Override
            public boolean isEnabled() {
                return WebBrowserImpl.this.isBackward();
            }
        });
        this.contextMenu.add(new AbstractAction(NbBundle.getMessage(WebBrowserImpl.class, (String)"Menu_FORWARD")){

            @Override
            public void actionPerformed(ActionEvent e) {
                WebBrowserImpl.this.forward();
            }

            @Override
            public boolean isEnabled() {
                return WebBrowserImpl.this.isForward();
            }
        });
        this.contextMenu.add(new AbstractAction(NbBundle.getMessage(WebBrowserImpl.class, (String)"Menu_RELOAD")){

            @Override
            public void actionPerformed(ActionEvent e) {
                WebBrowserImpl.this.reloadDocument();
            }
        });
        this.contextMenu.addSeparator();
        this.contextMenu.add(new AbstractAction(NbBundle.getMessage(WebBrowserImpl.class, (String)"Menu_DUMP_DOM")){

            @Override
            public void actionPerformed(ActionEvent e) {
                WebBrowserImpl.this.dumpDocument();
            }
        });
    }

    private void _updateBackAndForward() {
        final boolean oldForward = this.isForward;
        final boolean oldBackward = this.isBackward;
        this.isForward = this._isForward();
        this.isBackward = this._isBackward();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                WebBrowserImpl.this.propSupport.firePropertyChange("backward", oldBackward, WebBrowserImpl.this.isBackward);
                WebBrowserImpl.this.propSupport.firePropertyChange("forward", oldForward, WebBrowserImpl.this.isForward);
            }
        });
    }

    private boolean _isForward() {
        if (null == this.browser) {
            return false;
        }
        WebHistory history = this.getEngine().getHistory();
        return history.getCurrentIndex() < history.getEntries().size() - 1;
    }

    private boolean _isBackward() {
        if (null == this.browser) {
            return false;
        }
        WebHistory history = this.getEngine().getHistory();
        return history.getCurrentIndex() > 0;
    }

    private WebEngine _createNewBrowserWindow() {
        final WebView newView = new WebView();
        WebEngine newEngine = newView.getEngine();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                final WebBrowserImpl browserImpl = new WebBrowserImpl(newView);
                browserImpl.INIT_LOCK.release();
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        browserImpl.initBrowser(newView);
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                WebBrowserImpl.this.openNewBrowserWindow(browserImpl);
                            }
                        });
                    }
                });
            }
        });
        return newEngine;
    }

    private void openNewBrowserWindow(final WebBrowserImpl browserImpl) {
        HtmlBrowser.Factory factory = new HtmlBrowser.Factory(){

            public HtmlBrowser.Impl createHtmlBrowserImpl() {
                return new HtmlBrowserImpl(browserImpl);
            }
        };
        HtmlBrowserComponent browserComponent = new HtmlBrowserComponent(factory, true, true);
        browserComponent.open();
        browserComponent.requestActive();
        browserComponent.makeBusy(true);
    }

    void zoom(final double zoomFactor) {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                WebBrowserImpl.this.setZoom(WebBrowserImpl.this.browser, zoomFactor);
                if (WebBrowserImpl.this.preferredWidth > 0.0 && WebBrowserImpl.this.preferredHeight > 0.0) {
                    double scaledWidth = WebBrowserImpl.this.preferredWidth * zoomFactor;
                    double scaledHeight = WebBrowserImpl.this.preferredHeight * zoomFactor;
                    WebBrowserImpl.this._resize(scaledWidth, scaledHeight);
                }
            }
        });
    }

    void resize(final double width, final double height) {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                WebBrowserImpl.this.preferredWidth = width;
                WebBrowserImpl.this.preferredHeight = height;
                double scale = WebBrowserImpl.this.getZoom(WebBrowserImpl.this.browser);
                double scaledWidth = width * scale;
                double scaledHeight = height * scale;
                WebBrowserImpl.this._resize(scaledWidth, scaledHeight);
            }
        });
    }

    void _resize(double width, double height) {
        if (!(this.container.getScene().getRoot() instanceof ScrollPane)) {
            ScrollPane scroll = new ScrollPane();
            scroll.setContent((Node)this.browser);
            this.container.getScene().setRoot((Parent)scroll);
        }
        this.browser.setMaxWidth(width);
        this.browser.setMaxHeight(height);
        this.browser.setMinWidth(width);
        this.browser.setMinHeight(height);
    }

    void autofit() {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                if (WebBrowserImpl.this.container.getScene().getRoot() instanceof ScrollPane) {
                    BorderPane pane = new BorderPane();
                    pane.setCenter((Node)WebBrowserImpl.this.browser);
                    WebBrowserImpl.this.container.getScene().setRoot((Parent)pane);
                }
                WebBrowserImpl.this.preferredWidth = -1.0;
                WebBrowserImpl.this.preferredHeight = -1.0;
                WebBrowserImpl.this.browser.setMaxWidth(2.147483647E9);
                WebBrowserImpl.this.browser.setMaxHeight(2.147483647E9);
                WebBrowserImpl.this.browser.setMinWidth(-1.0);
                WebBrowserImpl.this.browser.setMinHeight(-1.0);
                WebBrowserImpl.this.browser.autosize();
            }
        });
    }

    private javafx.scene.paint.Color getSceneFillColor() {
        javafx.scene.paint.Color res = javafx.scene.paint.Color.LIGHTGRAY;
        Color c = this.defaultPanelColor;
        if (null != c) {
            res = javafx.scene.paint.Color.rgb((int)c.getRed(), (int)c.getGreen(), (int)c.getBlue());
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProjectContext(Lookup projectContext) {
        Object object = this.LOOKUP_LOCK;
        synchronized (object) {
            this.projectContext = projectContext;
            this.refreshActiveNode();
        }
    }

    public void initialize(WebBrowserFeatures browserFeatures) {
    }

    public void close(boolean closeTab) {
        if (closeTab) {
            Mutex.EVENT.readAccess(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Object object = WebBrowserImpl.this.LOCK;
                    synchronized (object) {
                        TopComponent tc;
                        if (null != WebBrowserImpl.this.container && null != (tc = (TopComponent)SwingUtilities.getAncestorOfClass(TopComponent.class, (Component)WebBrowserImpl.this.container))) {
                            tc.close();
                        }
                    }
                }
            });
        }
    }

    private void reportInvalidUrl(String location, Throwable ex) {
        if (null != ex) {
            Logger.getLogger(WebBrowserImpl.class.getName()).log(Level.INFO, null, ex);
        }
        NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)NbBundle.getMessage(WebBrowserImpl.class, (String)"Err_InvalidURL", (Object)location), -1);
        DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)nd);
    }

    public boolean canReloadPage() {
        return true;
    }

    private void dumpDocument() {
        if (!this.isInitialized()) {
            return;
        }
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                Document doc = WebBrowserImpl.this.getEngine().getDocument();
                WebBrowserImpl.this._dumpDocument(doc, WebBrowserImpl.this.getEngine().getTitle());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _dumpDocument(Document doc, String title) {
        if (null == title || title.isEmpty()) {
            title = NbBundle.getMessage(WebBrowserImpl.class, (String)"Lbl_GenericDomDumpTitle");
        }
        InputOutput io = IOProvider.getDefault().getIO(title, true);
        io.select();
        try {
            DOMImplementationRegistry registry = DOMImplementationRegistry.newInstance();
            DOMImplementationLS impl = (DOMImplementationLS)((Object)registry.getDOMImplementation("XML 3.0 LS 3.0"));
            if (null == impl) {
                io.getErr().println(NbBundle.getMessage(WebBrowserImpl.class, (String)"Err_DOMImplNotFound"));
                return;
            }
            LSSerializer serializer = impl.createLSSerializer();
            if (serializer.getDomConfig().canSetParameter("format-pretty-print", Boolean.TRUE)) {
                serializer.getDomConfig().setParameter("format-pretty-print", Boolean.TRUE);
            }
            LSOutput output = impl.createLSOutput();
            output.setEncoding("UTF-8");
            output.setCharacterStream((Writer)io.getOut());
            serializer.write(doc, output);
            io.getOut().println();
        }
        catch (Exception ex) {
            ex.printStackTrace((PrintWriter)io.getErr());
        }
        finally {
            if (null != io) {
                io.getOut().close();
                io.getErr().close();
            }
        }
    }

    private void setZoom(WebView webview, double zoomFactor) {
        this.initZoom();
        if (null != this.setZoomMethod) {
            try {
                this.setZoomMethod.invoke((Object)webview, zoomFactor);
            }
            catch (Exception e) {
                Logger.getLogger(WebBrowserImpl.class.getName()).log(Level.INFO, "Cannot set browser zoom factor.", e);
            }
        }
    }

    private double getZoom(WebView webview) {
        this.initZoom();
        if (null != this.getZoomMethod) {
            try {
                return (Double)this.getZoomMethod.invoke((Object)webview, new Object[0]);
            }
            catch (Exception e) {
                Logger.getLogger(WebBrowserImpl.class.getName()).log(Level.INFO, "Cannot read browser zoom factor.", e);
            }
        }
        return 1.0;
    }

    private void initZoom() {
        if (null != this.getZoomMethod) {
            return;
        }
        try {
            this.getZoomMethod = WebView.class.getDeclaredMethod("getZoom", new Class[0]);
            this.setZoomMethod = WebView.class.getDeclaredMethod("setZoom", Double.TYPE);
        }
        catch (Exception e) {
            try {
                this.getZoomMethod = WebView.class.getDeclaredMethod("impl_getScale", new Class[0]);
                this.setZoomMethod = WebView.class.getDeclaredMethod("impl_setScale", Double.TYPE);
            }
            catch (Exception e2) {
                Logger.getLogger(WebBrowserImpl.class.getName()).log(Level.WARNING, "Cannot initialize browser zoom.", e2);
            }
        }
    }
}

