/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.browser.webview;

import java.awt.Component;
import java.beans.PropertyChangeListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.netbeans.api.debugger.Session;
import org.netbeans.core.browser.api.WebBrowser;
import org.netbeans.core.browser.webview.MessageDispatcherImpl;
import org.netbeans.core.browser.webview.NoWebBrowserImpl;
import org.netbeans.core.browser.webview.TransportImplementationWithURLToLoad;
import org.netbeans.core.browser.webview.WebBrowserImplProvider;
import org.netbeans.modules.web.browser.api.BrowserSupport;
import org.netbeans.modules.web.browser.api.PageInspector;
import org.netbeans.modules.web.browser.api.WebBrowserFeatures;
import org.netbeans.modules.web.browser.spi.EnhancedBrowser;
import org.netbeans.modules.web.webkit.debugging.api.WebKitDebugging;
import org.netbeans.modules.web.webkit.debugging.api.WebKitUIManager;
import org.netbeans.modules.web.webkit.debugging.spi.TransportImplementation;
import org.openide.awt.HtmlBrowser;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.util.lookup.ProxyLookup;

public class HtmlBrowserImpl
extends HtmlBrowser.Impl
implements EnhancedBrowser {
    private static RequestProcessor RP = new RequestProcessor(HtmlBrowserImpl.class);
    private WebBrowser browser;
    private final Object LOCK = new Object();
    private Session session;
    private Lookup consoleLogger;
    private Lookup networkMonitor;
    private Lookup projectContext;
    private WebBrowserFeatures browserFeatures;
    private boolean initialized = false;

    public HtmlBrowserImpl() {
    }

    public HtmlBrowserImpl(WebBrowser browser) {
        this.browser = browser;
    }

    public Component getComponent() {
        return this.getBrowser().getComponent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WebBrowser getBrowser() {
        Object object = this.LOCK;
        synchronized (object) {
            if (null == this.browser) {
                this.browser = WebBrowserImplProvider.createBrowser();
                try {
                    this.browser.getComponent();
                }
                catch (ThreadDeath td) {
                    throw td;
                }
                catch (Throwable ex) {
                    Logger.getLogger(HtmlBrowserImpl.class.getName()).log(Level.INFO, ex.getMessage(), ex);
                    this.browser = new NoWebBrowserImpl(ex.getMessage());
                }
            }
            return this.browser;
        }
    }

    private EnhancedBrowser getEnhancedBrowser() {
        WebBrowser wb = this.getBrowser();
        if (wb instanceof EnhancedBrowser) {
            return (EnhancedBrowser)wb;
        }
        return null;
    }

    public void reloadDocument() {
        this.init(null);
    }

    public void stopLoading() {
        this.getBrowser().stopLoading();
    }

    public Lookup getLookup() {
        return this.getBrowser().getLookup();
    }

    public boolean ignoreChange(FileObject fo) {
        if (this.getEnhancedBrowser() != null) {
            return this.getEnhancedBrowser().ignoreChange(fo);
        }
        return BrowserSupport.ignoreChangeDefaultImpl((FileObject)fo);
    }

    private void init(final String url) {
        WebKitDebugging webkitDebugger;
        if (this.initialized) {
            this.setBrowserTo(url);
            return;
        }
        if (this.browserFeatures == null || !this.browserFeatures.isNetBeansIntegrationEnabled()) {
            this.setBrowserTo(url);
            return;
        }
        this.initialized = true;
        this.getBrowser();
        final TransportImplementation transport = (TransportImplementation)this.getLookup().lookup(TransportImplementation.class);
        if (url != null && transport instanceof TransportImplementationWithURLToLoad) {
            ((TransportImplementationWithURLToLoad)transport).setURLToLoad(url);
        }
        if ((webkitDebugger = (WebKitDebugging)this.getLookup().lookup(WebKitDebugging.class)) == null || this.projectContext == null) {
            this.setBrowserTo(url);
            return;
        }
        RP.post(new Runnable(){

            @Override
            public void run() {
                PageInspector inspector;
                transport.attach();
                webkitDebugger.getDebugger().enable();
                if (HtmlBrowserImpl.this.browserFeatures.isJsDebuggerEnabled()) {
                    HtmlBrowserImpl.this.session = WebKitUIManager.getDefault().createDebuggingSession(webkitDebugger, HtmlBrowserImpl.this.projectContext);
                }
                if (HtmlBrowserImpl.this.browserFeatures.isConsoleLoggerEnabled()) {
                    HtmlBrowserImpl.this.consoleLogger = WebKitUIManager.getDefault().createBrowserConsoleLogger(webkitDebugger, HtmlBrowserImpl.this.projectContext);
                }
                if (HtmlBrowserImpl.this.browserFeatures.isNetworkMonitorEnabled()) {
                    HtmlBrowserImpl.this.networkMonitor = WebKitUIManager.getDefault().createNetworkMonitor(webkitDebugger, HtmlBrowserImpl.this.projectContext);
                }
                if ((inspector = PageInspector.getDefault()) != null && HtmlBrowserImpl.this.browserFeatures.isPageInspectorEnabled()) {
                    inspector.inspectPage((Lookup)new ProxyLookup(new Lookup[]{HtmlBrowserImpl.this.getLookup(), HtmlBrowserImpl.this.projectContext}));
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        HtmlBrowserImpl.this.setBrowserTo(url);
                        if (url != null && transport instanceof TransportImplementationWithURLToLoad) {
                            ((TransportImplementationWithURLToLoad)transport).setURLToLoad(null);
                        }
                    }
                });
            }
        });
    }

    private void setBrowserTo(String url) {
        if (url != null) {
            this.getBrowser().setURL(url);
        } else {
            this.getBrowser().reloadDocument();
        }
    }

    private void destroy() {
        if (!this.initialized) {
            return;
        }
        this.initialized = false;
        final TransportImplementation transport = (TransportImplementation)this.getLookup().lookup(TransportImplementation.class);
        final WebKitDebugging webkitDebugger = (WebKitDebugging)this.getLookup().lookup(WebKitDebugging.class);
        final MessageDispatcherImpl dispatcher = (MessageDispatcherImpl)((Object)this.getLookup().lookup(MessageDispatcherImpl.class));
        if (webkitDebugger == null) {
            return;
        }
        RP.post(new Runnable(){

            @Override
            public void run() {
                if (HtmlBrowserImpl.this.session != null) {
                    WebKitUIManager.getDefault().stopDebuggingSession(HtmlBrowserImpl.this.session);
                }
                HtmlBrowserImpl.this.session = null;
                if (HtmlBrowserImpl.this.consoleLogger != null) {
                    WebKitUIManager.getDefault().stopBrowserConsoleLogger(HtmlBrowserImpl.this.consoleLogger);
                }
                HtmlBrowserImpl.this.consoleLogger = null;
                if (HtmlBrowserImpl.this.networkMonitor != null) {
                    WebKitUIManager.getDefault().stopNetworkMonitor(HtmlBrowserImpl.this.networkMonitor);
                }
                HtmlBrowserImpl.this.networkMonitor = null;
                if (dispatcher != null) {
                    dispatcher.dispatchMessage("inspect", null);
                }
                if (webkitDebugger.getDebugger().isEnabled()) {
                    webkitDebugger.getDebugger().disable();
                }
                webkitDebugger.reset();
                transport.detach();
            }
        });
    }

    public void setURL(URL url) {
        this.init(url.toString());
    }

    public URL getURL() {
        String strUrl = this.getBrowser().getURL();
        if (null == strUrl) {
            return null;
        }
        try {
            return new URL(strUrl);
        }
        catch (MalformedURLException ex) {
            Logger.getLogger(HtmlBrowserImpl.class.getName()).log(Level.FINE, null, ex);
            return null;
        }
    }

    public String getLocation() {
        return this.getBrowser().getURL();
    }

    public void setLocation(String str) {
        this.getBrowser().setURL(str);
    }

    public void setContent(String htmlContent) {
        this.getBrowser().setContent(htmlContent);
    }

    public String getStatusMessage() {
        return this.getBrowser().getStatusMessage();
    }

    public String getTitle() {
        return this.getBrowser().getTitle();
    }

    public boolean isForward() {
        return this.getBrowser().isForward();
    }

    public void forward() {
        this.getBrowser().forward();
    }

    public boolean isBackward() {
        return this.getBrowser().isBackward();
    }

    public void backward() {
        this.getBrowser().backward();
    }

    public boolean isHistory() {
        return this.getBrowser().isHistory();
    }

    public void showHistory() {
        this.getBrowser().showHistory();
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.getBrowser().addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.getBrowser().removePropertyChangeListener(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        this.destroy();
        Object object = this.LOCK;
        synchronized (object) {
            if (null != this.browser) {
                this.browser.dispose();
            }
            this.browser = null;
        }
    }

    public void initialize(WebBrowserFeatures browserFeatures) {
        this.browserFeatures = browserFeatures;
        if (this.getEnhancedBrowser() != null) {
            this.getEnhancedBrowser().initialize(browserFeatures);
        }
    }

    public void close(boolean closeTab) {
        if (this.getEnhancedBrowser() != null) {
            this.getEnhancedBrowser().close(closeTab);
        }
        this.destroy();
        if (closeTab) {
            // empty if block
        }
    }

    public void setProjectContext(Lookup projectContext) {
        this.projectContext = projectContext;
        if (this.getEnhancedBrowser() != null) {
            this.getEnhancedBrowser().setProjectContext(projectContext);
        }
    }

    public boolean canReloadPage() {
        return true;
    }
}

