/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.yaml;

import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jvyamlb.Position;
import org.jvyamlb.nodes.Node;
import org.jvyamlb.nodes.PositionedScalarNode;
import org.jvyamlb.nodes.PositionedSequenceNode;
import org.netbeans.modules.csl.api.ColoringAttributes;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.SemanticAnalyzer;
import org.netbeans.modules.languages.yaml.YamlParserResult;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.parsing.spi.Scheduler;
import org.netbeans.modules.parsing.spi.SchedulerEvent;

public class YamlSemanticAnalyzer
extends SemanticAnalyzer {
    private boolean cancelled;
    private Map<OffsetRange, Set<ColoringAttributes>> semanticHighlights;

    public Map<OffsetRange, Set<ColoringAttributes>> getHighlights() {
        return this.semanticHighlights;
    }

    protected final synchronized boolean isCancelled() {
        return this.cancelled;
    }

    protected final synchronized void resume() {
        this.cancelled = false;
    }

    public void cancel() {
        this.cancelled = true;
    }

    public int getPriority() {
        return 0;
    }

    public Class<? extends Scheduler> getSchedulerClass() {
        return Scheduler.EDITOR_SENSITIVE_TASK_SCHEDULER;
    }

    public void run(Parser.Result result, SchedulerEvent event) {
        this.resume();
        if (this.isCancelled()) {
            return;
        }
        YamlParserResult ypr = (YamlParserResult)result;
        if (ypr == null || ypr.getRootNodes().isEmpty()) {
            this.semanticHighlights = Collections.emptyMap();
            return;
        }
        List<Node> rootNodes = ypr.getRootNodes();
        HashMap<OffsetRange, Set<ColoringAttributes>> highlights = new HashMap<OffsetRange, Set<ColoringAttributes>>(100);
        IdentityHashMap<Object, Boolean> seen = new IdentityHashMap<Object, Boolean>(100);
        for (Node root : rootNodes) {
            this.addHighlights(ypr, root, highlights, seen, 0);
        }
        this.semanticHighlights = highlights;
    }

    private void addHighlights(YamlParserResult ypr, Node node, Map<OffsetRange, Set<ColoringAttributes>> highlights, IdentityHashMap<Object, Boolean> seen, int depth) {
        block14: {
            Object value;
            block13: {
                if (depth > 10 || node == null) {
                    return;
                }
                value = node.getValue();
                if (seen.containsKey(value)) {
                    return;
                }
                seen.put(value, Boolean.TRUE);
                if (!(value instanceof Map)) break block13;
                Map map = (Map)value;
                Set entrySet = map.entrySet();
                for (Map.Entry entry : entrySet) {
                    Object key = entry.getKey();
                    if (key instanceof PositionedSequenceNode) {
                        PositionedSequenceNode psn = (PositionedSequenceNode)key;
                        Object keyValue = psn.getValue();
                        assert (keyValue instanceof List);
                        List list = (List)keyValue;
                        for (Node child : list) {
                            if (child == node) {
                                return;
                            }
                            this.addHighlights(ypr, child, highlights, seen, depth + 1);
                        }
                        Object entryValue = entry.getValue();
                        if (!(entryValue instanceof PositionedSequenceNode)) continue;
                        psn = (PositionedSequenceNode)entryValue;
                        keyValue = psn.getValue();
                        assert (keyValue instanceof List);
                        list = (List)keyValue;
                        for (Node o : list) {
                            if (o == node) {
                                return;
                            }
                            this.addHighlights(ypr, o, highlights, seen, depth + 1);
                        }
                        continue;
                    }
                    assert (key instanceof PositionedScalarNode);
                    PositionedScalarNode scalar = (PositionedScalarNode)key;
                    Position.Range r = scalar.getRange();
                    OffsetRange range = ypr.getAstRange(r);
                    highlights.put(range, ColoringAttributes.METHOD_SET);
                    Node child = (Node)entry.getValue();
                    this.addHighlights(ypr, child, highlights, seen, depth + 1);
                }
                break block14;
            }
            if (!(value instanceof List)) break block14;
            List list = (List)value;
            for (Node child : list) {
                if (child == node) {
                    return;
                }
                this.addHighlights(ypr, child, highlights, seen, depth + 1);
            }
        }
    }
}

