/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.yaml;

import java.io.CharConversionException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.text.BadLocationException;
import org.jruby.util.ByteList;
import org.jvyamlb.Positionable;
import org.jvyamlb.nodes.Node;
import org.jvyamlb.nodes.PositionedScalarNode;
import org.jvyamlb.nodes.PositionedSequenceNode;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.csl.api.ElementHandle;
import org.netbeans.modules.csl.api.ElementKind;
import org.netbeans.modules.csl.api.HtmlFormatter;
import org.netbeans.modules.csl.api.Modifier;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.StructureItem;
import org.netbeans.modules.csl.api.StructureScanner;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.languages.yaml.YamlParserResult;
import org.openide.util.Exceptions;
import org.openide.xml.XMLUtil;

public class YamlScanner
implements StructureScanner {
    private static final Logger LOGGER = Logger.getLogger(YamlScanner.class.getName());

    public List<? extends StructureItem> scan(ParserResult info) {
        YamlParserResult result = (YamlParserResult)info;
        if (result != null) {
            return result.getItems();
        }
        return Collections.emptyList();
    }

    List<? extends StructureItem> scanStructure(YamlParserResult result) {
        List<Node> nodes = result.getRootNodes();
        if (nodes.size() > 0) {
            return YamlStructureItem.initialize(result, nodes);
        }
        return Collections.emptyList();
    }

    public Map<String, List<OffsetRange>> folds(ParserResult info) {
        YamlParserResult result = (YamlParserResult)info;
        if (result == null) {
            return Collections.emptyMap();
        }
        List<? extends StructureItem> items = result.getItems();
        if (items.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, List<OffsetRange>> folds = new HashMap<String, List<OffsetRange>>();
        ArrayList<OffsetRange> codeblocks = new ArrayList<OffsetRange>();
        folds.put("tags", codeblocks);
        BaseDocument doc = (BaseDocument)result.getSnapshot().getSource().getDocument(false);
        if (doc != null) {
            for (StructureItem structureItem : items) {
                try {
                    this.addBlocks(result, doc, codeblocks, structureItem);
                }
                catch (BadLocationException ble) {
                    Exceptions.printStackTrace((Throwable)ble);
                    break;
                }
            }
        }
        return folds;
    }

    private void addBlocks(YamlParserResult result, BaseDocument doc, List<OffsetRange> codeblocks, StructureItem item) throws BadLocationException {
        int docLength = doc.getLength();
        int begin = Math.min((int)item.getPosition(), docLength);
        int end = Math.min((int)item.getEndPosition(), docLength);
        int firstRowEnd = Utilities.getRowEnd((BaseDocument)doc, (int)begin);
        if (begin >= end || firstRowEnd == Utilities.getRowEnd((BaseDocument)doc, (int)end)) {
            return;
        }
        codeblocks.add(new OffsetRange(firstRowEnd, end));
        for (StructureItem child : item.getNestedItems()) {
            int childBegin = (int)child.getPosition();
            int childEnd = (int)child.getEndPosition();
            if (childBegin < begin || childEnd > end) continue;
            this.addBlocks(result, doc, codeblocks, child);
        }
    }

    public StructureScanner.Configuration getConfiguration() {
        return new StructureScanner.Configuration(false, false, 0);
    }

    private static class YamlStructureItem
    implements StructureItem,
    Comparable<YamlStructureItem> {
        private final String name;
        private List<YamlStructureItem> children;
        private final Node node;
        private final long begin;
        private final long end;

        YamlStructureItem(Node node, String name, long begin, long end) {
            this.node = node;
            this.name = name;
            this.begin = begin;
            this.end = end;
        }

        YamlStructureItem(Node node, String name, OffsetRange positions) {
            this(node, name, positions.getStart(), positions.getEnd());
        }

        public String getName() {
            return this.name;
        }

        public String getSortText() {
            return this.getName();
        }

        public String getHtml(HtmlFormatter formatter) {
            String s = this.getName();
            try {
                return XMLUtil.toElementContent((String)s);
            }
            catch (CharConversionException cce) {
                LOGGER.log(Level.FINE, "NAME:" + s, cce);
                return s;
            }
        }

        public ElementHandle getElementHandle() {
            return null;
        }

        public ElementKind getKind() {
            return ElementKind.ATTRIBUTE;
        }

        public Set<Modifier> getModifiers() {
            return Collections.emptySet();
        }

        public boolean isLeaf() {
            return this.getNestedItems().isEmpty();
        }

        private static List<? extends StructureItem> initialize(YamlParserResult result, List<Node> roots) {
            IdentityHashMap<Object, Boolean> seen = new IdentityHashMap<Object, Boolean>(100);
            ArrayList<YamlStructureItem> children = new ArrayList<YamlStructureItem>();
            for (Node root : roots) {
                YamlStructureItem fakeRoot = new YamlStructureItem(root, null, OffsetRange.NONE);
                YamlStructureItem.initializeChildren(result, fakeRoot, seen, 0);
                children.addAll(fakeRoot.children);
            }
            return children;
        }

        private static void initializeChildren(YamlParserResult result, YamlStructureItem item, IdentityHashMap<Object, Boolean> seen, int depth) {
            ArrayList<YamlStructureItem> children;
            if (depth > 20) {
                item.children = Collections.emptyList();
                return;
            }
            Node node = item.node;
            Object value = node.getValue();
            if (value == null) {
                item.children = Collections.emptyList();
                return;
            }
            boolean alreadySeen = false;
            if (seen.containsKey(value)) {
                alreadySeen = true;
            }
            seen.put(value, Boolean.TRUE);
            if (value instanceof Map) {
                Map map = (Map)value;
                children = new ArrayList<YamlStructureItem>();
                item.children = children;
                Set entrySet = map.entrySet();
                for (Map.Entry entry : entrySet) {
                    Node child;
                    Object key = entry.getKey();
                    if (key instanceof PositionedSequenceNode) {
                        PositionedSequenceNode psn = (PositionedSequenceNode)key;
                        Object keyValue = psn.getValue();
                        assert (keyValue instanceof List);
                        List list = (List)keyValue;
                        for (Node o : list) {
                            Object childValue = o.getValue();
                            if (childValue instanceof List || childValue instanceof Map) {
                                children.add(new YamlStructureItem(o, "list item", result.getAstRange(o)));
                                continue;
                            }
                            String childName = childValue.toString();
                            children.add(new YamlStructureItem(o, childName, result.getAstRange(o)));
                        }
                        Object entryValue = entry.getValue();
                        if (!(entryValue instanceof PositionedSequenceNode)) continue;
                        psn = (PositionedSequenceNode)entryValue;
                        keyValue = psn.getValue();
                        assert (keyValue instanceof List);
                        list = (List)keyValue;
                        for (Node o : list) {
                            Object childValue = o.getValue();
                            if (childValue instanceof List || childValue instanceof Map) {
                                children.add(new YamlStructureItem(o, "list item", result.getAstRange(o)));
                                continue;
                            }
                            String childName = childValue.toString();
                            children.add(new YamlStructureItem(o, childName, result.getAstRange(o)));
                        }
                        continue;
                    }
                    if (!(key instanceof PositionedScalarNode)) continue;
                    PositionedScalarNode scalar = (PositionedScalarNode)key;
                    Object childNameValue = scalar.getValue();
                    assert (childNameValue instanceof ByteList);
                    ByteList byteListChildName = (ByteList)childNameValue;
                    String childName = byteListChildName.toString();
                    try {
                        childName = new String(byteListChildName.bytes, "UTF-8");
                    }
                    catch (UnsupportedEncodingException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    if ((child = (Node)entry.getValue()) == null) continue;
                    int e = result.convertByteToUtf8(((Positionable)child).getRange().end.offset);
                    if (child.getValue() instanceof ByteList && ((ByteList)child.getValue()).length() == 0) {
                        e = result.convertByteToUtf8(scalar.getRange().end.offset);
                    }
                    children.add(new YamlStructureItem(child, childName.trim(), result.convertByteToUtf8(scalar.getRange().start.offset), e));
                }
                Collections.sort(children);
            } else if (value instanceof List) {
                List list = (List)value;
                children = new ArrayList(list.size());
                item.children = children;
                for (Node o : list) {
                    Object childValue = o.getValue();
                    if (childValue instanceof List || childValue instanceof Map) {
                        children.add(new YamlStructureItem(o, "list item", result.getAstRange(o)));
                        continue;
                    }
                    String childName = childValue.toString();
                    children.add(new YamlStructureItem(o, childName, result.getAstRange(o)));
                }
            } else {
                item.children = Collections.emptyList();
            }
            if (item.children.size() > 0) {
                for (YamlStructureItem child : item.children) {
                    if (alreadySeen) {
                        child.children = Collections.emptyList();
                        continue;
                    }
                    YamlStructureItem.initializeChildren(result, child, seen, depth + 1);
                }
            }
        }

        public List<? extends StructureItem> getNestedItems() {
            assert (this.children != null);
            return this.children;
        }

        public long getPosition() {
            return this.begin;
        }

        public long getEndPosition() {
            return this.end;
        }

        public ImageIcon getCustomIcon() {
            return null;
        }

        @Override
        public int compareTo(YamlStructureItem other) {
            return (int)(this.begin - other.begin);
        }
    }
}

