/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.server;

import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeListener;
import org.netbeans.spi.server.ServerInstanceProvider;
import org.openide.util.ChangeSupport;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.lookup.Lookups;

public final class ServerRegistry {
    public static final String SERVERS_PATH = "Servers";
    public static final String CLOUD_PATH = "Cloud";
    private static final Logger LOGGER = Logger.getLogger(ServerRegistry.class.getName());
    private static ServerRegistry registry;
    private static ServerRegistry cloudRegistry;
    private static ProviderLookupListener l;
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private final Lookup.Result<ServerInstanceProvider> result;
    private final Lookup lookup;
    private String path;
    private boolean cloud;

    private ServerRegistry(String path, boolean cloud) {
        this.path = path;
        this.cloud = cloud;
        this.lookup = Lookups.forPath((String)path);
        this.result = this.lookup.lookupResult(ServerInstanceProvider.class);
    }

    public String getPath() {
        return this.path;
    }

    public boolean isCloud() {
        return this.cloud;
    }

    public static synchronized ServerRegistry getInstance() {
        if (registry == null) {
            registry = new ServerRegistry(SERVERS_PATH, false);
            ServerRegistry.registry.result.allItems();
            l = new ProviderLookupListener(ServerRegistry.registry.changeSupport);
            ServerRegistry.registry.result.addLookupListener((LookupListener)l);
        }
        return registry;
    }

    public static synchronized ServerRegistry getCloudInstance() {
        if (cloudRegistry == null) {
            cloudRegistry = new ServerRegistry(CLOUD_PATH, true);
            ServerRegistry.cloudRegistry.result.allItems();
            l = new ProviderLookupListener(ServerRegistry.cloudRegistry.changeSupport);
            ServerRegistry.cloudRegistry.result.addLookupListener((LookupListener)l);
        }
        return cloudRegistry;
    }

    public Collection<? extends ServerInstanceProvider> getProviders() {
        Collection ret = this.result.allInstances();
        LOGGER.log(Level.FINE, "Returning providers {0}", ret);
        return ret;
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeSupport.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeSupport.removeChangeListener(listener);
    }

    private static class ProviderLookupListener
    implements LookupListener {
        private final ChangeSupport changeSupport;

        public ProviderLookupListener(ChangeSupport changeSupport) {
            this.changeSupport = changeSupport;
        }

        public void resultChanged(LookupEvent ev) {
            LOGGER.log(Level.FINE, "Provider lookup change {0}", ev);
            this.changeSupport.fireChange();
        }
    }
}

