/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.multitabs.prefs;

import java.util.prefs.Preferences;
import org.netbeans.core.multitabs.impl.ProjectSupport;
import org.netbeans.core.windows.options.WinSysPanel;
import org.openide.util.NbPreferences;

public class SettingsImpl {
    private final Preferences prefs = NbPreferences.forModule(SettingsImpl.class).node("multi-tabs");
    static final String PROP_SHOW_FOLDER_NAME = "show-folder-name";
    static final String PROP_SHOW_FULL_PATH = "show-full-path";
    static final String PROP_SAME_PROJECT_SAME_COLOR = "same-project-same-color";
    static final String PROP_SORT_DOCUMENT_LIST_BY_PROJECT = "sort-document-list-by-project";
    static final String PROP_ROW_COUNT = "row-count";
    static final String PROP_TAB_ROW_PER_PROJECT = "tab-row-per-project";

    private Preferences getWinSysPrefs() {
        return NbPreferences.forModule(WinSysPanel.class);
    }

    public int getTabsLocation() {
        return this.getWinSysPrefs().getInt("document.tabs.placement", 1);
    }

    boolean setTabsLocation(int newLocation) {
        boolean change = newLocation != this.getTabsLocation();
        this.getWinSysPrefs().putInt("document.tabs.placement", newLocation);
        return change;
    }

    public boolean isEnabled() {
        boolean res = false;
        ProjectSupport projectSupport = ProjectSupport.getDefault();
        res |= this.isShowFolderName();
        res |= this.isSameProjectSameColor() && projectSupport.isEnabled();
        res |= this.isShowFullPath();
        res |= this.isSortDocumentListByProject() && projectSupport.isEnabled();
        res |= this.getRowCount() > 1;
        res |= this.isTabRowPerProject() && projectSupport.isEnabled();
        return res |= this.getTabsLocation() != 1;
    }

    public boolean isShowFolderName() {
        return this.prefs.getBoolean(PROP_SHOW_FOLDER_NAME, false);
    }

    boolean setShowFolderName(boolean showFolders) {
        boolean change = showFolders != this.isShowFolderName();
        this.prefs.putBoolean(PROP_SHOW_FOLDER_NAME, showFolders);
        return change;
    }

    public boolean isShowFullPath() {
        return this.prefs.getBoolean(PROP_SHOW_FULL_PATH, false);
    }

    boolean setShowFullPath(boolean show) {
        boolean change = show != this.isShowFullPath();
        this.prefs.putBoolean(PROP_SHOW_FULL_PATH, show);
        return change;
    }

    public boolean isSameProjectSameColor() {
        return this.prefs.getBoolean(PROP_SAME_PROJECT_SAME_COLOR, false);
    }

    boolean setSameProjectSameColor(boolean enable) {
        boolean change = enable != this.isSameProjectSameColor();
        this.prefs.putBoolean(PROP_SAME_PROJECT_SAME_COLOR, enable);
        return change;
    }

    boolean setSortDocumentListByProject(boolean sort) {
        boolean change = sort != this.isSortDocumentListByProject();
        this.prefs.putBoolean(PROP_SORT_DOCUMENT_LIST_BY_PROJECT, sort);
        return change;
    }

    public boolean isSortDocumentListByProject() {
        return this.prefs.getBoolean(PROP_SORT_DOCUMENT_LIST_BY_PROJECT, false);
    }

    public boolean isTabRowPerProject() {
        return this.prefs.getBoolean(PROP_TAB_ROW_PER_PROJECT, false);
    }

    boolean setTabRowPerProject(boolean enable) {
        boolean change = enable != this.isTabRowPerProject();
        this.prefs.putBoolean(PROP_TAB_ROW_PER_PROJECT, enable);
        return change;
    }

    boolean setRowCount(int rowCount) {
        boolean change = rowCount != this.getRowCount();
        this.prefs.putInt(PROP_ROW_COUNT, rowCount);
        this.getWinSysPrefs().putBoolean("document.tabs.multirow", rowCount > 1);
        return change;
    }

    public int getRowCount() {
        int defRowCount = 1;
        if (this.getWinSysPrefs().getBoolean("document.tabs.multirow", false)) {
            defRowCount = 3;
        }
        return this.prefs.getInt(PROP_ROW_COUNT, defRowCount);
    }
}

