/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.multitabs.impl;

import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.core.multitabs.Controller;
import org.netbeans.core.multitabs.impl.AbstractTabDisplayer;
import org.netbeans.core.multitabs.impl.CloseButtonHandler;
import org.netbeans.core.multitabs.impl.TabTable;
import org.netbeans.core.multitabs.impl.TabTableModel;
import org.netbeans.core.multitabs.impl.TabTableUI;
import org.netbeans.swing.tabcontrol.TabData;
import org.netbeans.swing.tabcontrol.TabDataModel;
import org.openide.windows.TopComponent;

public class SimpleTabDisplayer
extends AbstractTabDisplayer
implements ListSelectionListener {
    private final TabTable table;

    public SimpleTabDisplayer(TabDataModel tabModel, int tabsLocation) {
        super(tabModel, tabsLocation);
        this.table = new TabTable(tabModel, tabsLocation);
        this.scrollPane.setViewportView(this.table);
        this.table.getSelectionModel().setSelectionInterval(0, 0);
        this.table.getSelectionModel().addListSelectionListener(this);
        this.table.getColumnModel().getSelectionModel().setSelectionInterval(0, 0);
        this.table.getColumnModel().getSelectionModel().addListSelectionListener(this);
        this.table.addMouseWheelListener(this);
        this.table.setBorder(TabTableUI.createTabBorder(this.table, tabsLocation));
    }

    @Override
    public Rectangle getTabBounds(int tabIndex) {
        Rectangle res = this.table.getTabBounds(tabIndex);
        if (null != res) {
            res = SwingUtilities.convertRectangle(this.table, res, this);
        }
        return res;
    }

    @Override
    public TabData getTabAt(Point p) {
        p = SwingUtilities.convertPoint(this, p, this.table);
        return this.table.getTabAt(p);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        int newSelIndex = -1;
        int selRow = this.table.getSelectedRow();
        int selCol = this.table.getSelectedColumn();
        if (selRow >= 0 && selCol >= 0) {
            TabData td = (TabData)this.table.getValueAt(selRow, selCol);
            if (td != null) {
                newSelIndex = this.tabModel.indexOf(td);
                Rectangle rect = this.table.getCellRect(selRow, selCol, true);
                this.table.scrollRectToVisible(rect);
                this.controller.setSelectedIndex(newSelIndex);
            }
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    int selIndex = SimpleTabDisplayer.this.controller.getSelectedIndex();
                    if (selIndex < 0) {
                        selIndex = 0;
                    }
                    SimpleTabDisplayer.this.setSelectedIndex(selIndex);
                }
            });
        }
    }

    @Override
    public void setSelectedIndex(int index) {
        TabTableModel model = (TabTableModel)this.table.getModel();
        int selRow = model.toRowIndex(index);
        int selCol = model.toColumnIndex(index);
        if (selCol >= 0 && selRow >= 0) {
            this.table.getSelectionModel().setSelectionInterval(selRow, selRow);
            this.table.getColumnModel().getSelectionModel().setSelectionInterval(selCol, selCol);
            Rectangle rect = this.table.getCellRect(selRow, selCol, true);
            this.table.scrollRectToVisible(rect);
        }
    }

    @Override
    public void attach(Controller controller) {
        super.attach(controller);
        this.table.addMouseListener(controller);
        CloseButtonHandler closeHandler = new CloseButtonHandler(this, controller);
        this.table.addMouseListener(closeHandler);
        this.table.addMouseMotionListener(closeHandler);
    }

    @Override
    public int dropIndexOfPoint(Point location) {
        int res = -1;
        TabData tab = this.table.getTabAt(location = SwingUtilities.convertPoint(this, location, this.table));
        if (null != tab) {
            res = this.getModel().indexOf(tab);
            Rectangle rect = this.getTabBounds(res);
            rect = SwingUtilities.convertRectangle(this, rect, this.table);
            res = this.orientation == 1 ? (location.y <= rect.y + rect.height / 2 ? Math.max(0, res) : ++res) : (location.x <= rect.x + rect.width / 2 ? Math.max(0, res) : ++res);
        }
        return res;
    }

    @Override
    public Rectangle dropIndication(TopComponent draggedTC, Point location) {
        int tabIndex = this.dropIndexOfPoint(location);
        if (tabIndex < 0) {
            return null;
        }
        if (tabIndex == this.getModel().size()) {
            --tabIndex;
        }
        Rectangle rect = this.getTabBounds(tabIndex);
        if (this.orientation == 1) {
            rect.y = location.y <= rect.y + rect.height / 2 ? (rect.y -= rect.height / 2) : (rect.y += rect.height / 2);
        } else {
            rect.x = location.x <= rect.x + rect.width / 2 ? (rect.x -= rect.width / 2) : (rect.x += rect.width / 2);
        }
        return rect;
    }
}

