/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.multitabs.impl;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.SwingUtilities;
import org.netbeans.core.multitabs.impl.MultiRowTabDisplayer;
import org.netbeans.core.multitabs.impl.ProjectSupport;
import org.netbeans.core.multitabs.impl.SingleRowTabTable;
import org.netbeans.swing.tabcontrol.TabDataModel;

public class RowPerProjectTabDisplayer
extends MultiRowTabDisplayer {
    public RowPerProjectTabDisplayer(TabDataModel tabModel, int tabsLocation, int rowCount) {
        super(tabModel, tabsLocation);
        ProjectSupport.getDefault().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                final int projectCount = ProjectSupport.getDefault().getOpenProjects().length;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        RowPerProjectTabDisplayer.this.adjustRows(projectCount);
                    }
                });
            }
        });
    }

    @Override
    void initRows() {
        int rowCount = ProjectSupport.getDefault().getOpenProjects().length + 1;
        for (int i = 0; i < rowCount; ++i) {
            this.addRowTable();
        }
    }

    private void adjustRows(int projectCount) {
        int rowCount = projectCount + 1;
        while (rowCount < this.rowTables.size() && this.rowTables.size() > 1) {
            this.removeTable();
        }
        while (rowCount > this.rowTables.size()) {
            this.addRowTable();
        }
        this.layoutManager.invalidate();
        this.invalidate();
        this.revalidate();
        this.doLayout();
    }

    private void removeTable() {
        if (this.rowTables.size() < 2) {
            return;
        }
        SingleRowTabTable table = (SingleRowTabTable)this.rowTables.get(this.rowTables.size() - 1);
        table.removeMouseWheelListener(this);
        table.removeMouseListener(this.controller);
        table.removeMouseListener(this.closeHandler);
        table.removeMouseMotionListener(this.closeHandler);
        table.getSelectionModel().removeListSelectionListener(this);
        table.getColumnModel().getSelectionModel().removeListSelectionListener(this);
        this.rowTables.remove(table);
        this.rowPanel.remove(table);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.layoutManager.invalidate();
    }
}

