/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.multitabs.impl;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.Icon;
import org.netbeans.core.multitabs.Settings;
import org.netbeans.core.multitabs.TabDecorator;
import org.netbeans.core.multitabs.impl.ProjectSupport;
import org.netbeans.swing.tabcontrol.TabData;

public class ProjectColorTabDecorator
extends TabDecorator {
    private static final Map<Object, Color> project2color = new WeakHashMap<Object, Color>(10);
    private static final Map<TabData, Color> tab2color = new WeakHashMap<TabData, Color>(10);
    private static final List<Color> backGroundColors = new ArrayList<Color>(10);

    public ProjectColorTabDecorator() {
        ProjectColorTabDecorator.updateColorMapping();
    }

    @Override
    public String getText(TabData tab) {
        return null;
    }

    @Override
    public Icon getIcon(TabData tab) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Color getBackground(TabData tab, boolean selected) {
        if (selected || !Settings.getDefault().isSameProjectSameColor()) {
            return null;
        }
        Color res = null;
        Map<TabData, Color> map = tab2color;
        synchronized (map) {
            res = tab2color.get(tab);
            if (null == res && null != (res = ProjectColorTabDecorator.getColorForTab(tab))) {
                tab2color.put(tab, res);
            }
        }
        return res;
    }

    @Override
    public Color getForeground(TabData tab, boolean selected) {
        if (selected || !Settings.getDefault().isSameProjectSameColor()) {
            return null;
        }
        return null == this.getBackground(tab, selected) ? null : Color.black;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintAfter(TabData tab, Graphics g, Rectangle tabRect, boolean isSelected) {
        if (!isSelected || !Settings.getDefault().isSameProjectSameColor()) {
            return;
        }
        Color c = null;
        Map<TabData, Color> map = tab2color;
        synchronized (map) {
            c = tab2color.get(tab);
            if (null == c) {
                c = ProjectColorTabDecorator.getColorForTab(tab);
                if (null == c) {
                    return;
                }
                tab2color.put(tab, c);
            }
        }
        g.setColor(c);
        Rectangle rect = new Rectangle(tabRect);
        rect.y += rect.height - 3;
        rect.grow(-1, -1);
        g.fillRect(rect.x, rect.y, rect.width, rect.height);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateColorMapping() {
        ProjectSupport.ProjectProxy[] projects = ProjectSupport.getDefault().getOpenProjects();
        Map<Object, Color> map = project2color;
        synchronized (map) {
            Color c;
            HashMap<Object, Color> oldColors = new HashMap<Object, Color>(project2color);
            project2color.clear();
            ArrayList<Color> availableColors = new ArrayList<Color>(backGroundColors);
            for (ProjectSupport.ProjectProxy p : projects) {
                c = (Color)oldColors.get(p.getToken());
                if (null == c) continue;
                availableColors.remove(c);
                project2color.put(p.getToken(), c);
            }
            if (availableColors.isEmpty()) {
                return;
            }
            for (ProjectSupport.ProjectProxy p : projects) {
                c = project2color.get(p.getToken());
                if (null != c) continue;
                c = (Color)availableColors.get(0);
                project2color.put(p.getToken(), c);
                availableColors.remove(c);
                if (availableColors.isEmpty()) break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Color getColorForTab(TabData tab) {
        ProjectSupport.ProjectProxy p = ProjectSupport.getDefault().getProjectForTab(tab);
        if (null != p) {
            Map<Object, Color> map = project2color;
            synchronized (map) {
                return project2color.get(p.getToken());
            }
        }
        return null;
    }

    static {
        backGroundColors.add(new Color(216, 255, 237));
        backGroundColors.add(new Color(255, 221, 221));
        backGroundColors.add(new Color(255, 247, 214));
        backGroundColors.add(new Color(216, 239, 255));
        backGroundColors.add(new Color(241, 255, 209));
        backGroundColors.add(new Color(255, 225, 209));
        backGroundColors.add(new Color(228, 255, 216));
        backGroundColors.add(new Color(227, 255, 158));
        backGroundColors.add(new Color(238, 209, 255));
        ProjectSupport.getDefault().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ProjectColorTabDecorator.updateColorMapping();
            }
        });
        ProjectColorTabDecorator.updateColorMapping();
    }
}

