/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.multitabs.impl;

import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.table.TableCellRenderer;
import org.netbeans.core.multitabs.Controller;
import org.netbeans.core.multitabs.TabDisplayer;
import org.netbeans.core.multitabs.impl.TabDataRenderer;
import org.netbeans.core.multitabs.impl.TabTable;
import org.netbeans.swing.tabcontrol.TabData;
import org.netbeans.swing.tabcontrol.event.TabActionEvent;

class CloseButtonHandler
extends MouseAdapter {
    private final TabDisplayer displayer;
    private final Controller controller;

    public CloseButtonHandler(TabDisplayer displayer, Controller controller) {
        this.controller = controller;
        this.displayer = displayer;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getSource() instanceof TabTable) {
            int tabIndex;
            TabData tab;
            TabTable table = (TabTable)e.getSource();
            if (!table.isShowing()) {
                return;
            }
            Point p = e.getPoint();
            int row = table.rowAtPoint(p);
            int col = table.columnAtPoint(p);
            if (row >= 0 && col >= 0 && table.isCloseButtonHighlighted(row, col) && null != (tab = table.getTabAt(p)) && (tabIndex = this.displayer.getModel().indexOf(tab)) >= 0) {
                TabActionEvent tae = null;
                tae = (e.getModifiersEx() & 0x40) > 0 ? new TabActionEvent((Object)this.displayer, "closeAll", tabIndex) : ((e.getModifiersEx() & 0x200) > 0 ? new TabActionEvent((Object)this.displayer, "closeAllButThis", tabIndex) : new TabActionEvent((Object)this.displayer, "close", tabIndex));
                if (null != tae) {
                    this.controller.postActionEvent(tae);
                }
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.mouseMoved(e);
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.mouseMoved(e);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (e.getSource() instanceof TabTable) {
            TabDataRenderer tabRenderer;
            TableCellRenderer ren;
            int closeButtonRow = -1;
            int closeButtonColumn = -1;
            TabTable table = (TabTable)e.getSource();
            Point p = e.getPoint();
            int row = table.rowAtPoint(p);
            int col = table.columnAtPoint(p);
            if (row >= 0 && col >= 0 && (ren = table.getCellRenderer(row, col)) instanceof TabDataRenderer && (tabRenderer = (TabDataRenderer)ren).isInCloseButton(table.getCellRect(row, col, true), p)) {
                closeButtonRow = row;
                closeButtonColumn = col;
            }
            table.setCurrentCloseButtonCoords(closeButtonRow, closeButtonColumn);
        }
    }
}

