/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.multitabs;

import org.netbeans.core.multitabs.Settings;
import org.netbeans.core.multitabs.TabDisplayer;
import org.netbeans.core.multitabs.impl.MultiRowTabDisplayer;
import org.netbeans.core.multitabs.impl.RowPerProjectTabDisplayer;
import org.netbeans.core.multitabs.impl.SimpleTabDisplayer;
import org.netbeans.swing.tabcontrol.TabDataModel;
import org.openide.util.Lookup;

public abstract class TabDisplayerFactory {
    public static TabDisplayerFactory getDefault() {
        TabDisplayerFactory res = (TabDisplayerFactory)Lookup.getDefault().lookup(TabDisplayerFactory.class);
        if (null == res) {
            res = new DefaultTabDisplayerFactory();
        }
        return res;
    }

    public abstract TabDisplayer createTabDisplayer(TabDataModel var1, int var2);

    private static class DefaultTabDisplayerFactory
    extends TabDisplayerFactory {
        private DefaultTabDisplayerFactory() {
        }

        @Override
        public TabDisplayer createTabDisplayer(TabDataModel tabModel, int orientation) {
            boolean multiRow;
            Settings settings = Settings.getDefault();
            boolean bl = multiRow = settings.getRowCount() > 1 || settings.isTabRowPerProject();
            if (multiRow && (orientation == 1 || orientation == 3)) {
                if (settings.isTabRowPerProject()) {
                    return new RowPerProjectTabDisplayer(tabModel, orientation, orientation);
                }
                return new MultiRowTabDisplayer(tabModel, orientation);
            }
            return new SimpleTabDisplayer(tabModel, orientation);
        }
    }
}

