/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.uihandler;

import java.awt.Component;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.XMLFormatter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JMenuItem;
import org.openide.util.Lookup;

class LogFormatter
extends XMLFormatter {
    private final Pattern javaHome;
    private final Pattern userHome;
    private final Pattern netbeansUserDir;
    private final Pattern netbeansHome;
    private final List<Pattern> installDirs;
    private final Pattern filePrefix = Pattern.compile("file:", 16);
    private final Pattern nbjclPrefix = Pattern.compile("nbjcl:", 16);
    private final Pattern jarPrefix = Pattern.compile("jar:", 16);
    private final Pattern hexPattern = Pattern.compile("@[0-9a-fA-F]*");

    public LogFormatter() {
        this.javaHome = this.convert(System.getProperty("java.home", ""));
        this.userHome = this.convert(System.getProperty("user.home", ""));
        this.netbeansUserDir = this.convert(System.getProperty("netbeans.user", ""));
        this.netbeansHome = this.convert(System.getProperty("netbeans.home", ""));
        String nbdirsStr = System.getProperty("netbeans.dirs");
        if (nbdirsStr != null) {
            String[] fields = nbdirsStr.split(File.pathSeparator);
            Pattern[] resultFields = new Pattern[fields.length];
            for (int i = 0; i < fields.length; ++i) {
                resultFields[i] = this.convert(fields[i]);
            }
            this.installDirs = Arrays.asList(resultFields);
        } else {
            this.installDirs = Collections.emptyList();
        }
    }

    private Pattern convert(String str) {
        try {
            String name = new File(str).toURI().toURL().toString();
            return Pattern.compile(name, 16);
        }
        catch (MalformedURLException exc) {
            Logger.getLogger(LogFormatter.class.getName()).log(Level.INFO, "unaccessible file", exc);
            return null;
        }
    }

    private void a2(StringBuffer sb, int x) {
        if (x < 10) {
            sb.append('0');
        }
        sb.append(x);
    }

    private void escape(StringBuffer sb, String text) {
        if (text == null) {
            text = "<null>";
        }
        for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            if (ch == '<') {
                sb.append("&lt;");
                continue;
            }
            if (ch == '>') {
                sb.append("&gt;");
                continue;
            }
            if (ch == '&') {
                sb.append("&amp;");
                continue;
            }
            if (ch < ' ' && ch != '\t' && ch != '\r' && ch != '\n') {
                sb.append('^').append((char)(ch + 64));
                continue;
            }
            sb.append(ch);
        }
    }

    private String doReplace(String where, Pattern pattern, String replacement) {
        return pattern.matcher(where).replaceAll(Matcher.quoteReplacement(replacement));
    }

    private void printFrame(StackTraceElement frame, StringBuffer sb) {
        if (frame == null) {
            return;
        }
        sb.append("    <frame>\n");
        sb.append("      <class>");
        this.escape(sb, frame.getClassName());
        sb.append("</class>\n");
        sb.append("      <method>");
        this.escape(sb, frame.getMethodName());
        sb.append("</method>\n");
        if (frame.getLineNumber() >= 0) {
            sb.append("      <line>");
            sb.append(frame.getLineNumber());
            sb.append("</line>\n");
        }
        sb.append("      <file>");
        ClassLoader loader = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
        Class<?> clazz = null;
        URL jarName = null;
        String fileName = null;
        try {
            clazz = loader.loadClass(frame.getClassName());
        }
        catch (Throwable exc) {
            Logger.getLogger(LogFormatter.class.getName()).log(Level.FINE, "Class loading error", exc);
        }
        if (clazz != null) {
            String[] fields = clazz.getName().split("\\.");
            if (fields.length > 0) {
                jarName = clazz.getResource(fields[fields.length - 1] + ".class");
            }
            if (jarName != null) {
                fileName = jarName.toString();
                int index = fileName.indexOf("!");
                if (index != -1) {
                    fileName = fileName.substring(0, index);
                }
                fileName = this.doReplace(fileName, this.jarPrefix, "");
                if (this.javaHome != null) {
                    fileName = this.doReplace(fileName, this.javaHome, "${java.home}");
                }
                if (this.netbeansHome != null) {
                    fileName = this.doReplace(fileName, this.netbeansHome, "${netbeans.home}");
                }
                if (this.netbeansUserDir != null) {
                    fileName = this.doReplace(fileName, this.netbeansUserDir, "${user.dir}");
                }
                Iterator<Pattern> it = this.installDirs.iterator();
                while (it.hasNext()) {
                    fileName = this.doReplace(fileName, it.next(), "${netBeansDir}");
                }
                if (this.userHome != null) {
                    fileName = this.doReplace(fileName, this.userHome, "${user.home}");
                }
                fileName = this.doReplace(fileName, this.filePrefix, "");
                fileName = this.doReplace(fileName, this.nbjclPrefix, "");
                this.escape(sb, fileName);
            }
        }
        sb.append("</file>\n");
        sb.append("    </frame>\n");
    }

    private void printCause(Throwable th, StringBuffer sb, StackTraceElement[] causedTrace) {
        sb.append("  <exception>\n");
        sb.append("   <message>");
        this.escape(sb, th.toString());
        sb.append("</message>\n");
        StackTraceElement[] trace = th.getStackTrace();
        int m = trace.length - 1;
        for (int n = causedTrace.length - 1; m >= 0 && n >= 0 && trace[m].equals(causedTrace[n]); --m, --n) {
        }
        int framesInCommon = trace.length - 1 - m;
        for (int i = 0; i <= m; ++i) {
            this.printFrame(trace[i], sb);
        }
        sb.append("   <more>");
        sb.append(framesInCommon);
        sb.append("</more>\n");
        sb.append("  </exception>\n");
        if (th.getCause() != null) {
            this.printCause(th.getCause(), sb, trace);
        }
    }

    private void printThrown(Throwable th, StringBuffer sb) {
        sb.append("  <exception>\n");
        sb.append("    <message>");
        this.escape(sb, th.toString());
        sb.append("</message>\n");
        StackTraceElement[] trace = th.getStackTrace();
        for (int i = 0; i < trace.length; ++i) {
            this.printFrame(trace[i], sb);
        }
        sb.append("  </exception>\n");
        if (th.getCause() != null) {
            this.printCause(th.getCause(), sb, trace);
        }
    }

    private void appendISO8601(StringBuffer sb, long millis) {
        Date date = new Date(millis);
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        sb.append(calendar.get(1));
        sb.append('-');
        this.a2(sb, calendar.get(2) + 1);
        sb.append('-');
        this.a2(sb, calendar.get(5));
        sb.append('T');
        this.a2(sb, calendar.get(11));
        sb.append(':');
        this.a2(sb, calendar.get(12));
        sb.append(':');
        this.a2(sb, calendar.get(13));
    }

    @Override
    public String format(LogRecord record) {
        StringBuffer sb = new StringBuffer(1000);
        sb.append("<record>\n");
        sb.append("  <date>");
        this.appendISO8601(sb, record.getMillis());
        sb.append("</date>\n");
        sb.append("  <millis>");
        sb.append(record.getMillis());
        sb.append("</millis>\n");
        sb.append("  <sequence>");
        sb.append(record.getSequenceNumber());
        sb.append("</sequence>\n");
        String name = record.getLoggerName();
        if (name != null) {
            sb.append("  <logger>");
            this.escape(sb, name);
            sb.append("</logger>\n");
        }
        sb.append("  <level>");
        this.escape(sb, record.getLevel().toString());
        sb.append("</level>\n");
        if (record.getSourceClassName() != null) {
            sb.append("  <class>");
            this.escape(sb, record.getSourceClassName());
            sb.append("</class>\n");
        }
        if (record.getSourceMethodName() != null) {
            sb.append("  <method>");
            this.escape(sb, record.getSourceMethodName());
            sb.append("</method>\n");
        }
        sb.append("  <thread>");
        sb.append(record.getThreadID());
        sb.append("</thread>\n");
        String message = record.getMessage();
        if (message != null) {
            sb.append("  <message>");
            this.escape(sb, message);
            sb.append("</message>\n");
        }
        ResourceBundle bundle = record.getResourceBundle();
        try {
            if (bundle != null && bundle.getString(message) != null) {
                sb.append("  <key>");
                this.escape(sb, message);
                sb.append("</key>\n");
                sb.append("  <catalog>");
                this.escape(sb, record.getResourceBundleName());
                sb.append("</catalog>\n");
            }
        }
        catch (Exception exc) {
            Logger.getLogger(LogFormatter.class.getName()).log(Level.FINE, "Catalog loading error", exc);
        }
        Object[] parameters = record.getParameters();
        if (parameters != null && parameters.length != 0 && (message == null || message.indexOf("{") == -1)) {
            for (int i = 0; i < parameters.length; ++i) {
                sb.append("  <param>");
                try {
                    this.escape(sb, this.paramToString(parameters[i]));
                }
                catch (Exception ex) {
                    sb.append("???");
                }
                sb.append("</param>\n");
            }
        }
        if (record.getThrown() != null) {
            this.printThrown(record.getThrown(), sb);
        }
        sb.append("</record>\n");
        return sb.toString();
    }

    private String paramToString(Object obj) {
        AbstractButton ab;
        Action a;
        if (obj == null) {
            return "null";
        }
        if (obj instanceof JMenuItem && (a = (ab = (JMenuItem)obj).getAction()) != null) {
            return ab.getClass().getName() + '[' + this.paramToString(a) + ']';
        }
        if (obj instanceof AbstractButton) {
            ab = (AbstractButton)obj;
            return ab.getClass().getName() + '[' + ab.getText() + ']';
        }
        if (obj instanceof Action) {
            Action a2 = (Action)obj;
            if (a2.getClass().getName().endsWith("$DelegateAction") && a2.getClass().getName().startsWith("org.openide")) {
                return this.hexPattern.matcher(a2.toString()).replaceAll("," + a2.getValue("Name"));
            }
            return a2.getClass().getName() + '[' + a2.getValue("Name") + ']';
        }
        if (obj instanceof Component) {
            Component c = (Component)obj;
            return c.getClass().getName() + '[' + c.getName() + ']';
        }
        return obj.toString();
    }
}

