/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.event.util.raw.tcp;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class TimeoutInputStreamReader
extends FilterInputStream {
    long timeout;

    public long getTimeout() {
        return this.timeout;
    }

    public final void setTimeout(long timeout) {
        if (timeout < 0L) {
            throw new IllegalArgumentException("timeout cannot be less then 0");
        }
        this.timeout = timeout;
    }

    public TimeoutInputStreamReader(InputStream in) {
        super(in);
    }

    public TimeoutInputStreamReader(InputStream in, long timeout) {
        this(in);
        this.setTimeout(timeout);
    }

    public int read(byte[] b) throws IOException {
        long start = System.currentTimeMillis();
        int totalReadCount = super.read(b);
        if (totalReadCount < 0) {
            return totalReadCount;
        }
        while (totalReadCount == b.length && this.isWithinTimeout(start)) {
            int count = super.read(b, totalReadCount, b.length - totalReadCount);
            if (count < 0) {
                return totalReadCount;
            }
            totalReadCount += count;
        }
        return totalReadCount;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        long start = System.currentTimeMillis();
        int totalReadCount = super.read(b, off, len);
        if (totalReadCount < 0) {
            return totalReadCount;
        }
        while (totalReadCount == len && this.isWithinTimeout(start)) {
            int count = super.read(b, off + totalReadCount, len - totalReadCount);
            if (count < 0) {
                return totalReadCount;
            }
            totalReadCount += count;
        }
        return totalReadCount;
    }

    private boolean isWithinTimeout(long start) {
        return System.currentTimeMillis() - start < this.timeout;
    }
}

