/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.event.util.raw.tcp;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class ProgressMonitorInputStream
extends FilterInputStream {
    volatile int bytesRead;

    public int getBytesRead() {
        return this.bytesRead;
    }

    public ProgressMonitorInputStream(InputStream in) {
        super(in);
        if (in == null) {
            throw new NullPointerException();
        }
    }

    public int read() throws IOException {
        int c = super.read();
        if (c >= 0) {
            ++this.bytesRead;
        }
        return c;
    }

    public int read(byte[] b) throws IOException {
        int n = super.read(b);
        if (n > 0) {
            this.bytesRead += n;
        }
        return n;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int n = super.read(b, off, len);
        if (n > 0) {
            this.bytesRead += n;
        }
        return n;
    }

    public long skip(long n) throws IOException {
        long bs = super.skip(n);
        if (bs > 0L) {
            this.bytesRead = (int)((long)this.bytesRead + bs);
        }
        return bs;
    }
}

