/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.event.util.raw.tcp;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ForwarderInputStream
extends FilterInputStream {
    private static final Log log = LogFactory.getLog(ForwarderInputStream.class);
    private final OutputStream out;
    private final boolean strict;

    public ForwarderInputStream(InputStream in, OutputStream out) {
        this(in, out, false);
    }

    public ForwarderInputStream(InputStream in, OutputStream out, boolean strict) {
        super(in);
        if (out == null) {
            throw new IllegalArgumentException("parameter out cannot be null");
        }
        this.out = out;
        this.strict = strict;
    }

    private void handleExceptions(String message, IOException ex) throws IOException {
        if (this.strict) {
            throw ex;
        }
        log.debug((Object)message, (Throwable)ex);
    }

    public void close() throws IOException {
        super.close();
        try {
            this.out.close();
        }
        catch (IOException ex) {
            this.handleExceptions("close()", ex);
        }
    }

    public int read() throws IOException {
        int c = super.read();
        if (c >= 0) {
            try {
                this.out.write(c);
            }
            catch (IOException ex) {
                this.handleExceptions("read()", ex);
            }
        }
        return c;
    }

    public int read(byte[] b) throws IOException {
        int c = super.read(b);
        if (c >= 0) {
            try {
                this.out.write(b, 0, c);
            }
            catch (IOException ex) {
                this.handleExceptions("read(byte[])", ex);
            }
        }
        return c;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int c = super.read(b, off, len);
        if (c >= 0) {
            try {
                this.out.write(b, off, c);
            }
            catch (IOException ex) {
                this.handleExceptions("read(byte[])", ex);
            }
        }
        return c;
    }
}

