/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.event.util.raw.tcp;

import de.proveo.event.util.AbstractEventHandler;
import de.proveo.event.util.raw.tcp.ForwarderInputStream;
import de.proveo.event.util.raw.tcp.ProgressMonitorInputStream;
import de.proveo.event.util.raw.tcp.ProgressMonitorOutputStream;
import de.proveo.event.util.raw.tcp.StreamConnectionHandler;
import de.proveo.rts.configuration.monitor.MonitoringMBean;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTCPConnectionHandler
extends AbstractEventHandler
implements StreamConnectionHandler {
    protected InputStream in;
    protected OutputStream out;
    ProgressMonitorInputStream progressIn;
    ProgressMonitorOutputStream progressOut;
    private MonitoringMBean tcpBeginConnectionMonitoringMBean;
    private MonitoringMBean tcpEndConnectionMonitoringMBean;
    private final Log log;
    protected Socket socket;

    protected AbstractTCPConnectionHandler(Log log) {
        super(log);
        this.log = log;
    }

    public void setTcpBeginConnectionMonitoringMBean(MonitoringMBean tcpBeginConnectionMonitoringMBean) {
        this.tcpBeginConnectionMonitoringMBean = tcpBeginConnectionMonitoringMBean;
    }

    public void setTcpEndConnectionMonitoringMBean(MonitoringMBean tcpEndConnectionMonitoringMBean) {
        this.tcpEndConnectionMonitoringMBean = tcpEndConnectionMonitoringMBean;
    }

    @Override
    public int getBytesRX() {
        if (this.progressIn != null) {
            return this.progressIn.getBytesRead();
        }
        return -1;
    }

    @Override
    public int getBytesTX() {
        if (this.progressOut != null) {
            return this.progressOut.getBytesWrite();
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processConnection(Socket socket) throws IOException {
        this.socket = socket;
        try {
            this.beginConnection();
            this.processData();
        }
        finally {
            this.endConnection();
        }
    }

    private void beginConnection() throws IOException {
        if (this.getLog().isTraceEnabled()) {
            this.getLog().trace((Object)("connection from: " + this.socket));
        }
        if (this.tcpBeginConnectionMonitoringMBean != null) {
            this.tcpBeginConnectionMonitoringMBean.increment();
        }
        this.progressIn = new ProgressMonitorInputStream(this.socket.getInputStream());
        this.in = new BufferedInputStream(this.progressIn);
        this.progressOut = new ProgressMonitorOutputStream(this.socket.getOutputStream());
        this.out = new BufferedOutputStream(this.progressOut);
        if (this.getEventInterfaceMBean().isForwardingEnabled()) {
            try {
                Socket forwarderSocket = new Socket(this.getEventInterfaceMBean().getForwardingHost(), this.getEventInterfaceMBean().getForwardingPort());
                this.in = new ForwarderInputStream(this.in, forwarderSocket.getOutputStream(), this.getEventInterfaceMBean().isForwardingStrict());
            }
            catch (IOException ex) {
                if (this.getEventInterfaceMBean().isForwardingStrict()) {
                    throw ex;
                }
                this.log.debug((Object)"beginConnection() forward", (Throwable)ex);
            }
        }
    }

    private void endConnection() {
        if (this.getLog().isTraceEnabled()) {
            this.getLog().trace((Object)("end connection with: " + this.socket + " RX:" + this.getBytesRX() + " TX:" + this.getBytesTX()));
        }
        if (this.tcpEndConnectionMonitoringMBean != null) {
            this.tcpEndConnectionMonitoringMBean.increment();
        }
        this.socket = null;
        this.in = null;
        this.progressIn = null;
        this.out = null;
        this.progressOut = null;
    }

    protected abstract void processData() throws IOException;

    @Override
    protected void fillMetaInfo(Map<String, Object> metaInfo, List<Long> efmUnitIds, long eventReceiveTime) {
        super.fillMetaInfo(metaInfo, efmUnitIds, eventReceiveTime);
        metaInfo.put("remoteAddr", this.socket.getInetAddress().toString());
    }

    @Override
    public String getApplicationLayerStatus() {
        return null;
    }
}

