/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.event.util.raw.tcp;

import de.proveo.event.util.raw.WorkerMonitoring;
import de.proveo.event.util.raw.WorkerPool;
import de.proveo.event.util.raw.WorkerStatusInfo;
import de.proveo.event.util.raw.tcp.TimeComparator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractEndpointStatus {
    private final List<WorkerStatusInfo> workerStatus = new ArrayList<WorkerStatusInfo>();
    private int poolSize;
    private int stateWaiting;
    private int stateConnected;
    private int stateDisconnected;

    public AbstractEndpointStatus(WorkerPool workerPool) {
        if (workerPool != null) {
            for (WorkerMonitoring monitor : workerPool.getWorkerMonitoring()) {
                WorkerStatusInfo status = monitor.getWorkerStatusInfo();
                ++this.poolSize;
                switch (status.getStatus()) {
                    case WAITING: {
                        ++this.stateWaiting;
                        break;
                    }
                    case CONNECTED: {
                        ++this.stateConnected;
                        break;
                    }
                    case DISCONNECTED: {
                        ++this.stateDisconnected;
                    }
                }
                this.workerStatus.add(status);
            }
            Collections.sort(this.workerStatus, new TimeComparator());
        }
    }

    public boolean isStatusAvailable() {
        return this.workerStatus != null;
    }

    public int getPoolSize() {
        return this.poolSize;
    }

    public int getStateConnected() {
        return this.stateConnected;
    }

    public int getStateDisconnected() {
        return this.stateDisconnected;
    }

    public int getStateWaiting() {
        return this.stateWaiting;
    }

    public Collection<WorkerStatusInfo> getWorkerStatus() {
        return this.workerStatus;
    }
}

