/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.event.util.raw;

public class ByteUtil {
    public static int getIntegerLSB(byte[] b, int off, int len) {
        int value = 0;
        if (len > 4) {
            throw new IllegalArgumentException();
        }
        for (int index = off; index < off + len; ++index) {
            int i = ByteUtil.getInteger(b[index]);
            value += i << (index - off) * 8;
        }
        return value;
    }

    public static long getUnsingedIntegerLSB(byte[] b, int off, int len) {
        long value = 0L;
        if (len > 4) {
            throw new IllegalArgumentException();
        }
        for (int index = off; index < off + len; ++index) {
            long i = ByteUtil.getInteger(b[index]);
            long x = i << (int)((long)(index - off) * 8L);
            value += x;
        }
        return value;
    }

    public static void setIntegerLSB(int value, byte[] b, int off, int len) {
        if (len > 4) {
            throw new IllegalArgumentException();
        }
        for (int index = off; index < off + len; ++index) {
            int shift = (index - off) * 8;
            int v = value & 255 << shift;
            b[index] = (byte)(v >>= shift);
        }
    }

    public static String toHexString(byte[] b, int off, int len) {
        StringBuilder sb = new StringBuilder(b.length * 3);
        for (int i = off; i < off + len; ++i) {
            int value = b[i] & 0xFF;
            if (value < 16) {
                sb.append('0');
            }
            sb.append(Integer.toHexString(value));
            sb.append(' ');
        }
        return sb.toString().trim().toUpperCase();
    }

    public static String toHexString(byte[] b) {
        return ByteUtil.toHexString(b, 0, b.length);
    }

    public static boolean equals(byte[] buffer1, int off1, byte[] buffer2, int off2, int len) {
        if (len < 1) {
            throw new IllegalArgumentException("check length cannot be less then 1");
        }
        if (buffer1.length < off1 + len) {
            return false;
        }
        if (buffer2.length < off2 + len) {
            return false;
        }
        for (int index = 0; index < len; ++index) {
            if (buffer1[off1 + index] == buffer2[off2 + index]) continue;
            return false;
        }
        return true;
    }

    public static int getInteger(byte b) {
        int i = b;
        if (i < 0) {
            i += 256;
        }
        return i;
    }

    public static boolean isBitSet(long word, int bitNumber) {
        if (bitNumber < 0 || bitNumber > 31) {
            throw new IllegalArgumentException("bitNumber mus be between 0..31");
        }
        long mask = 1 << bitNumber;
        return (mask &= word) > 0L;
    }

    public static boolean isBitSet(int b, int bitNumber) {
        if (bitNumber < 0 || bitNumber > 7) {
            throw new IllegalArgumentException("bitNumber mus be between 0..7");
        }
        int mask = 1 << bitNumber;
        return (mask &= b) > 0;
    }

    public static byte[] toByteArray(int[] intArr) {
        byte[] bArr = new byte[intArr.length];
        for (int index = 0; index < bArr.length; ++index) {
            bArr[index] = (byte)intArr[index];
        }
        return bArr;
    }
}

