/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.event.util.efm;

import de.proveo.util.geo.GPSPosition;
import java.util.List;
import java.util.Map;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EFMEventUtil {
    public static void addZeroConfParameters(Properties efmEvent, long timeStamp, Map metainfo) {
        efmEvent.setProperty("hwsn", (String)metainfo.get("hwsn"));
        efmEvent.setProperty("hwType", (String)metainfo.get("hwType"));
        efmEvent.setProperty("t", Long.toString(timeStamp));
    }

    public static void addGeneralParameters(Properties efmEvent, List<Long> unitIds, long timeStamp) {
        if (unitIds.size() > 1) {
            for (int index = 0; index < unitIds.size(); ++index) {
                efmEvent.setProperty("u" + (1 + index), Long.toString(unitIds.get(index)));
            }
        } else {
            efmEvent.setProperty("u", Long.toString(unitIds.get(0)));
        }
        efmEvent.setProperty("t", Long.toString(timeStamp));
    }

    public static double getDistance(String rmcRecord1, String rmcRecord2) {
        if (rmcRecord1 == null || rmcRecord2 == null) {
            return -1.0;
        }
        GPSPosition pos1 = new GPSPosition(rmcRecord1, null);
        GPSPosition pos2 = new GPSPosition(rmcRecord2, null);
        return GPSPosition.getDistance((GPSPosition)pos1, (GPSPosition)pos2);
    }
}

