/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.browser.ui;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.core.HtmlBrowserComponent;
import org.netbeans.modules.web.browser.api.WebBrowser;
import org.netbeans.modules.web.browser.api.WebBrowsers;
import org.netbeans.modules.web.browser.ui.DeveloperToolbar;
import org.openide.awt.HtmlBrowser;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class DeveloperHtmlBrowserComponent
extends HtmlBrowserComponent {
    private final DeveloperToolbar devToolbar = DeveloperToolbar.create();

    public DeveloperHtmlBrowserComponent() {
        super(false, false);
    }

    public DeveloperHtmlBrowserComponent(HtmlBrowser.Factory factory) {
        super(factory, false, false);
    }

    public void open() {
        WindowManager wm = WindowManager.getDefault();
        Mode mode = wm.findMode((TopComponent)this);
        if (null == mode && !Boolean.getBoolean("webpreview.document") && null != (mode = wm.findMode("webpreview"))) {
            mode.dockInto((TopComponent)this);
        }
        super.open();
    }

    protected void componentOpened() {
        super.componentOpened();
        this.devToolbar.intialize(this.getLookup());
    }

    public int getPersistenceType() {
        return 1;
    }

    protected HtmlBrowser createBrowser(HtmlBrowser.Factory factory, boolean showToolbar, boolean showStatus) {
        return new HtmlBrowser(factory, showToolbar, showStatus, this.devToolbar.getComponent());
    }

    protected String preferredID() {
        return super.preferredID() + "_dev";
    }

    protected Object writeReplace() throws ObjectStreamException {
        return new BrowserReplacer(this);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
    }

    public static final class BrowserReplacer
    implements Externalizable {
        static final long serialVersionUID = 3215713034827048413L;
        private transient DeveloperHtmlBrowserComponent bComp = null;
        transient boolean statLine;
        transient boolean toolbar;
        transient URL url;

        public BrowserReplacer() {
        }

        public BrowserReplacer(DeveloperHtmlBrowserComponent comp) {
            this.bComp = comp;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeBoolean(this.bComp.isStatusLineVisible());
            out.writeBoolean(this.bComp.isToolbarVisible());
            out.writeObject(this.bComp.getDocumentURL());
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.statLine = in.readBoolean();
            this.toolbar = in.readBoolean();
            this.url = (URL)in.readObject();
        }

        private Object readResolve() throws ObjectStreamException {
            try {
                if ("http".equals(this.url.getProtocol()) && InetAddress.getByName(this.url.getHost()).equals(InetAddress.getLocalHost())) {
                    this.url.openStream();
                }
            }
            catch (UnknownHostException exc) {
            }
            catch (SecurityException exc) {
            }
            catch (NullPointerException exc) {
            }
            catch (IOException exc) {
                return null;
            }
            catch (Exception exc) {
                Logger.getLogger(HtmlBrowserComponent.class.getName()).log(Level.WARNING, null, exc);
            }
            WebBrowser browser = WebBrowsers.getInstance().getPreferred();
            if (null == browser || !browser.isEmbedded()) {
                browser = WebBrowsers.getInstance().getEmbedded();
            }
            if (null != browser && browser.isEmbedded()) {
                HtmlBrowser.Factory factory = browser.getHtmlBrowserFactory();
                this.bComp = new DeveloperHtmlBrowserComponent(factory);
                this.bComp.setURL(this.url);
            }
            return this.bComp;
        }
    }
}

