/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.xml.request.stateModel;

import de.proveo.util.dependencyInjector.Dependency;
import de.proveo.wwt.datamodel.locale.Locale;
import de.proveo.wwt.datamodel.module.ModuleType;
import de.proveo.wwt.datamodel.stateModel.StateModel;
import de.proveo.wwt.logic.app.locale.LocaleFacadeLocal;
import de.proveo.wwt.logic.app.resource.ResourceFacadeLocal;
import de.proveo.wwt.logic.ejb.stateModel.StateModelFacadeLocal;
import de.proveo.wwt.logic.xml.request.XmlRequestHandlerBase;
import de.proveo.wwt.logic.xml.request.XmlRequestSchema;
import de.proveo.xml.fleet_management.meta_1.MetadataList;
import de.proveo.xml.fleet_management.meta_1.MetadataValue;
import de.proveo.xml.fleet_management.resources_1.Resource;
import de.proveo.xml.fleet_management.resources_1.ResourceList;
import de.proveo.xml.fleet_management.statemodel_1.State;
import de.proveo.xml.fleet_management.statemodel_1.StateModels;
import de.proveo.xml.fleet_management.statemodel_1.States;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;

@XmlRequestSchema(value={"http://proveo.de/xml/fleet-management/statemodel-1.0"})
public class StateModel_1_0_RequestHandler
extends XmlRequestHandlerBase<StateModels> {
    public final String STATE_MODEL_PREFIX = "stateModel.";
    public final String STATE_PREFIX = "state.";
    @Dependency
    private StateModelFacadeLocal stateModelFacade;
    @Dependency
    private ResourceFacadeLocal resourceFacade;
    @Dependency
    private LocaleFacadeLocal localeFacade;
    private List<Locale> locales;
    private Map<Integer, ResourceBundle> bundleMap = new HashMap<Integer, ResourceBundle>();
    private boolean skipResources;
    private boolean generateStatistics;

    @Override
    public StateModels handleRequest(String schemaNamespace, Map<String, String> parameters) {
        this.parseParameters(parameters);
        if (this.generateStatistics) {
            this.startTimer();
        }
        StateModels xmlStateModels = new StateModels();
        List xmlStateModelList = xmlStateModels.getStateModel();
        this.copyStateModels(xmlStateModelList);
        if (this.generateStatistics) {
            MetadataValue duration = new MetadataValue();
            duration.setKey(this.EXECUTION_TIME_KEY);
            duration.setValue(this.stopTimer());
            xmlStateModels.setMeta(new MetadataList());
            xmlStateModels.getMeta().getValue().add(duration);
        }
        return xmlStateModels;
    }

    private void parseParameters(Map<String, String> parameters) {
        this.setDefaultParameters();
        if (parameters != null) {
            String value = parameters.get("skipResources");
            if (value != null) {
                this.skipResources = Boolean.parseBoolean(value);
            }
            if ((value = parameters.get("generateStatistics")) != null) {
                this.generateStatistics = Boolean.parseBoolean(value);
            }
        }
    }

    private void setDefaultParameters() {
        this.skipResources = false;
        this.generateStatistics = false;
    }

    private void copyStateModels(List<de.proveo.xml.fleet_management.statemodel_1.StateModel> xmlStateModelList) {
        if (!this.skipResources) {
            this.fetchResourceBundles();
        }
        List<StateModel> stateModels = this.stateModelFacade.getActiveStateModels();
        for (StateModel stateModel : stateModels) {
            de.proveo.xml.fleet_management.statemodel_1.StateModel xmlStateModel = new de.proveo.xml.fleet_management.statemodel_1.StateModel();
            xmlStateModel.setId(stateModel.getId());
            xmlStateModel.setPriority(stateModel.getPriority().getValue().intValue());
            xmlStateModel.setSortOrder(stateModel.getOrder());
            xmlStateModel.setFilterable(stateModel.isFilterable());
            xmlStateModel.setDeleteable(stateModel.isDeleteable());
            xmlStateModel.setRemark(stateModel.getRemark());
            if (!this.skipResources) {
                xmlStateModel.setResources(new ResourceList());
                this.addResources(xmlStateModel.getResources().getResource(), "stateModel." + stateModel.getId());
            }
            xmlStateModel.setStates(new States());
            List stateList = xmlStateModel.getStates().getState();
            this.copyStates(stateModel, stateList);
            xmlStateModelList.add(xmlStateModel);
        }
    }

    private void copyStates(StateModel stateModel, List<State> xmlStateList) {
        List<de.proveo.wwt.datamodel.stateModel.State> states = this.stateModelFacade.getStates(stateModel.getId());
        for (de.proveo.wwt.datamodel.stateModel.State state : states) {
            State xmlState = new State();
            xmlState.setId(state.getId());
            xmlState.setPriority(state.getPriority().getValue().intValue());
            xmlState.setSortOrder(state.getOrder());
            xmlState.setDeleteable(state.isDeleteable());
            xmlState.setRemark(state.getRemark());
            xmlState.setColor(StateModel_1_0_RequestHandler.convertToHtmlColor(state.getColor()));
            xmlState.setUserSettable(state.isUserSettable());
            if (!this.skipResources) {
                xmlState.setResources(new ResourceList());
                this.addResources(xmlState.getResources().getResource(), "state." + state.getId());
            }
            xmlStateList.add(xmlState);
        }
    }

    private void addResources(List<Resource> resourceList, String key) {
        for (Locale locale : this.locales) {
            Resource resource = new Resource();
            resource.setLanguage(locale.getName());
            resource.setValue(this.bundleMap.get(locale.getId()).getString(key));
            resourceList.add(resource);
        }
    }

    private void fetchResourceBundles() {
        this.locales = this.localeFacade.getLocales();
        for (Locale locale : this.locales) {
            java.util.Locale tempLocale = new java.util.Locale(locale.getLanguage(), locale.getCountry());
            ResourceBundle bundle = this.resourceFacade.getResourceBundle(ModuleType.STATE_MODEL.getValue(), tempLocale);
            this.bundleMap.put(locale.getId(), bundle);
        }
    }

    private static String convertToHtmlColor(String color) {
        String[] colors = color.split(",");
        return String.format("#%02X%02X%02X", Integer.parseInt(colors[0]), Integer.parseInt(colors[1]), Integer.parseInt(colors[2]));
    }
}

