/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.xml.request;

import de.proveo.util.dependencyInjector.JndiDependencyInjector;
import de.proveo.wwt.logic.xml.request.XmlRequestHandlerBase;
import de.proveo.wwt.logic.xml.request.XmlRequestSchema;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.scannotation.AnnotationDB;
import org.scannotation.ClasspathUrlFinder;

public class XmlRequestManager {
    private static final Log log = LogFactory.getLog(XmlRequestManager.class);
    private static Map<String, Class<?>> namespaceMap = new HashMap();
    private static JndiDependencyInjector jndiDependencyInjector = new JndiDependencyInjector();

    public static void main(String[] args) {
        XmlRequestManager xrm = new XmlRequestManager();
        String xml = xrm.handleRequest("http://proveo.de/xml/fleet-management/statemodel-layer-mapping-1.0", null);
        System.out.println(xml);
    }

    private static void findXmlRequestHandlers() {
        try {
            URL url = ClasspathUrlFinder.findClassBase(XmlRequestManager.class);
            AnnotationDB db = new AnnotationDB();
            db.setScanFieldAnnotations(false);
            db.setScanMethodAnnotations(false);
            db.setScanParameterAnnotations(false);
            db.scanArchives(new URL[]{url});
            Map annotationIndex = db.getAnnotationIndex();
            Set requestHandlerClasses = (Set)annotationIndex.get(XmlRequestSchema.class.getName());
            for (String className : requestHandlerClasses) {
                Class<?> type = Class.forName(className);
                XmlRequestSchema xmlRequestSchema = type.getAnnotation(XmlRequestSchema.class);
                for (String namespace : xmlRequestSchema.value()) {
                    namespaceMap.put(namespace, type);
                }
            }
        }
        catch (Exception e) {
            log.error((Object)"Runs into", (Throwable)e);
        }
    }

    public String handleRequest(String schemaNamespace, Map<String, String> parameters) {
        Class<?> type = namespaceMap.get(schemaNamespace);
        if (type == null) {
            log.error((Object)("No XML request handler found for namespace " + schemaNamespace));
            return null;
        }
        String xml = null;
        try {
            XmlRequestHandlerBase requestHandler = (XmlRequestHandlerBase)type.newInstance();
            jndiDependencyInjector.inject((Object)requestHandler);
            Object result = requestHandler.handleRequest(schemaNamespace, parameters);
            if (result != null) {
                xml = this.serialize(result);
            }
        }
        catch (Exception e) {
            log.error((Object)"Runs into", (Throwable)e);
        }
        return xml;
    }

    private String serialize(Object classInstance) throws JAXBException {
        StringWriter stringWriter = new StringWriter();
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{classInstance.getClass()});
        Marshaller marshaller = context.createMarshaller();
        marshaller.marshal(classInstance, (Writer)stringWriter);
        return stringWriter.toString();
    }

    static {
        XmlRequestManager.findXmlRequestHandlers();
    }
}

