/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.web.historyData.dto;

import de.proveo.wwt.logic.web.common.dto.DTOBase;
import de.proveo.wwt.logic.web.historyData.dto.FlightDTO;
import java.util.ArrayList;

public class FlightRotationDTO
extends DTOBase {
    ArrayList<FlightDTO> rotation;
    private FlightDTO arrival = null;
    private FlightDTO departure = null;
    private Long rotationStart = null;
    private Long rotationEnd = null;
    public String arrivalFlno;
    public String departureFlno;
    private Long arrivalBestPlanningTime = null;
    private Long departureBestPlanningTime = null;
    private String arrivalUrno;
    private String departureUrno;
    private String rotationKey;

    public FlightRotationDTO(ArrayList<FlightDTO> rotation) {
        this.setRotation(rotation);
        for (int i = 0; i < rotation.size(); ++i) {
            FlightDTO value = rotation.get(i);
            if (value.getAdid().equals("A")) {
                this.setArrival(value);
                continue;
            }
            this.setDeparture(value);
        }
    }

    public Long getArrivalBestPlanningTime() {
        if (this.arrival != null) {
            this.arrivalBestPlanningTime = this.arrival.getBestPlanningTime();
            return this.arrivalBestPlanningTime;
        }
        return null;
    }

    public Long getDepartureBestPlanningTime() {
        if (this.departure != null) {
            this.departureBestPlanningTime = this.departure.getBestPlanningTime();
            return this.departureBestPlanningTime;
        }
        return null;
    }

    public String getArrivalFlno() {
        if (this.arrival != null) {
            return this.arrival.getFlno();
        }
        return "";
    }

    public String getDepartureFlno() {
        if (this.departure != null) {
            return this.departure.getFlno();
        }
        return "";
    }

    public Long getArrivalStart() {
        Long arrivalStart = null;
        if (this.arrival != null) {
            arrivalStart = this.arrival.getGseSetupStart();
        }
        return arrivalStart;
    }

    public Long getArrivalEnd() {
        Long arrivalEnd = null;
        if (this.arrival != null) {
            arrivalEnd = this.arrival.getGseSetupEnd();
        }
        return arrivalEnd;
    }

    public Long getDepartureStart() {
        Long departureStart = null;
        if (this.departure != null) {
            departureStart = this.departure.getGseSetupStart();
        }
        return departureStart;
    }

    public Long getDepartureEnd() {
        Long departureEnd = null;
        if (this.departure != null) {
            departureEnd = this.departure.getGseSetupEnd();
        }
        return departureEnd;
    }

    public Long getRotationStart() {
        this.rotationStart = this.getArrivalStart();
        if (this.rotationStart == null) {
            this.rotationStart = this.getDepartureStart();
        }
        return this.rotationStart;
    }

    public Long getRotationEnd() {
        this.rotationEnd = this.getDepartureEnd();
        if (this.rotationEnd == null) {
            this.rotationEnd = this.getArrivalEnd();
        }
        return this.rotationEnd;
    }

    public FlightDTO getArrival() {
        return this.arrival;
    }

    public void setArrival(FlightDTO arrival) {
        this.arrival = arrival;
    }

    public FlightDTO getDeparture() {
        return this.departure;
    }

    public void setDeparture(FlightDTO departure) {
        this.departure = departure;
    }

    public String getArrivalUrno() {
        if (this.arrival != null) {
            this.arrivalUrno = this.arrival.getUrno();
            return this.arrivalUrno;
        }
        return "";
    }

    public String getDepartureUrno() {
        if (this.departure != null) {
            this.departureUrno = this.departure.getUrno();
            return this.departureUrno;
        }
        return "";
    }

    public ArrayList<FlightDTO> getRotation() {
        return this.rotation;
    }

    public void setRotation(ArrayList<FlightDTO> rotation) {
        this.rotation = rotation;
    }

    public String getRotationKey() {
        if (this.arrival != null) {
            if (this.arrival.getRkey().equals("")) {
                return this.arrival.getFlno();
            }
            return this.arrival.getRkey();
        }
        if (this.departure != null) {
            if (this.departure.getRkey().equals("")) {
                return this.departure.getFlno();
            }
            return this.departure.getRkey();
        }
        return "";
    }

    public void setRotationKey(String rotationKey) {
        this.rotationKey = rotationKey;
    }
}

