/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.web.hierarchicalData.unitTree;

import de.proveo.ejb.annotations.tags.Business;
import de.proveo.ejb.annotations.tags.JndiLocalBinding;
import de.proveo.ejb.annotations.tags.JndiRemoteBinding;
import de.proveo.wwt.logic.app.util.Stopwatch;
import de.proveo.wwt.logic.web.data.fastlanereader.UnitTreeFastLaneReader;
import de.proveo.wwt.logic.web.hierarchicalData.unitTree.UnitTreeFacadeLocal;
import de.proveo.wwt.logic.web.hierarchicalData.unitTree.UnitTreeFacadeRemote;
import de.proveo.wwt.logic.web.hierarchicalData.unitTree.dto.UnitTreeNode;
import de.proveo.wwt.logic.web.security.PermissionCheckerLocal;
import java.util.HashSet;
import java.util.Set;
import javax.ejb.EJB;
import javax.ejb.Local;
import javax.ejb.Remote;
import javax.ejb.Stateless;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@Stateless(name="UnitTreeFacade")
@Remote(value={UnitTreeFacadeRemote.class})
@Local(value={UnitTreeFacadeLocal.class})
@JndiLocalBinding(localJndiBinding="rts/UnitTreeFacade")
@JndiRemoteBinding(remoteJndiBinding="rts/UnitTreeFacade")
public class UnitTreeFacadeBean
implements UnitTreeFacadeLocal,
UnitTreeFacadeRemote {
    private static final long serialVersionUID = -1747561574171800108L;
    @EJB
    private PermissionCheckerLocal permissionCheckerLocal = null;
    private static final Log log = LogFactory.getLog(UnitTreeFacadeBean.class);

    @Override
    @Business(viewType="both")
    public UnitTreeNode getTreeViewData(boolean permissionFiltered, boolean airportMapFiltered, boolean withoutDeletedUnits) {
        HashSet<Long> permissions = null;
        if (permissionFiltered) {
            permissions = this.permissionCheckerLocal.getUnitPermissions();
        }
        return this.getTreeViewData(permissions, permissionFiltered, airportMapFiltered, withoutDeletedUnits);
    }

    @Override
    @Business(viewType="both")
    public UnitTreeNode getTreeViewData(Set<Long> unitPermissions, boolean permissionFiltered, boolean airportMapFiltered, boolean withoutDeletedUnits) {
        Stopwatch stopwatch = new Stopwatch(UnitTreeFacadeBean.class, "getUnitTree");
        stopwatch.start("Overall");
        if (log.isDebugEnabled()) {
            log.debug((Object)("getTreeViewData called permissionFiltered:" + permissionFiltered + " airportMapFiltered: " + airportMapFiltered));
        }
        UnitTreeFastLaneReader utflr = new UnitTreeFastLaneReader();
        UnitTreeNode treeRoot = utflr.buildUnitTree(withoutDeletedUnits, airportMapFiltered);
        if (permissionFiltered && treeRoot != null) {
            stopwatch.start("Data filtering");
            treeRoot.removeUnauthorizedUnits(unitPermissions);
            if (treeRoot.getChildren().isEmpty()) {
                treeRoot = null;
            }
            stopwatch.stop("Data filtering", true);
        }
        stopwatch.stop("Overall", true);
        return treeRoot;
    }

    @Override
    @Business(viewType="both")
    public UnitTreeNode getWebTreeModel(boolean filtered, boolean withoutDeletedUnits) {
        return this.getTreeViewData(filtered, false, withoutDeletedUnits);
    }

    @Override
    @Business(viewType="both")
    public UnitTreeNode getICCTreeModel() {
        return this.getTreeViewData(true, false, true);
    }

    @Override
    @Business(viewType="both")
    public UnitTreeNode getAirportMapTreeModel(Set<Long> unitPermissions) {
        return this.getTreeViewData(unitPermissions, true, true, true);
    }

    @Override
    @Business(viewType="both")
    public UnitTreeNode getAirportMapReplayTreeModel(Set<Long> unitPermissions) {
        return this.getTreeViewData(unitPermissions, true, false, false);
    }
}

