/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.web.data.processors.stateCounter.peak;

import de.proveo.wwt.datamodel.stateModel.State;
import de.proveo.wwt.logic.web.common.dataSelection.ReportSelectionDTO;
import de.proveo.wwt.logic.web.common.dto.DTOFactory;
import de.proveo.wwt.logic.web.common.dto.UnitDTO;
import de.proveo.wwt.logic.web.data.processors.stateCounter.StateCountSnapshot;
import de.proveo.wwt.logic.web.data.processors.stateCounter.StateCounterEvaluatorBase;
import de.proveo.wwt.logic.web.summarizedData.dto.statusPeak.StatusPeakDTO;
import de.proveo.wwt.logic.web.summarizedData.dto.statusPeak.StatusPeaksDTOList;
import de.proveo.wwt.logic.web.summarizedData.dto.statusPeak.StatusPeaksDTOMap;
import java.util.ArrayList;
import java.util.HashMap;

public abstract class PeakStatusEvaluatorBase
extends StateCounterEvaluatorBase {
    protected ReportSelectionDTO selectionDTO;
    protected long interval;
    protected HashMap<Integer, StateCountSnapshot[]> snapshotMap;
    protected int intervalCount = 0;
    protected int unitCount = 0;

    public PeakStatusEvaluatorBase(ReportSelectionDTO selectionDTO, int interval) {
        this.selectionDTO = selectionDTO;
        this.interval = (long)interval * 60000L;
    }

    @Override
    public void preProcess() {
        this.snapshotMap = new HashMap(this.availableStates.size());
        this.intervalCount = (int)Math.ceil((double)(this.getEndTime() - this.getBeginTime()) / (double)this.interval);
        for (State state : this.availableStates) {
            StateCountSnapshot[] snapshots = new StateCountSnapshot[this.intervalCount];
            for (int i = 0; i != this.intervalCount; ++i) {
                StateCountSnapshot snapshot = new StateCountSnapshot();
                snapshot.stateModelId = state.getStateModelId();
                snapshot.stateId = state.getId();
                snapshot.count = 0;
                snapshots[i] = snapshot;
            }
            this.snapshotMap.put(state.getId(), snapshots);
        }
    }

    @Override
    public void postProcess(int unitCount) {
        this.unitCount = unitCount;
    }

    public StatusPeaksDTOList evaluate() {
        int[] stateIds = new int[this.availableStates.size()];
        for (int i = 0; i != this.availableStates.size(); ++i) {
            stateIds[i] = ((State)((Object)this.availableStates.get(i))).getId();
        }
        StatusPeaksDTOList peakList = new StatusPeaksDTOList(this.selectionDTO, ((State)((Object)this.availableStates.get(0))).getStateModelId(), String.valueOf(this.interval / 60000L), stateIds, this.unitCount);
        for (int i = 0; i != this.intervalCount; ++i) {
            long intervalBeginTime = this.getBeginTime() + this.interval * (long)i;
            StatusPeaksDTOMap statusPeaksDTOMap = new StatusPeaksDTOMap(intervalBeginTime);
            for (StateCountSnapshot[] snapshots : this.snapshotMap.values()) {
                StateCountSnapshot snapshot = snapshots[i];
                StatusPeakDTO statusPeakDTO = DTOFactory.buildStatusPeakDTO(snapshot.stateModelId, snapshot.stateId, this.interval, intervalBeginTime, intervalBeginTime + this.interval, snapshot.count, new ArrayList<UnitDTO>(snapshot.unitDTOs));
                statusPeaksDTOMap.getPeakMap().put(snapshot.stateId, statusPeakDTO);
            }
            peakList.add(statusPeaksDTOMap);
        }
        return peakList;
    }

    protected int getIntervalIndex(long time) {
        if (time < this.getBeginTime() || time > this.getEndTime()) {
            return -1;
        }
        return (int)((time - this.getBeginTime()) / this.interval);
    }

    private long getBeginTime() {
        return this.selectionDTO.getBeginTime();
    }

    private long getEndTime() {
        return this.selectionDTO.getEndTime();
    }
}

