/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.web.data.processors.stateCounter;

import de.proveo.wwt.datamodel.stateModel.State;
import de.proveo.wwt.logic.ejb.stateModel.StateModelFacadeLocal;
import de.proveo.wwt.logic.web.common.dto.ReportDTOBase;
import de.proveo.wwt.logic.web.common.dto.ReportDTOBaseComparator;
import de.proveo.wwt.logic.web.data.processors.IFastLaneReaderProcessor;
import de.proveo.wwt.logic.web.data.processors.stateCounter.StateCountSnapshot;
import de.proveo.wwt.logic.web.data.processors.stateCounter.StateCountSnapshotReason;
import de.proveo.wwt.logic.web.data.processors.stateCounter.StateCounterEvaluatorBase;
import de.proveo.wwt.logic.web.historyData.dto.StateDTO;
import de.proveo.wwt.logic.web.historyData.dto.StateDTOList;
import de.proveo.wwt.logic.web.security.PermissionChecker;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.naming.InitialContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StateCounterProcessor
implements IFastLaneReaderProcessor<StateDTO> {
    private static final Log log = LogFactory.getLog(StateCounterProcessor.class);
    private StateModelFacadeLocal stateModelFacade;
    private long beginTime;
    private long endTime;
    private long interval;
    private int currentIntervalIndex;
    private StateCounterEvaluatorBase[] evaluators;
    private HashMap<Integer, StateCountSnapshot> counterMap;
    private SortedSet<StateDTO> endTimeSet;
    private int stateModelId;
    private List<StateDTO> statesToProcess;
    private long previousBeginTime = 0L;
    private long currentBeginTime = 0L;
    private PermissionChecker permissionChecker;

    public StateCounterProcessor(StateCounterEvaluatorBase[] evaluators, long beginTime, long endTime, int interval, int stateModelId) {
        this.beginTime = beginTime;
        this.endTime = endTime;
        this.interval = (long)interval * 60000L;
        this.stateModelId = stateModelId;
        this.evaluators = evaluators;
        try {
            InitialContext context = new InitialContext();
            this.stateModelFacade = (StateModelFacadeLocal)context.lookup("rts/StateModelFacade/local");
        }
        catch (Exception e) {
            log.error((Object)"runs into: ", (Throwable)e);
        }
    }

    @Override
    public void preProcess(PermissionChecker permissionChecker) {
        if (this.evaluators == null || this.evaluators.length == 0) {
            return;
        }
        this.permissionChecker = permissionChecker;
        this.currentIntervalIndex = 0;
        List<State> availableStates = this.stateModelFacade.getStates(this.stateModelId);
        for (StateCounterEvaluatorBase evaluator : this.evaluators) {
            evaluator.setAvailableStates(availableStates);
            evaluator.preProcess();
        }
        this.counterMap = new HashMap();
        this.endTimeSet = new TreeSet<ReportDTOBase>(new ReportDTOBaseComparator(ReportDTOBaseComparator.CompareType.END_TIME, ReportDTOBaseComparator.CompareType.UNIT_ID));
        for (State state : availableStates) {
            StateCountSnapshot snapshot = new StateCountSnapshot();
            snapshot.stateId = state.getId();
            snapshot.stateModelId = state.getStateModelId();
            this.counterMap.put(state.getId(), snapshot);
        }
        this.statesToProcess = new ArrayList<StateDTO>();
    }

    @Override
    public void process(StateDTO stateDTO) {
        this.currentBeginTime = stateDTO.getBeginTime();
        if (this.previousBeginTime == 0L) {
            this.previousBeginTime = this.currentBeginTime;
        }
        if (this.currentBeginTime == this.previousBeginTime) {
            this.statesToProcess.add(stateDTO);
            return;
        }
        this.handleStates(this.previousBeginTime);
        this.previousBeginTime = this.currentBeginTime;
        this.statesToProcess.add(stateDTO);
    }

    @Override
    public void postProcess() {
        this.handleStates(this.currentBeginTime);
        this.updateCurrentIntervalIndex(this.endTime);
        for (StateCounterEvaluatorBase evaluator : this.evaluators) {
            evaluator.postProcess(this.permissionChecker.getInvolvedUnitIds().size());
        }
    }

    private void handleStates(long beginTime) {
        List<StateDTO> endingStateList = this.getForemostEndingStateDTOs(this.endTimeSet, beginTime);
        this.updateCurrentIntervalIndex(beginTime);
        if (endingStateList.size() != 0) {
            this.handleEndingStates(endingStateList);
        }
        this.handleBeginningStates(this.statesToProcess);
    }

    public void process(StateDTOList stateDTOList, PermissionChecker permissionChecker) {
        if (stateDTOList == null) {
            return;
        }
        this.preProcess(permissionChecker);
        if (stateDTOList.size() == 0) {
            return;
        }
        Collections.sort(stateDTOList, new ReportDTOBaseComparator(ReportDTOBaseComparator.CompareType.BEGIN_TIME));
        this.processStates(stateDTOList);
        this.postProcess();
    }

    private void processStates(StateDTOList stateDTOList) {
        for (StateDTO stateDTO : stateDTOList) {
            this.process(stateDTO);
        }
    }

    private void handleBeginningStates(List<StateDTO> beginningStateList) {
        for (StateDTO stateDTO : beginningStateList) {
            StateCountSnapshot snapshot = this.counterMap.get(stateDTO.getStateId());
            if (snapshot.unitDTOs.add(stateDTO.getUnit())) {
                ++snapshot.count;
            }
            this.endTimeSet.add(stateDTO);
        }
        if (beginningStateList.size() != 0) {
            this.passSnapshot(beginningStateList.get(0).getBeginTime(), StateCountSnapshotReason.STATE_BEGIN);
            beginningStateList.clear();
        }
    }

    private void handleEndingStates(List<StateDTO> endingStateList) {
        for (StateDTO stateDTO : endingStateList) {
            StateCountSnapshot currentSnapshot = this.counterMap.get(stateDTO.getStateId());
            if (currentSnapshot.unitDTOs.remove(stateDTO.getUnit())) {
                --currentSnapshot.count;
            }
            this.endTimeSet.remove(stateDTO);
        }
        endingStateList.clear();
    }

    private void updateCurrentIntervalIndex(long time) {
        int newIndex = this.getIntervalIndex(time);
        if (newIndex == this.currentIntervalIndex) {
            return;
        }
        if (newIndex >= this.currentIntervalIndex + 1) {
            for (int i = this.currentIntervalIndex + 1; i <= newIndex; ++i) {
                List<StateDTO> endingStateList = this.getForemostEndingStateDTOs(this.endTimeSet, this.beginTime + this.interval * (long)i);
                if (endingStateList.size() != 0) {
                    this.handleEndingStates(endingStateList);
                }
                this.passSnapshot(this.beginTime + this.interval * (long)i, StateCountSnapshotReason.INTERVAL_BOUNDARY);
            }
            this.currentIntervalIndex = newIndex;
        }
    }

    protected void passSnapshot(long time, StateCountSnapshotReason reason) {
        Collection<StateCountSnapshot> snapshotCollection = this.counterMap.values();
        for (StateCountSnapshot currentSnapshot : snapshotCollection) {
            currentSnapshot.time = time;
        }
        for (StateCounterEvaluatorBase evaluator : this.evaluators) {
            evaluator.processSnapshot(snapshotCollection, reason);
        }
    }

    protected List<StateDTO> getForemostEndingStateDTOs(SortedSet<StateDTO> endingStates, long beginTime) {
        StateDTO endingState;
        ArrayList<StateDTO> foremostEndingStates = new ArrayList<StateDTO>();
        Iterator i$ = endingStates.iterator();
        while (i$.hasNext() && (endingState = (StateDTO)i$.next()).getEndTime() <= beginTime) {
            foremostEndingStates.add(endingState);
        }
        return foremostEndingStates;
    }

    protected int getIntervalIndex(long time) {
        if (time < this.beginTime || time > this.endTime) {
            return -1;
        }
        return (int)((time - this.beginTime) / this.interval);
    }
}

