/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.web.data.fastlanereader.report;

import com.healthmarketscience.sqlbuilder.BinaryCondition;
import com.healthmarketscience.sqlbuilder.Condition;
import com.healthmarketscience.sqlbuilder.dbspec.Column;
import de.proveo.wwt.datamodel.area.Area;
import de.proveo.wwt.logic.app.util.Stopwatch;
import de.proveo.wwt.logic.ejb.dataOut.raw.StateStamp;
import de.proveo.wwt.logic.web.common.dataSelection.ReportSelectionDTO;
import de.proveo.wwt.logic.web.common.dto.DTOFactory;
import de.proveo.wwt.logic.web.common.dto.DTOListBase;
import de.proveo.wwt.logic.web.common.dto.DTOListFactory;
import de.proveo.wwt.logic.web.common.dto.UnitDTO;
import de.proveo.wwt.logic.web.data.enumerations.ExtendedDTOData;
import de.proveo.wwt.logic.web.data.enumerations.FastLaneReaderOrder;
import de.proveo.wwt.logic.web.data.fastlanereader.base.FastLaneReader;
import de.proveo.wwt.logic.web.data.fastlanereader.report.StateReportFastLaneReader;
import de.proveo.wwt.logic.web.data.processors.IFastLaneReaderProcessor;
import de.proveo.wwt.logic.web.data.query.definitions.StateDefinitions;
import de.proveo.wwt.logic.web.historyData.dto.StateDTO;
import de.proveo.wwt.logic.web.security.PermissionChecker;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;

public class StateFastLaneReader
extends StateReportFastLaneReader<StateDTO, StateDefinitions> {
    protected Integer stateModelId;
    protected Integer stateFilterId;

    public StateFastLaneReader() {
        super(new StateDefinitions());
    }

    public void getHistory(DTOListBase<StateDTO> list, Long unitId, Integer stateModelId, Integer stateFilterId, long beginTime, long endTime, boolean useGroupHistory, FastLaneReaderOrder order, ExtendedDTOData ... extendedData) {
        ReportSelectionDTO selectionDTO = this.buildUnitReportSelectionDTO(unitId, beginTime, endTime, useGroupHistory, true);
        this.init(stateModelId, stateFilterId, list, selectionDTO, order, extendedData);
        String sql = this.generateSql(false);
        this.getData(sql, false);
    }

    public void getHistory(DTOListBase<StateDTO> list, ReportSelectionDTO selectionDTO, Integer stateModelId, Integer stateFilterId, FastLaneReaderOrder order, ExtendedDTOData ... extendedData) {
        this.init(stateModelId, stateFilterId, list, selectionDTO, order, extendedData);
        String sql = this.generateSql(false);
        this.getData(sql, false);
    }

    public void getCache(DTOListBase<StateDTO> list, ReportSelectionDTO selectionDTO, Integer stateModelId, Integer stateFilterId, ExtendedDTOData ... extendedData) {
        this.init(stateModelId, stateFilterId, list, selectionDTO, FastLaneReaderOrder.ByUnitId, extendedData);
        String sql = this.generateSql(true);
        this.getData(sql, true);
    }

    public void getCache(DTOListBase<StateDTO> list, Long unitId, Integer stateModelId, Integer stateFilterId, ExtendedDTOData ... extendedData) {
        ReportSelectionDTO selectionDTO = this.buildUnitReportSelectionDTO(unitId, 0L, 0L, true, false);
        this.init(stateModelId, stateFilterId, list, selectionDTO, FastLaneReaderOrder.ByUnitId, extendedData);
        String sql = this.generateSql(true);
        this.getData(sql, true);
    }

    public void processStateHistory(PermissionChecker permissionChecker, IFastLaneReaderProcessor<StateDTO> processor, ReportSelectionDTO selectionDTO, Integer stateModelId, Integer stateFilterId, FastLaneReaderOrder order, ExtendedDTOData ... extendedData) {
        DTOListBase<StateDTO> list = DTOListFactory.buildDTOListBase(selectionDTO);
        this.init(stateModelId, stateFilterId, list, selectionDTO, order, extendedData);
        String sql = this.generateSql(false);
        this.processStateHistoryData(permissionChecker, processor, sql);
    }

    private void processStateHistoryData(PermissionChecker permissionChecker, IFastLaneReaderProcessor<StateDTO> processor, String sql) {
        this.getData(sql, false);
        permissionChecker.initialize(this.getUnitDTOMap());
        processor.preProcess(permissionChecker);
        for (StateDTO dto : this.dataList) {
            if (!permissionChecker.checkPermission(dto.getUnitId())) continue;
            processor.process(dto);
        }
        processor.postProcess();
    }

    @Override
    protected int getHistory(ResultSet resultSet) throws SQLException {
        int dataSize = 0;
        int idx_id = resultSet.findColumn(((StateDefinitions)this.getDefinitions()).getHelperHistoryIdColumn().getName());
        int idx_unitId = resultSet.findColumn(((StateDefinitions)this.getDefinitions()).getHelperUnitIdColumn().getName());
        int idx_beginTime = resultSet.findColumn("bt");
        int idx_endTime = resultSet.findColumn("et");
        int idx_beginReceiveTime = resultSet.findColumn(((StateDefinitions)this.getDefinitions()).getHistoryBeginReceiveTimeColumn().getName());
        int idx_endReceiveTime = resultSet.findColumn(((StateDefinitions)this.getDefinitions()).getHistoryEndReceiveTimeColumn().getName());
        int idx_actualBeginTime = resultSet.findColumn(((StateDefinitions)this.getDefinitions()).getHistoryBeginTimeColumn().getName());
        int idx_actualEndTime = resultSet.findColumn(((StateDefinitions)this.getDefinitions()).getHistoryEndTimeColumn().getName());
        StateDefinitions cfr_ignored_0 = (StateDefinitions)this.getDefinitions();
        int idx_areaId = resultSet.findColumn(StateDefinitions.col_History_AreaId.getName());
        StateDefinitions cfr_ignored_1 = (StateDefinitions)this.getDefinitions();
        int idx_areaTrusted = resultSet.findColumn(StateDefinitions.col_History_AreaTrusted.getName());
        StateDefinitions cfr_ignored_2 = (StateDefinitions)this.getDefinitions();
        int idx_stateId = resultSet.findColumn(StateDefinitions.col_History_StateId.getName());
        StateDefinitions cfr_ignored_3 = (StateDefinitions)this.getDefinitions();
        int idx_stateModelId = resultSet.findColumn(StateDefinitions.col_History_StateModelId.getName());
        StateDefinitions cfr_ignored_4 = (StateDefinitions)this.getDefinitions();
        int idx_remark = resultSet.findColumn(StateDefinitions.col_History_Remark.getName());
        while (resultSet.next()) {
            long id = resultSet.getLong(idx_id);
            long unitId = resultSet.getLong(idx_unitId);
            int stateId = resultSet.getInt(idx_stateId);
            int stateModelId = resultSet.getInt(idx_stateModelId);
            String remark = resultSet.getString(idx_remark);
            long beginReceiveTime = resultSet.getLong(idx_beginReceiveTime);
            long endReceiveTime = resultSet.getLong(idx_endReceiveTime);
            long beginTime = resultSet.getLong(idx_beginTime);
            long endTime = resultSet.getLong(idx_endTime);
            long actualBeginTime = resultSet.getLong(idx_actualBeginTime);
            long actualEndTime = resultSet.getLong(idx_actualEndTime);
            UnitDTO unitDTO = this.getUnitDTOMap().get(unitId);
            Area area = null;
            boolean areaTrusted = false;
            if (this.extendedData.contains((Object)ExtendedDTOData.AREA)) {
                area = this.getAreaMap().get(resultSet.getInt(idx_areaId));
                areaTrusted = resultSet.getBoolean(idx_areaTrusted);
            }
            StateDTO dto = DTOFactory.buildStateDTO(id, beginTime, endTime, beginReceiveTime, endReceiveTime, actualBeginTime, actualEndTime, stateId, stateModelId, 0, remark, area, null, areaTrusted, false, unitDTO);
            this.addExtendedData(false, resultSet, dto, ExtendedDTOData.AREA);
            this.dataList.add(dto);
            ++dataSize;
        }
        return dataSize;
    }

    @Override
    protected int getCache(ResultSet resultSet) throws SQLException {
        int dataSize = 0;
        int idx_id = resultSet.findColumn(((StateDefinitions)this.getDefinitions()).getCacheHistoryIdColumn().getName());
        int idx_unitId = resultSet.findColumn(((StateDefinitions)this.getDefinitions()).getCacheUnitIdColumn().getName());
        int idx_beginTime = resultSet.findColumn("bt");
        int idx_beginReceiveTime = resultSet.findColumn(((StateDefinitions)this.getDefinitions()).getCacheBeginReceiveTimeColumn().getName());
        int idx_actualBeginTime = resultSet.findColumn(((StateDefinitions)this.getDefinitions()).getCacheBeginTimeColumn().getName());
        StateDefinitions cfr_ignored_0 = (StateDefinitions)this.getDefinitions();
        int idx_areaId = resultSet.findColumn(StateDefinitions.col_Cache_AreaId.getName());
        StateDefinitions cfr_ignored_1 = (StateDefinitions)this.getDefinitions();
        int idx_areaTrusted = resultSet.findColumn(StateDefinitions.col_Cache_AreaTrusted.getName());
        StateDefinitions cfr_ignored_2 = (StateDefinitions)this.getDefinitions();
        int idx_stateId = resultSet.findColumn(StateDefinitions.col_Cache_StateId.getName());
        StateDefinitions cfr_ignored_3 = (StateDefinitions)this.getDefinitions();
        int idx_stateModelId = resultSet.findColumn(StateDefinitions.col_Cache_StateModelId.getName());
        StateDefinitions cfr_ignored_4 = (StateDefinitions)this.getDefinitions();
        int idx_remark = resultSet.findColumn(StateDefinitions.col_Cache_Remark.getName());
        while (resultSet.next()) {
            long id = resultSet.getLong(idx_id);
            long unitId = resultSet.getLong(idx_unitId);
            int stateId = resultSet.getInt(idx_stateId);
            int stateModelId = resultSet.getInt(idx_stateModelId);
            String remark = resultSet.getString(idx_remark);
            long beginReceiveTime = resultSet.getLong(idx_beginReceiveTime);
            long endReceiveTime = 0L;
            long beginTime = resultSet.getLong(idx_beginTime);
            long endTime = 0L;
            long actualBeginTime = resultSet.getLong(idx_actualBeginTime);
            long actualEndTime = 0L;
            UnitDTO unitDTO = this.getUnitDTOMap().get(unitId);
            if (unitDTO.isDeleted()) continue;
            Area area = null;
            boolean areaTrusted = false;
            if (this.extendedData.contains((Object)ExtendedDTOData.AREA)) {
                area = this.getAreaMap().get(resultSet.getInt(idx_areaId));
                areaTrusted = resultSet.getBoolean(idx_areaTrusted);
            }
            StateDTO dto = DTOFactory.buildStateDTO(id, beginTime, endTime, beginReceiveTime, endReceiveTime, actualBeginTime, actualEndTime, stateId, stateModelId, 0, remark, area, null, areaTrusted, false, unitDTO);
            this.addExtendedData(true, resultSet, dto, ExtendedDTOData.AREA);
            this.dataList.add(dto);
            ++dataSize;
        }
        return dataSize;
    }

    public HashSet<StateStamp> getRawStateHistory(Long unitId, Integer stateModelId, Integer stateFilterId, long beginTime, long endTime, boolean useGroupHistory, ExtendedDTOData ... extendedData) {
        ReportSelectionDTO selectionDTO = this.buildUnitReportSelectionDTO(unitId, beginTime, endTime, useGroupHistory, true);
        DTOListBase<StateDTO> list = DTOListFactory.buildDTOListBase(selectionDTO);
        this.init(stateModelId, stateFilterId, list, selectionDTO, FastLaneReaderOrder.ByNothing, extendedData);
        String sql = this.generateSql(false);
        return this.getRawStateHistory(sql);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HashSet<StateStamp> getRawStateHistory(String sql) {
        log.debug((Object)"stateHistoryFastLaneRead called");
        Stopwatch stopwatch = new Stopwatch(FastLaneReader.class, "stateHistoryFastLaneRead");
        stopwatch.start("Overall");
        Connection connection = null;
        Statement statement = null;
        HashSet<StateStamp> stateStamps = new HashSet<StateStamp>();
        try {
            stopwatch.start("Database access");
            connection = this.getConnection();
            statement = this.createReadOnlyForwardOnlyStatement(connection);
            log.debug((Object)("executed SQL: " + sql));
            ResultSet resultSet = statement.executeQuery(sql);
            int dataSize = 0;
            stopwatch.stop("Database access", true);
            stopwatch.start("Build DTO");
            while (resultSet.next()) {
                Integer stateIdNext = null;
                int stateId = resultSet.getInt(StateDefinitions.col_History_StateId.getName());
                int stateModelId = resultSet.getInt(StateDefinitions.col_History_StateModelId.getName());
                long shBeginTime = resultSet.getLong("bt");
                long beginReceiveTime = resultSet.getLong(StateDefinitions.col_History_BeginReceiveTime.getName());
                long shEndTime = resultSet.getLong("et");
                long endReceiveTime = resultSet.getLong(StateDefinitions.col_History_EndReceiveTime.getName());
                String remark = resultSet.getString(StateDefinitions.col_History_Remark.getName());
                StateStamp stateStamp = new StateStamp(stateModelId, stateId, shBeginTime, shEndTime, shEndTime - shBeginTime, beginReceiveTime, endReceiveTime, beginReceiveTime - shBeginTime, endReceiveTime - shEndTime, stateIdNext, remark);
                stateStamps.add(stateStamp);
                ++dataSize;
            }
            stopwatch.stop("Build DTO", true, dataSize);
        }
        catch (SQLException e) {
            log.error((Object)"runs into: ", (Throwable)e);
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException e) {
                log.error((Object)"runs into: ", (Throwable)e);
            }
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException e) {
                log.error((Object)"runs into: ", (Throwable)e);
            }
        }
        stopwatch.stop("Overall", true);
        return stateStamps;
    }

    @Override
    protected void prepareHistoryColumns() {
        super.prepareHistoryColumns();
        Column[] columnArray = new Column[3];
        StateDefinitions cfr_ignored_0 = (StateDefinitions)this.getDefinitions();
        columnArray[0] = StateDefinitions.col_History_StateModelId;
        StateDefinitions cfr_ignored_1 = (StateDefinitions)this.getDefinitions();
        columnArray[1] = StateDefinitions.col_History_StateId;
        StateDefinitions cfr_ignored_2 = (StateDefinitions)this.getDefinitions();
        columnArray[2] = StateDefinitions.col_History_Remark;
        this.historyQuery.addColumns(columnArray);
        if (!this.extendedData.contains((Object)ExtendedDTOData.AREA)) {
            Column[] columnArray2 = new Column[2];
            StateDefinitions cfr_ignored_3 = (StateDefinitions)this.getDefinitions();
            columnArray2[0] = StateDefinitions.col_History_AreaId;
            StateDefinitions cfr_ignored_4 = (StateDefinitions)this.getDefinitions();
            columnArray2[1] = StateDefinitions.col_History_AreaTrusted;
            this.historyQuery.addColumns(columnArray2);
        }
    }

    @Override
    protected void prepareCacheColumns() {
        super.prepareCacheColumns();
        Column[] columnArray = new Column[3];
        StateDefinitions cfr_ignored_0 = (StateDefinitions)this.getDefinitions();
        columnArray[0] = StateDefinitions.col_Cache_StateModelId;
        StateDefinitions cfr_ignored_1 = (StateDefinitions)this.getDefinitions();
        columnArray[1] = StateDefinitions.col_Cache_StateId;
        StateDefinitions cfr_ignored_2 = (StateDefinitions)this.getDefinitions();
        columnArray[2] = StateDefinitions.col_Cache_Remark;
        this.cacheQuery.addColumns(columnArray);
        if (!this.extendedData.contains((Object)ExtendedDTOData.AREA)) {
            Column[] columnArray2 = new Column[2];
            StateDefinitions cfr_ignored_3 = (StateDefinitions)this.getDefinitions();
            columnArray2[0] = StateDefinitions.col_Cache_AreaId;
            StateDefinitions cfr_ignored_4 = (StateDefinitions)this.getDefinitions();
            columnArray2[1] = StateDefinitions.col_Cache_AreaTrusted;
            this.cacheQuery.addColumns(columnArray2);
        }
    }

    @Override
    protected void addCustomConditions() {
        if (this.stateModelId != null) {
            StateDefinitions cfr_ignored_0 = (StateDefinitions)this.getDefinitions();
            this.historyQuery.addCondition((Condition)new BinaryCondition(BinaryCondition.Op.EQUAL_TO, (Object)StateDefinitions.col_History_StateModelId, (Object)this.stateModelId));
            StateDefinitions cfr_ignored_1 = (StateDefinitions)this.getDefinitions();
            this.cacheQuery.addCondition((Condition)new BinaryCondition(BinaryCondition.Op.EQUAL_TO, (Object)StateDefinitions.col_Cache_StateModelId, (Object)this.stateModelId));
        }
        if (this.stateFilterId != null) {
            StateDefinitions cfr_ignored_2 = (StateDefinitions)this.getDefinitions();
            this.historyQuery.addCondition((Condition)new BinaryCondition(BinaryCondition.Op.EQUAL_TO, (Object)StateDefinitions.col_History_StateId, (Object)this.stateFilterId));
            StateDefinitions cfr_ignored_3 = (StateDefinitions)this.getDefinitions();
            this.cacheQuery.addCondition((Condition)new BinaryCondition(BinaryCondition.Op.EQUAL_TO, (Object)StateDefinitions.col_Cache_StateId, (Object)this.stateFilterId));
        }
    }

    protected void init(Integer stateModelId, Integer stateFilterId, DTOListBase<StateDTO> dataList, ReportSelectionDTO selectionDTO, FastLaneReaderOrder order, ExtendedDTOData ... extendedData) {
        super.init(dataList, selectionDTO, order, extendedData);
        this.stateFilterId = stateFilterId;
        this.stateModelId = stateModelId;
    }
}

