/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.web.data.fastlanereader.report;

import com.healthmarketscience.sqlbuilder.BinaryCondition;
import com.healthmarketscience.sqlbuilder.ComboCondition;
import com.healthmarketscience.sqlbuilder.Condition;
import com.healthmarketscience.sqlbuilder.InCondition;
import com.healthmarketscience.sqlbuilder.SelectQuery;
import com.healthmarketscience.sqlbuilder.dbspec.Column;
import com.healthmarketscience.sqlbuilder.dbspec.Table;
import com.healthmarketscience.sqlbuilder.dbspec.basic.DbColumn;
import de.proveo.util.container.ContainerUtil;
import de.proveo.wwt.datamodel.area.Area;
import de.proveo.wwt.datamodel.use.user.UseUser;
import de.proveo.wwt.logic.ejb.interfaces.fis.report.dto.FISReportDTO;
import de.proveo.wwt.logic.web.common.dataSelection.ReportSelectionDTO;
import de.proveo.wwt.logic.web.common.dataSelection.filter.IDataFilter;
import de.proveo.wwt.logic.web.common.dto.DTOFactory;
import de.proveo.wwt.logic.web.common.dto.DTOListBase;
import de.proveo.wwt.logic.web.common.dto.ReportDTOBase;
import de.proveo.wwt.logic.web.common.dto.UnitDTO;
import de.proveo.wwt.logic.web.data.enumerations.ExtendedDTOData;
import de.proveo.wwt.logic.web.data.enumerations.FastLaneReaderOrder;
import de.proveo.wwt.logic.web.data.fastlanereader.report.ReportFastLaneReader;
import de.proveo.wwt.logic.web.data.query.definitions.CustomRejoinTable;
import de.proveo.wwt.logic.web.data.query.definitions.FISDefinitions;
import de.proveo.wwt.logic.web.data.query.definitions.GdataDefinitions;
import de.proveo.wwt.logic.web.data.query.interfaces.IAreaTable;
import de.proveo.wwt.logic.web.data.query.interfaces.IOperatorTable;
import de.proveo.wwt.logic.web.data.query.interfaces.IPositionTable;
import de.proveo.wwt.logic.web.data.query.interfaces.IReportTableDefinitions;
import de.proveo.wwt.logic.web.historyData.dto.PositionDTO;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class ExtendedReportFastLaneReader<T extends ReportDTOBase, D extends IReportTableDefinitions>
extends ReportFastLaneReader<T, D> {
    protected List<ExtendedDTOData> extendedData = new ArrayList<ExtendedDTOData>();

    protected ExtendedReportFastLaneReader(D definitions) {
        super(definitions);
    }

    protected void init(DTOListBase<T> dataList, ReportSelectionDTO selectionDTO, FastLaneReaderOrder order, ExtendedDTOData ... extendedData) {
        super.init(dataList, selectionDTO, order);
        if (extendedData != null) {
            Collections.addAll(this.extendedData, extendedData);
        }
    }

    @Override
    protected void addCustomConditions() {
        for (IDataFilter filter : this.selectionDTO.getDataFilters()) {
            Type flrType;
            Type filterType = ((ParameterizedType)filter.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
            if (!filterType.equals(flrType = ((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0])) continue;
            this.historyQuery.addCondition((Condition)new InCondition((Object)filter.getHistoryColumn(), filter.getObjects()));
            this.cacheQuery.addCondition((Condition)new InCondition((Object)filter.getCacheColumn(), filter.getObjects()));
        }
    }

    @Override
    protected void addExtendedDataColumns() {
        Object definitions;
        if (this.getDefinitions() instanceof IOperatorTable && this.extendedData.contains((Object)ExtendedDTOData.OPERATOR)) {
            definitions = (IOperatorTable)this.getDefinitions();
            this.historyQuery.addColumns(new Column[]{definitions.getHistoryUseUserIdColumn()});
            this.cacheQuery.addColumns(new Column[]{definitions.getCacheUseUserIdColumn()});
        }
        if (this.getDefinitions() instanceof IAreaTable) {
            definitions = (IAreaTable)this.getDefinitions();
            if (this.extendedData.contains((Object)ExtendedDTOData.AREA)) {
                this.historyQuery.addColumns(new Column[]{definitions.getHistoryAreaIdColumn(), definitions.getHistoryAreaTrustedColumn()});
                this.cacheQuery.addColumns(new Column[]{definitions.getCacheAreaIdColumn(), definitions.getCacheAreaTrustedColumn()});
            }
            if (this.extendedData.contains((Object)ExtendedDTOData.FIS)) {
                this.addFISConditions();
            }
        }
        if (this.getDefinitions() instanceof IPositionTable && this.extendedData.contains((Object)ExtendedDTOData.GDATA)) {
            definitions = (IPositionTable)this.getDefinitions();
            this.addGdataColumns(this.cacheQuery);
            this.addGdataColumns(this.historyQuery);
            this.cacheQuery.addJoin(SelectQuery.JoinType.LEFT_OUTER, (Table)this.getDefinitions().getCacheTable(), (Table)GdataDefinitions.tbl_History, (Column)definitions.getCacheGdataIdColumn(), (Column)GdataDefinitions.col_History_Id);
            this.historyQuery.addJoin(SelectQuery.JoinType.LEFT_OUTER, (Table)this.getDefinitions().getHistoryTable(), (Table)GdataDefinitions.tbl_History, (Column)definitions.getHistoryGdataIdColumn(), (Column)GdataDefinitions.col_History_Id);
        }
    }

    protected void addExtendedData(boolean cache, ResultSet resultSet, T dto, ExtendedDTOData ... skip) throws SQLException {
        ArrayList skips = new ArrayList();
        Collections.addAll(skips, skip);
        for (ExtendedDTOData data : ContainerUtil.disjunctList(this.extendedData, skips)) {
            switch (data) {
                case OPERATOR: {
                    if (!(this.getDefinitions() instanceof IOperatorTable)) break;
                    DbColumn column = cache ? ((IOperatorTable)this.getDefinitions()).getCacheUseUserIdColumn() : ((IOperatorTable)this.getDefinitions()).getHistoryUseUserIdColumn();
                    UseUser useUser = this.getUseUserMap().get(resultSet.getLong(column.getName()));
                    if (resultSet.wasNull()) {
                        useUser = null;
                    }
                    ((ReportDTOBase)dto).addDTOAttachable(useUser);
                    break;
                }
                case AREA: {
                    if (!(this.getDefinitions() instanceof IAreaTable)) break;
                    DbColumn column = cache ? ((IAreaTable)this.getDefinitions()).getCacheAreaIdColumn() : ((IAreaTable)this.getDefinitions()).getHistoryAreaIdColumn();
                    Area area = this.getAreaMap().get(resultSet.getInt(column.getName()));
                    if (resultSet.wasNull()) {
                        area = null;
                    }
                    ((ReportDTOBase)dto).addDTOAttachable(area);
                    break;
                }
                case FIS: {
                    this.addFISData(dto, resultSet);
                    break;
                }
                case GDATA: {
                    if (!(this.getDefinitions() instanceof IPositionTable)) break;
                    this.addGdataData(dto, resultSet);
                }
            }
        }
    }

    protected void addGdataColumns(SelectQuery query) {
        query.addAliasedColumn((Object)GdataDefinitions.col_History_Id, "gdata_" + GdataDefinitions.col_History_Id.getName());
        query.addAliasedColumn((Object)GdataDefinitions.col_History_UnitId, "gdata_" + GdataDefinitions.col_History_UnitId.getName());
        query.addAliasedColumn((Object)GdataDefinitions.col_History_BeginTime, "gdata_" + GdataDefinitions.col_History_BeginTime.getName());
        query.addAliasedColumn((Object)GdataDefinitions.col_History_EndTime, "gdata_" + GdataDefinitions.col_History_EndTime.getName());
        query.addAliasedColumn((Object)GdataDefinitions.col_History_BeginReceiveTime, "gdata_" + GdataDefinitions.col_History_BeginReceiveTime.getName());
        query.addAliasedColumn((Object)GdataDefinitions.col_History_EndReceiveTime, "gdata_" + GdataDefinitions.col_History_EndReceiveTime.getName());
        query.addAliasedColumn((Object)GdataDefinitions.col_History_RmcRec, "gdata_" + GdataDefinitions.col_History_RmcRec.getName());
        query.addAliasedColumn((Object)GdataDefinitions.col_History_GgaRec, "gdata_" + GdataDefinitions.col_History_GgaRec.getName());
        query.addAliasedColumn((Object)GdataDefinitions.col_History_AreaId, "gdata_" + GdataDefinitions.col_History_AreaId.getName());
        query.addAliasedColumn((Object)GdataDefinitions.col_History_Trusted, "gdata_" + GdataDefinitions.col_History_Trusted.getName());
        query.addAliasedColumn((Object)GdataDefinitions.col_History_Reason, "gdata_" + GdataDefinitions.col_History_Reason.getName());
        query.addAliasedColumn((Object)GdataDefinitions.col_History_LongMsec, "gdata_" + GdataDefinitions.col_History_LongMsec.getName());
        query.addAliasedColumn((Object)GdataDefinitions.col_History_LatMsec, "gdata_" + GdataDefinitions.col_History_LatMsec.getName());
    }

    protected void addGdataData(T dto, ResultSet resultSet) {
        try {
            if (resultSet.getLong("gdata_" + GdataDefinitions.col_History_Id.getName()) == 0L) {
                ((ReportDTOBase)dto).removeDTOAttachable(PositionDTO.class);
                return;
            }
            int idx_unitId = resultSet.findColumn("gdata_" + GdataDefinitions.col_History_UnitId.getName());
            int idx_beginTime = resultSet.findColumn("gdata_" + GdataDefinitions.col_History_BeginTime.getName());
            int idx_beginReceiveTime = resultSet.findColumn("gdata_" + GdataDefinitions.col_History_BeginReceiveTime.getName());
            int idx_endReceiveTime = resultSet.findColumn("gdata_" + GdataDefinitions.col_History_EndReceiveTime.getName());
            int idx_endTime = resultSet.findColumn("gdata_" + GdataDefinitions.col_History_EndTime.getName());
            int idx_trusted = resultSet.findColumn("gdata_" + GdataDefinitions.col_History_Trusted.getName());
            int idx_reason = resultSet.findColumn("gdata_" + GdataDefinitions.col_History_Reason.getName());
            int idx_ggaRec = resultSet.findColumn("gdata_" + GdataDefinitions.col_History_GgaRec.getName());
            int idx_lat = resultSet.findColumn("gdata_" + GdataDefinitions.col_History_LatMsec.getName());
            int idx_long = resultSet.findColumn("gdata_" + GdataDefinitions.col_History_LongMsec.getName());
            int idx_areaId = resultSet.findColumn("gdata_" + GdataDefinitions.col_History_AreaId.getName());
            int idx_rmcRec = resultSet.findColumn("gdata_" + GdataDefinitions.col_History_RmcRec.getName());
            UnitDTO unitDTO = this.getUnitDTOMap().get(resultSet.getLong(idx_unitId));
            Area area = this.getAreaMap().get(resultSet.getInt(idx_areaId));
            String ggaRec = resultSet.getString(idx_ggaRec);
            String rmcRec = resultSet.getString(idx_rmcRec);
            String reason = resultSet.getString(idx_reason);
            int latMSEC = resultSet.getInt(idx_lat);
            int longMSEC = resultSet.getInt(idx_long);
            long gdataBeginTime = resultSet.getLong(idx_beginTime);
            long bdataEndTime = resultSet.getLong(idx_endTime);
            boolean trusted = resultSet.getBoolean(idx_trusted);
            long beginReceiveTime = resultSet.getLong(idx_beginReceiveTime);
            long endReceiveTime = resultSet.getLong(idx_endReceiveTime);
            long actualBeginTime = gdataBeginTime;
            long actualEndTime = bdataEndTime;
            String areaName = null;
            String areaDescription = null;
            if (area != null) {
                areaName = area.getArea();
                areaDescription = area.getDescription();
            }
            PositionDTO positionDTO = DTOFactory.buildPositionDTO(0L, gdataBeginTime, bdataEndTime, beginReceiveTime, endReceiveTime, actualBeginTime, actualEndTime, trusted, ggaRec, latMSEC, longMSEC, rmcRec, reason, areaName, areaDescription, unitDTO);
            ((ReportDTOBase)dto).addDTOAttachable(positionDTO);
        }
        catch (SQLException e) {
            ((ReportDTOBase)dto).removeDTOAttachable(PositionDTO.class);
        }
    }

    protected void addFISConditions() {
        IAreaTable definitions = (IAreaTable)this.getDefinitions();
        CustomRejoinTable tbl_inbound = new CustomRejoinTable((Table)FISDefinitions.tbl_FISFlight, "tbl_inbound");
        CustomRejoinTable tbl_outbound = new CustomRejoinTable((Table)FISDefinitions.tbl_FISFlight, "tbl_outbound");
        DbColumn beginTimeHistory = null;
        DbColumn endTimeHistory = null;
        if (this.selectionDTO.getInterval() != null) {
            beginTimeHistory = ExtendedReportFastLaneReader.getMaxSql(this.selectionDTO.getBeginTime(), this.getDefinitions().getHistoryFISBeginTimeColumn());
            endTimeHistory = ExtendedReportFastLaneReader.getMinSql(this.selectionDTO.getEndTime(), this.getDefinitions().getHistoryFISEndTimeColumn());
        } else {
            beginTimeHistory = this.getDefinitions().getHistoryFISBeginTimeColumn();
            endTimeHistory = this.getDefinitions().getHistoryFISEndTimeColumn();
        }
        this.historyQuery.addAliasedColumn((Object)tbl_inbound.getRejoinColumn((Column)FISDefinitions.col_FISFlight_FlightNumber), "inbound");
        this.historyQuery.addAliasedColumn((Object)tbl_outbound.getRejoinColumn((Column)FISDefinitions.col_FISFlight_FlightNumber), "outbound");
        this.historyQuery.addJoin(SelectQuery.JoinType.LEFT_OUTER, (Table)this.getDefinitions().getHistoryTable(), (Table)FISDefinitions.tbl_Area, (Column)definitions.getHistoryAreaIdColumn(), (Column)FISDefinitions.col_Area_Id);
        this.historyQuery.addJoin(SelectQuery.JoinType.LEFT_OUTER, (Table)FISDefinitions.tbl_Area, (Table)FISDefinitions.tbl_StandStateHistory, (Condition)new ComboCondition(ComboCondition.Op.AND, new Condition[]{new BinaryCondition(BinaryCondition.Op.EQUAL_TO, (Object)FISDefinitions.col_StandStateHistory_Stand, (Object)FISDefinitions.col_Area_Area), new BinaryCondition(BinaryCondition.Op.EQUAL_TO, (Object)FISDefinitions.col_StandStateHistory_StateId, (Object)1011), new BinaryCondition(BinaryCondition.Op.LESS_THAN, (Object)FISDefinitions.col_StandStateHistory_BeginTime, (Object)endTimeHistory), new ComboCondition(ComboCondition.Op.OR, new Condition[]{new BinaryCondition(BinaryCondition.Op.GREATER_THAN, (Object)FISDefinitions.col_StandStateHistory_EndTime, (Object)beginTimeHistory), new BinaryCondition(BinaryCondition.Op.EQUAL_TO, (Object)FISDefinitions.col_StandStateHistory_EndTime, (Object)0)})}));
        this.historyQuery.addJoin(SelectQuery.JoinType.LEFT_OUTER, (Table)FISDefinitions.tbl_StandStateHistory, (Table)tbl_inbound, (Column)FISDefinitions.col_StandStateHistory_inbFlightId, (Column)tbl_inbound.getRejoinColumn((Column)FISDefinitions.col_FISFlight_Id));
        this.historyQuery.addJoin(SelectQuery.JoinType.LEFT_OUTER, (Table)FISDefinitions.tbl_StandStateHistory, (Table)tbl_outbound, (Column)FISDefinitions.col_StandStateHistory_outbFlightId, (Column)tbl_outbound.getRejoinColumn((Column)FISDefinitions.col_FISFlight_Id));
        Long beginTimeCache = null;
        Long endTime = null;
        if (this.selectionDTO.getInterval() != null) {
            beginTimeCache = ExtendedReportFastLaneReader.getMaxSql(this.selectionDTO.getBeginTime(), this.getDefinitions().getCacheFISTimeColumn());
            endTime = this.selectionDTO.getInterval().getEndMillis();
        } else {
            beginTimeCache = System.currentTimeMillis();
            endTime = System.currentTimeMillis();
        }
        this.cacheQuery.addAliasedColumn((Object)tbl_inbound.getRejoinColumn((Column)FISDefinitions.col_FISFlight_FlightNumber), "inbound");
        this.cacheQuery.addAliasedColumn((Object)tbl_outbound.getRejoinColumn((Column)FISDefinitions.col_FISFlight_FlightNumber), "outbound");
        this.cacheQuery.addJoin(SelectQuery.JoinType.LEFT_OUTER, (Table)this.getDefinitions().getCacheTable(), (Table)FISDefinitions.tbl_Area, (Column)definitions.getCacheAreaIdColumn(), (Column)FISDefinitions.col_Area_Id);
        this.cacheQuery.addJoin(SelectQuery.JoinType.LEFT_OUTER, (Table)FISDefinitions.tbl_Area, (Table)FISDefinitions.tbl_StandStateHistory, (Condition)new ComboCondition(ComboCondition.Op.AND, new Condition[]{new BinaryCondition(BinaryCondition.Op.EQUAL_TO, (Object)FISDefinitions.col_StandStateHistory_Stand, (Object)FISDefinitions.col_Area_Area), new BinaryCondition(BinaryCondition.Op.EQUAL_TO, (Object)FISDefinitions.col_StandStateHistory_StateId, (Object)1011), new BinaryCondition(BinaryCondition.Op.LESS_THAN, (Object)FISDefinitions.col_StandStateHistory_BeginTime, (Object)endTime), new ComboCondition(ComboCondition.Op.OR, new Condition[]{new BinaryCondition(BinaryCondition.Op.GREATER_THAN, (Object)FISDefinitions.col_StandStateHistory_EndTime, (Object)beginTimeCache), new BinaryCondition(BinaryCondition.Op.EQUAL_TO, (Object)FISDefinitions.col_StandStateHistory_EndTime, (Object)0)})}));
        this.cacheQuery.addJoin(SelectQuery.JoinType.LEFT_OUTER, (Table)FISDefinitions.tbl_StandStateHistory, (Table)tbl_inbound, (Column)FISDefinitions.col_StandStateHistory_inbFlightId, (Column)tbl_inbound.getRejoinColumn((Column)FISDefinitions.col_FISFlight_Id));
        this.cacheQuery.addJoin(SelectQuery.JoinType.LEFT_OUTER, (Table)FISDefinitions.tbl_StandStateHistory, (Table)tbl_outbound, (Column)FISDefinitions.col_StandStateHistory_outbFlightId, (Column)tbl_outbound.getRejoinColumn((Column)FISDefinitions.col_FISFlight_Id));
    }

    protected void addFISData(T dto, ResultSet resultSet) {
        try {
            int idx_inbound = resultSet.findColumn("inbound");
            int idx_outbound = resultSet.findColumn("outbound");
            String inbound = resultSet.getString(idx_inbound);
            String outbound = resultSet.getString(idx_outbound);
            if (inbound == null && outbound == null) {
                return;
            }
            FISReportDTO fisDTO = new FISReportDTO(inbound, outbound);
            ((ReportDTOBase)dto).addDTOAttachable(fisDTO);
        }
        catch (SQLException e) {
            ((ReportDTOBase)dto).removeDTOAttachable(FISReportDTO.class);
        }
    }
}

