/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.web.data.fastlanereader.report;

import com.healthmarketscience.sqlbuilder.BinaryCondition;
import com.healthmarketscience.sqlbuilder.ComboCondition;
import com.healthmarketscience.sqlbuilder.Condition;
import com.healthmarketscience.sqlbuilder.SelectQuery;
import com.healthmarketscience.sqlbuilder.dbspec.Column;
import com.healthmarketscience.sqlbuilder.dbspec.Table;
import de.proveo.wwt.logic.web.common.dataSelection.filter.ITimeFilter;
import de.proveo.wwt.logic.web.common.dto.EventReportDTO;
import de.proveo.wwt.logic.web.data.fastlanereader.report.ExtendedReportFastLaneReader;
import de.proveo.wwt.logic.web.data.query.interfaces.IEventReportTableDefinitions;
import org.joda.time.Interval;

public abstract class EventReportFastLaneReader<T extends EventReportDTO, D extends IEventReportTableDefinitions>
extends ExtendedReportFastLaneReader<T, D> {
    protected EventReportFastLaneReader(D definitions) {
        super(definitions);
    }

    @Override
    protected D getDefinitions() {
        return (D)((IEventReportTableDefinitions)this.definitions);
    }

    @Override
    protected void addTimeConditions() {
        if (this.selectionDTO.getInterval() != null) {
            if (this.getDefinitions().getHelperDayStampColumn() != null) {
                this.historyQuery.addCondition((Condition)new BinaryCondition(BinaryCondition.Op.LESS_THAN_OR_EQUAL_TO, (Object)this.getDefinitions().getHelperDayStampColumn(), (Object)(this.selectionDTO.getEndTime() / 86400000L)));
                this.historyQuery.addCondition((Condition)new BinaryCondition(BinaryCondition.Op.GREATER_THAN_OR_EQUAL_TO, (Object)this.getDefinitions().getHelperDayStampColumn(), (Object)(this.selectionDTO.getBeginTime() / 86400000L)));
            }
            this.historyQuery.addCondition((Condition)new BinaryCondition(BinaryCondition.Op.LESS_THAN, (Object)this.getDefinitions().getHistoryCreateTimeColumn(), (Object)this.selectionDTO.getEndTime()));
            this.historyQuery.addCondition((Condition)new BinaryCondition(BinaryCondition.Op.GREATER_THAN, (Object)this.getDefinitions().getHistoryCreateTimeColumn(), (Object)this.selectionDTO.getBeginTime()));
            this.cacheQuery.addCondition((Condition)new BinaryCondition(BinaryCondition.Op.LESS_THAN, (Object)this.getDefinitions().getCacheCreateTimeColumn(), (Object)this.selectionDTO.getEndTime()));
            this.cacheQuery.addCondition((Condition)new BinaryCondition(BinaryCondition.Op.GREATER_THAN, (Object)this.getDefinitions().getCacheCreateTimeColumn(), (Object)this.selectionDTO.getBeginTime()));
            for (ITimeFilter filter : this.selectionDTO.getTimeFilters()) {
                Interval[] intervals;
                ComboCondition comboHistory = new ComboCondition(ComboCondition.Op.OR);
                ComboCondition comboCache = new ComboCondition(ComboCondition.Op.OR);
                for (Interval interval : intervals = filter.getIntervals(this.selectionDTO.getBeginTime(), this.selectionDTO.getEndTime())) {
                    ComboCondition timeConditionHistory = new ComboCondition(ComboCondition.Op.AND);
                    ComboCondition timeConditionCache = new ComboCondition(ComboCondition.Op.AND);
                    if (this.getDefinitions().getHelperDayStampColumn() != null) {
                        timeConditionHistory.addCondition((Condition)new BinaryCondition(BinaryCondition.Op.LESS_THAN_OR_EQUAL_TO, (Object)this.getDefinitions().getHelperDayStampColumn(), (Object)(interval.getEndMillis() / 86400000L)));
                        timeConditionHistory.addCondition((Condition)new BinaryCondition(BinaryCondition.Op.GREATER_THAN_OR_EQUAL_TO, (Object)this.getDefinitions().getHelperDayStampColumn(), (Object)(interval.getStartMillis() / 86400000L)));
                    }
                    timeConditionHistory.addCondition((Condition)new BinaryCondition(BinaryCondition.Op.LESS_THAN, (Object)this.getDefinitions().getHistoryCreateTimeColumn(), (Object)interval.getEndMillis()));
                    timeConditionHistory.addCondition((Condition)new BinaryCondition(BinaryCondition.Op.GREATER_THAN, (Object)this.getDefinitions().getHistoryCreateTimeColumn(), (Object)interval.getStartMillis()));
                    timeConditionCache.addCondition((Condition)new BinaryCondition(BinaryCondition.Op.LESS_THAN, (Object)this.getDefinitions().getCacheCreateTimeColumn(), (Object)interval.getEndMillis()));
                    timeConditionCache.addCondition((Condition)new BinaryCondition(BinaryCondition.Op.GREATER_THAN, (Object)this.getDefinitions().getCacheCreateTimeColumn(), (Object)interval.getStartMillis()));
                    comboHistory.addCondition((Condition)timeConditionHistory);
                    comboCache.addCondition((Condition)timeConditionCache);
                }
                this.historyQuery.addCondition((Condition)comboHistory);
                this.cacheQuery.addCondition((Condition)comboCache);
            }
        }
    }

    @Override
    protected void prepareCacheColumns() {
        super.prepareCacheColumns();
        this.cacheQuery.addColumns(new Column[]{this.getDefinitions().getCacheCreateTimeColumn(), this.getDefinitions().getCacheReceiveTimeColumn()});
        this.cacheQuery.addAliasedColumn((Object)this.getDefinitions().getCacheCreateTimeColumn(), "bt");
    }

    @Override
    protected void prepareHistoryColumns() {
        super.prepareHistoryColumns();
        this.historyQuery.addColumns(new Column[]{this.getDefinitions().getHistoryCreateTimeColumn(), this.getDefinitions().getHistoryReceiveTimeColumn()});
        this.historyQuery.addAliasedColumn((Object)this.getDefinitions().getHistoryCreateTimeColumn(), "bt");
        if (this.getDefinitions().getHelperTable() != null && this.getDefinitions().getHelperTable() != this.getDefinitions().getHistoryTable()) {
            this.historyQuery.addJoin(SelectQuery.JoinType.INNER, (Table)this.getDefinitions().getHelperTable(), (Table)this.getDefinitions().getHistoryTable(), (Column)this.getDefinitions().getHelperHistoryIdColumn(), (Column)this.getDefinitions().getHistoryIdColumn());
        }
    }
}

