/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.web.data.fastlanereader.replay;

import com.healthmarketscience.sqlbuilder.BinaryCondition;
import com.healthmarketscience.sqlbuilder.ComboCondition;
import com.healthmarketscience.sqlbuilder.Condition;
import com.healthmarketscience.sqlbuilder.CustomCondition;
import com.healthmarketscience.sqlbuilder.CustomSql;
import com.healthmarketscience.sqlbuilder.FunctionCall;
import com.healthmarketscience.sqlbuilder.InCondition;
import com.healthmarketscience.sqlbuilder.OrderObject;
import com.healthmarketscience.sqlbuilder.SelectQuery;
import com.healthmarketscience.sqlbuilder.SqlObject;
import com.healthmarketscience.sqlbuilder.dbspec.Column;
import com.healthmarketscience.sqlbuilder.dbspec.Table;
import de.proveo.util.database.DatabaseType;
import de.proveo.wwt.logic.app.util.Stopwatch;
import de.proveo.wwt.logic.web.data.fastlanereader.base.ReplayFastLaneBase;
import de.proveo.wwt.logic.web.data.fastlanereader.base.UnitReplayFastLaneBase;
import de.proveo.wwt.logic.web.data.query.definitions.KeepaliveDefinitions;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class KeepAliveReplayFastLaneReader
extends UnitReplayFastLaneBase {
    private static final Log log = LogFactory.getLog(KeepAliveReplayFastLaneReader.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TreeMap<Long, HashMap> getReplayData(HashSet<Long> unitPermissions, TreeMap<Long, HashMap> completeReplayDataMap, long since, long until, ReplayFastLaneBase.DataType dataType) {
        String method = "getReplayData(" + (Object)((Object)dataType) + ")";
        log.debug((Object)(method + " called"));
        Stopwatch stopwatch = new Stopwatch(KeepAliveReplayFastLaneReader.class, method);
        stopwatch.start("Overall");
        int maxRowsLimit = this.getRowLimit();
        log.debug((Object)(method + ": maxRowLimit=" + maxRowsLimit));
        TreeMap<Long, HashMap> retMap = new TreeMap<Long, HashMap>();
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            connection = this.getConnection();
            if (connection != null) {
                String sql = null;
                switch (dataType) {
                    case CACHE: {
                        sql = this.generateCacheSqlForReplay(since, until, maxRowsLimit, unitPermissions);
                        break;
                    }
                    case HISTORY: {
                        sql = this.generateHistorySqlForReplay(since, until, maxRowsLimit);
                        break;
                    }
                    default: {
                        log.error((Object)("Unkown data type: " + (Object)((Object)dataType) + ". Break!"));
                        TreeMap<Long, HashMap> treeMap = retMap;
                        return treeMap;
                    }
                }
                log.debug((Object)(method + ": Execute SQL: " + sql));
                stopwatch.start("Database access");
                statement = this.createReadOnlyForwardOnlyStatement(connection);
                resultSet = statement.executeQuery(sql);
                stopwatch.stop("Database access", true);
                log.debug((Object)(method + ": building Maps..."));
                stopwatch.start("Build DTO");
                int rowCounter = 0;
                while (resultSet.next()) {
                    if (maxRowsLimit != 0 && ++rowCounter == maxRowsLimit) {
                        log.debug((Object)(method + ": Row limit exceeded: " + maxRowsLimit));
                        break;
                    }
                    long kaUnitId = resultSet.getLong("UNIT_ID");
                    if (!unitPermissions.contains(kaUnitId)) continue;
                    long kaTimeStamp = resultSet.getLong("CREATE_TIME");
                    while (completeReplayDataMap.containsKey(kaTimeStamp)) {
                        ++kaTimeStamp;
                    }
                    HashMap valueMap = this.generateReplayValueMap(kaTimeStamp, null, resultSet);
                    completeReplayDataMap.put(kaTimeStamp, valueMap);
                    retMap.put(kaTimeStamp, valueMap);
                }
                stopwatch.stop("Build DTO", true, retMap.size());
            }
        }
        catch (SQLException e) {
            log.error((Object)(method + ": runs into"), (Throwable)e);
        }
        finally {
            this.closeQuietly(statement, resultSet, connection);
            statement = null;
            resultSet = null;
            connection = null;
        }
        stopwatch.stop("Overall", true);
        return retMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap<Long, HashMap> getCacheInitialForReplay(HashSet<Long> unitPermissions, long since) {
        String method = "getCacheInitialForReplay()";
        log.debug((Object)"getCacheInitialForReplay() called");
        Stopwatch stopwatch = new Stopwatch(KeepAliveReplayFastLaneReader.class, "getCacheInitialForReplay()");
        stopwatch.start("Overall");
        int maxRowsLimit = this.getRowLimit();
        log.debug((Object)("getCacheInitialForReplay(): maxRowLimit=" + maxRowsLimit));
        HashMap<Long, HashMap> retMap = new HashMap<Long, HashMap>();
        if (unitPermissions == null || unitPermissions.isEmpty()) {
            log.warn((Object)"getCacheInitialForReplay(): No permissions, break.");
            stopwatch.stop("Overall", true);
            return retMap;
        }
        unitPermissions = new HashSet<Long>(unitPermissions);
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            connection = this.getConnection();
            if (connection != null) {
                String sql = this.generateCacheInitialSqlForReplay(maxRowsLimit, unitPermissions);
                log.debug((Object)("getCacheInitialForReplay(): Execute SQL: " + sql));
                stopwatch.start("Database access");
                statement = this.createReadOnlyForwardOnlyStatement(connection);
                resultSet = statement.executeQuery(sql);
                stopwatch.stop("Database access", true);
                log.debug((Object)"getCacheInitialForReplay(): building Maps...");
                stopwatch.start("Build DTO");
                HashSet<Long> unitIdsWithOlderKeepAlive = new HashSet<Long>();
                int rowCounter = 0;
                boolean limitExceeded = false;
                while (resultSet.next()) {
                    if (maxRowsLimit != 0 && ++rowCounter == maxRowsLimit) {
                        log.debug((Object)("getCacheInitialForReplay(): Row limit exceeded: " + maxRowsLimit));
                        limitExceeded = true;
                        break;
                    }
                    long kaUnitId = resultSet.getLong("UNIT_ID");
                    long kaTimeStamp = resultSet.getLong("CREATE_TIME");
                    if (kaTimeStamp <= since) {
                        HashMap<String, Object> valueMap = new HashMap<String, Object>();
                        valueMap.put("EventType", "KeepAliveEvent");
                        valueMap.put("UnitId", kaUnitId);
                        valueMap.put("KeepaliveTimestamp", kaTimeStamp);
                        valueMap.put("KeepaliveTimeout", Boolean.FALSE);
                        valueMap.put("ServerTime", kaTimeStamp);
                        retMap.put(kaUnitId, valueMap);
                        continue;
                    }
                    unitIdsWithOlderKeepAlive.add(kaUnitId);
                }
                if (!limitExceeded) {
                    unitPermissions.removeAll(retMap.keySet());
                    unitPermissions.removeAll(unitIdsWithOlderKeepAlive);
                    for (long kaUnitId : unitPermissions) {
                        retMap.put(kaUnitId, new HashMap());
                    }
                }
                stopwatch.stop("Build DTO", true, retMap.size());
            }
        }
        catch (SQLException e) {
            log.error((Object)"getCacheInitialForReplay(): runs into", (Throwable)e);
        }
        finally {
            this.closeQuietly(statement, resultSet, connection);
            statement = null;
            resultSet = null;
            connection = null;
        }
        stopwatch.stop("Overall", true);
        return retMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap<Long, HashMap> getHistoryInitialForReplay(HashSet<Long> unitPermissions, long since, long serverInfomanKeepaliveTimeout) {
        String method = "getHistoryInitialForReplay()";
        log.debug((Object)"getHistoryInitialForReplay() called");
        Stopwatch stopwatch = new Stopwatch(KeepAliveReplayFastLaneReader.class, "getHistoryInitialForReplay()");
        stopwatch.start("Overall");
        int maxRowsLimit = this.getRowLimit();
        log.debug((Object)("getHistoryInitialForReplay(): maxRowLimit=" + maxRowsLimit));
        HashMap<Long, HashMap> retMap = new HashMap<Long, HashMap>();
        if (unitPermissions == null || unitPermissions.isEmpty()) {
            log.warn((Object)"getHistoryInitialForReplay(): No permissions, break.");
            stopwatch.stop("Overall", true);
            return retMap;
        }
        unitPermissions = new HashSet<Long>(unitPermissions);
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            connection = this.getConnection();
            if (connection != null) {
                HashMap valueMap;
                long kaTimeStamp;
                long kaUnitId;
                String sql = this.generateHistoryInitialSqlForReplay(since, maxRowsLimit, serverInfomanKeepaliveTimeout);
                log.debug((Object)("getHistoryInitialForReplay(): Execute SQL: " + sql));
                stopwatch.start("Database access");
                statement = this.createReadOnlyForwardOnlyStatement(connection);
                resultSet = statement.executeQuery(sql);
                stopwatch.stop("Database access", true);
                log.debug((Object)"getHistoryInitialForReplay(): building Maps...");
                stopwatch.start("Build DTO");
                int rowCounter = 0;
                boolean limitExceeded = false;
                while (resultSet.next()) {
                    if (maxRowsLimit != 0 && ++rowCounter == maxRowsLimit) {
                        log.debug((Object)("getHistoryInitialForReplay(): Row limit exceeded: " + maxRowsLimit));
                        limitExceeded = true;
                        break;
                    }
                    kaUnitId = resultSet.getLong("UNIT_ID");
                    if (!unitPermissions.contains(kaUnitId)) continue;
                    kaTimeStamp = resultSet.getLong("CREATE_TIME");
                    valueMap = this.generateReplayValueMap(kaTimeStamp, Boolean.FALSE, resultSet);
                    retMap.put(kaUnitId, valueMap);
                }
                if (!limitExceeded) {
                    unitPermissions.removeAll(retMap.keySet());
                    if (unitPermissions.size() > 0) {
                        sql = this.generateHistoryInitialSqlSecureForReplay(since, maxRowsLimit, unitPermissions);
                        log.debug((Object)("getHistoryInitialForReplay(): Execute SQL: " + sql));
                        stopwatch.start("Database access");
                        resultSet = statement.executeQuery(sql);
                        stopwatch.stop("Database access", true);
                        log.debug((Object)"getHistoryInitialForReplay(): building Maps...");
                        rowCounter = 0;
                        while (resultSet.next()) {
                            if (maxRowsLimit != 0 && ++rowCounter == maxRowsLimit) {
                                log.debug((Object)("getHistoryInitialForReplay(): Row limit exceeded: " + maxRowsLimit));
                                break;
                            }
                            kaUnitId = resultSet.getLong("UNIT_ID");
                            if (!unitPermissions.contains(kaUnitId)) continue;
                            kaTimeStamp = resultSet.getLong("CREATE_TIME");
                            valueMap = this.generateReplayValueMap(kaTimeStamp, Boolean.FALSE, resultSet);
                            retMap.put(kaUnitId, valueMap);
                        }
                    }
                }
                stopwatch.stop("Build DTO", true, retMap.size());
            }
        }
        catch (SQLException e) {
            log.error((Object)"getHistoryInitialForReplay(): runs into", (Throwable)e);
        }
        finally {
            this.closeQuietly(statement, resultSet, connection);
            statement = null;
            resultSet = null;
            connection = null;
        }
        stopwatch.stop("Overall", true);
        return retMap;
    }

    private String generateCacheSqlForReplay(long since, long until, int maxRowsLimit, HashSet<Long> unitPermissions) {
        SelectQuery query = new SelectQuery();
        query.addColumns(new Column[]{KeepaliveDefinitions.col_Cache_UnitId, KeepaliveDefinitions.col_Cache_CreateTime});
        ComboCondition whereCondition = new ComboCondition(ComboCondition.Op.AND);
        whereCondition.addCondition((Condition)new BinaryCondition(BinaryCondition.Op.GREATER_THAN, (Object)KeepaliveDefinitions.col_Cache_CreateTime, (Object)since));
        whereCondition.addCondition((Condition)new BinaryCondition(BinaryCondition.Op.LESS_THAN_OR_EQUAL_TO, (Object)KeepaliveDefinitions.col_Cache_CreateTime, (Object)until));
        whereCondition.addCondition((Condition)new InCondition((Object)KeepaliveDefinitions.col_Cache_UnitId, unitPermissions));
        if (this.databaseType == DatabaseType.Oracle && maxRowsLimit != 0) {
            whereCondition.addCondition((Condition)new CustomCondition((SqlObject)new CustomSql((Object)("ROWNUM <= " + maxRowsLimit))));
        }
        query.addCondition((Condition)whereCondition);
        String sql = ((SelectQuery)query.validate()).toString();
        if (maxRowsLimit != 0) {
            StringBuilder limitBuilder = new StringBuilder();
            switch (this.databaseType) {
                case MSSQL: {
                    limitBuilder.append("SELECT TOP ");
                    limitBuilder.append(maxRowsLimit);
                    limitBuilder.append(sql.substring(6));
                    sql = limitBuilder.toString();
                    break;
                }
                case MySQL: {
                    limitBuilder.append(sql);
                    limitBuilder.append(" LIMIT ");
                    limitBuilder.append(maxRowsLimit);
                    sql = limitBuilder.toString();
                }
            }
        }
        return sql;
    }

    private String generateHistorySqlForReplay(long since, long until, int maxRowsLimit) {
        SelectQuery query = new SelectQuery(true);
        query.addColumns(new Column[]{KeepaliveDefinitions.col_History_UnitId, KeepaliveDefinitions.col_History_CreateTime});
        query.addJoin(SelectQuery.JoinType.LEFT_OUTER, (Table)KeepaliveDefinitions.tbl_HistoryHelper, (Table)KeepaliveDefinitions.tbl_History, (Column)KeepaliveDefinitions.col_HistoryHelper_Id, (Column)KeepaliveDefinitions.col_History_Id);
        ComboCondition whereCondition = new ComboCondition(ComboCondition.Op.AND);
        whereCondition.addCondition((Condition)new BinaryCondition(BinaryCondition.Op.LESS_THAN_OR_EQUAL_TO, (Object)KeepaliveDefinitions.col_HistoryHelper_DayStamp, (Object)(until / 86400000L)));
        whereCondition.addCondition((Condition)new BinaryCondition(BinaryCondition.Op.GREATER_THAN_OR_EQUAL_TO, (Object)KeepaliveDefinitions.col_HistoryHelper_DayStamp, (Object)(since / 86400000L)));
        whereCondition.addCondition((Condition)new BinaryCondition(BinaryCondition.Op.GREATER_THAN, (Object)KeepaliveDefinitions.col_History_CreateTime, (Object)since));
        whereCondition.addCondition((Condition)new BinaryCondition(BinaryCondition.Op.LESS_THAN_OR_EQUAL_TO, (Object)KeepaliveDefinitions.col_History_CreateTime, (Object)until));
        if (this.databaseType == DatabaseType.Oracle && maxRowsLimit != 0) {
            whereCondition.addCondition((Condition)new CustomCondition((SqlObject)new CustomSql((Object)("ROWNUM <= " + maxRowsLimit))));
        }
        query.addCondition((Condition)whereCondition);
        query.addOrdering((Column)KeepaliveDefinitions.col_History_CreateTime, OrderObject.Dir.ASCENDING);
        String sql = ((SelectQuery)query.validate()).toString();
        if (maxRowsLimit != 0) {
            StringBuilder limitBuilder = new StringBuilder();
            switch (this.databaseType) {
                case MSSQL: {
                    limitBuilder.append("SELECT DISTINCT TOP ");
                    limitBuilder.append(maxRowsLimit);
                    limitBuilder.append(sql.substring(15));
                    sql = limitBuilder.toString();
                    break;
                }
                case MySQL: {
                    limitBuilder.append(sql);
                    limitBuilder.append(" LIMIT ");
                    limitBuilder.append(maxRowsLimit);
                    sql = limitBuilder.toString();
                }
            }
        }
        return sql;
    }

    private String generateHistoryInitialSqlForReplay(long since, int maxRowsLimit, long serverInfomanKeepaliveTimeout) {
        int keepaliveInDays = (int)((double)serverInfomanKeepaliveTimeout / 60.0 / 24.0 + 0.9999);
        SelectQuery query = new SelectQuery(true);
        query.addColumns(new Column[]{KeepaliveDefinitions.col_History_UnitId});
        query.addAliasedColumn((Object)FunctionCall.max().addColumnParams(new Column[]{KeepaliveDefinitions.col_History_CreateTime}), "CREATE_TIME");
        query.addJoin(SelectQuery.JoinType.LEFT_OUTER, (Table)KeepaliveDefinitions.tbl_HistoryHelper, (Table)KeepaliveDefinitions.tbl_History, (Condition)new BinaryCondition(BinaryCondition.Op.EQUAL_TO, (Object)KeepaliveDefinitions.col_HistoryHelper_Id, (Object)KeepaliveDefinitions.col_History_Id));
        ComboCondition whereCondition = new ComboCondition(ComboCondition.Op.AND);
        whereCondition.addCondition((Condition)new BinaryCondition(BinaryCondition.Op.LESS_THAN_OR_EQUAL_TO, (Object)KeepaliveDefinitions.col_HistoryHelper_DayStamp, (Object)(since / 86400000L)));
        whereCondition.addCondition((Condition)new BinaryCondition(BinaryCondition.Op.GREATER_THAN_OR_EQUAL_TO, (Object)KeepaliveDefinitions.col_HistoryHelper_DayStamp, (Object)(since / 86400000L - (long)keepaliveInDays)));
        whereCondition.addCondition((Condition)new BinaryCondition(BinaryCondition.Op.LESS_THAN_OR_EQUAL_TO, (Object)KeepaliveDefinitions.col_History_CreateTime, (Object)since));
        if (this.databaseType == DatabaseType.Oracle && maxRowsLimit != 0) {
            whereCondition.addCondition((Condition)new CustomCondition((SqlObject)new CustomSql((Object)("ROWNUM <= " + maxRowsLimit))));
        }
        query.addCondition((Condition)whereCondition);
        query.addCustomGroupings(new Object[]{KeepaliveDefinitions.col_History_UnitId});
        query.addCustomOrdering((Object)KeepaliveDefinitions.col_History_CreateTime, OrderObject.Dir.ASCENDING);
        String sql = ((SelectQuery)query.validate()).toString();
        if (maxRowsLimit != 0) {
            StringBuilder limitBuilder = new StringBuilder();
            switch (this.databaseType) {
                case MSSQL: {
                    limitBuilder.append("SELECT DISTINCT TOP ");
                    limitBuilder.append(maxRowsLimit);
                    limitBuilder.append(sql.substring(15));
                    sql = limitBuilder.toString();
                    break;
                }
                case MySQL: {
                    limitBuilder.append(sql);
                    limitBuilder.append(" LIMIT ");
                    limitBuilder.append(maxRowsLimit);
                    sql = limitBuilder.toString();
                }
            }
        }
        return sql;
    }

    private String generateHistoryInitialSqlSecureForReplay(long since, int maxRowsLimit, HashSet<Long> unitPermissions) {
        SelectQuery query = new SelectQuery(true);
        query.addColumns(new Column[]{KeepaliveDefinitions.col_History_UnitId});
        query.addAliasedColumn((Object)FunctionCall.max().addColumnParams(new Column[]{KeepaliveDefinitions.col_History_CreateTime}), "CREATE_TIME");
        ComboCondition whereCondition = new ComboCondition(ComboCondition.Op.AND);
        whereCondition.addCondition((Condition)new BinaryCondition(BinaryCondition.Op.LESS_THAN_OR_EQUAL_TO, (Object)KeepaliveDefinitions.col_History_CreateTime, (Object)since));
        whereCondition.addCondition((Condition)new InCondition((Object)KeepaliveDefinitions.col_History_UnitId, unitPermissions));
        if (this.databaseType == DatabaseType.Oracle && maxRowsLimit != 0) {
            whereCondition.addCondition((Condition)new CustomCondition((SqlObject)new CustomSql((Object)("ROWNUM <= " + maxRowsLimit))));
        }
        query.addCondition((Condition)whereCondition);
        query.addGroupings(new Column[]{KeepaliveDefinitions.col_History_UnitId});
        query.addOrdering((Column)KeepaliveDefinitions.col_History_CreateTime, OrderObject.Dir.ASCENDING);
        String sql = ((SelectQuery)query.validate()).toString();
        if (maxRowsLimit != 0) {
            StringBuilder limitBuilder = new StringBuilder();
            switch (this.databaseType) {
                case MSSQL: {
                    limitBuilder.append("SELECT DISTINCT TOP ");
                    limitBuilder.append(maxRowsLimit);
                    limitBuilder.append(sql.substring(15));
                    sql = limitBuilder.toString();
                    break;
                }
                case MySQL: {
                    limitBuilder.append(sql);
                    limitBuilder.append(" LIMIT ");
                    limitBuilder.append(maxRowsLimit);
                    sql = limitBuilder.toString();
                }
            }
        }
        return sql;
    }

    private String generateCacheInitialSqlForReplay(int maxRowsLimit, HashSet<Long> unitPermissions) {
        SelectQuery query = new SelectQuery();
        query.addColumns(new Column[]{KeepaliveDefinitions.col_Cache_UnitId, KeepaliveDefinitions.col_Cache_CreateTime});
        ComboCondition whereCondition = new ComboCondition(ComboCondition.Op.AND);
        whereCondition.addCondition((Condition)new InCondition((Object)KeepaliveDefinitions.col_Cache_UnitId, unitPermissions));
        if (this.databaseType == DatabaseType.Oracle && maxRowsLimit != 0) {
            whereCondition.addCondition((Condition)new CustomCondition((SqlObject)new CustomSql((Object)("ROWNUM <= " + maxRowsLimit))));
        }
        query.addCondition((Condition)whereCondition);
        query.addOrdering((Column)KeepaliveDefinitions.col_Cache_CreateTime, OrderObject.Dir.DESCENDING);
        String sql = ((SelectQuery)query.validate()).toString();
        if (maxRowsLimit != 0) {
            StringBuilder limitBuilder = new StringBuilder();
            switch (this.databaseType) {
                case MSSQL: {
                    limitBuilder.append("SELECT TOP ");
                    limitBuilder.append(maxRowsLimit);
                    limitBuilder.append(sql.substring(6));
                    sql = limitBuilder.toString();
                    break;
                }
                case MySQL: {
                    limitBuilder.append(sql);
                    limitBuilder.append(" LIMIT ");
                    limitBuilder.append(maxRowsLimit);
                    sql = limitBuilder.toString();
                }
            }
        }
        return sql;
    }

    private HashMap generateReplayValueMap(long kaTimeStamp, Boolean keepAliveTimeout, ResultSet resultSet) throws SQLException {
        HashMap<String, Object> valueMap = new HashMap<String, Object>();
        long kaUnitId = resultSet.getLong("UNIT_ID");
        valueMap.put("EventType", "KeepAliveEvent");
        valueMap.put("UnitId", kaUnitId);
        valueMap.put("KeepaliveTimestamp", kaTimeStamp);
        if (keepAliveTimeout != null) {
            valueMap.put("KeepaliveTimeout", keepAliveTimeout);
        }
        valueMap.put("ServerTime", kaTimeStamp);
        return valueMap;
    }
}

