/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.web.data.fastlanereader.replay;

import com.healthmarketscience.sqlbuilder.BinaryCondition;
import com.healthmarketscience.sqlbuilder.ComboCondition;
import com.healthmarketscience.sqlbuilder.Condition;
import com.healthmarketscience.sqlbuilder.CustomCondition;
import com.healthmarketscience.sqlbuilder.CustomSql;
import com.healthmarketscience.sqlbuilder.InCondition;
import com.healthmarketscience.sqlbuilder.OrderObject;
import com.healthmarketscience.sqlbuilder.SelectQuery;
import com.healthmarketscience.sqlbuilder.SqlObject;
import com.healthmarketscience.sqlbuilder.dbspec.Column;
import com.healthmarketscience.sqlbuilder.dbspec.Table;
import de.proveo.util.database.DatabaseType;
import de.proveo.wwt.logic.app.util.Stopwatch;
import de.proveo.wwt.logic.web.data.fastlanereader.base.ReplayFastLaneBase;
import de.proveo.wwt.logic.web.data.fastlanereader.base.UnitReplayFastLaneBase;
import de.proveo.wwt.logic.web.data.query.definitions.GdataDefinitions;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GdataReplayFastLaneReader
extends UnitReplayFastLaneBase {
    private static final Log log = LogFactory.getLog(GdataReplayFastLaneReader.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TreeMap<Long, HashMap> getReplayData(HashSet<Long> unitPermissions, TreeMap<Long, HashMap> completeReplayDataMap, long since, long until, ReplayFastLaneBase.DataType dataType) {
        String method = "getReplayData(" + (Object)((Object)dataType) + ")";
        log.debug((Object)(method + " called"));
        Stopwatch stopwatch = new Stopwatch(GdataReplayFastLaneReader.class, method);
        stopwatch.start("Overall");
        int maxRowsLimit = this.getRowLimit();
        log.debug((Object)(method + ": maxRowLimit=" + maxRowsLimit));
        TreeMap<Long, HashMap> retMap = new TreeMap<Long, HashMap>();
        if (unitPermissions == null || unitPermissions.isEmpty()) {
            log.warn((Object)(method + ": No permissions, break."));
            stopwatch.stop("Overall", true);
            return retMap;
        }
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            connection = this.getConnection();
            if (connection != null) {
                String sql = null;
                switch (dataType) {
                    case CACHE: {
                        sql = this.generateCacheSqlForReplay(since, until, maxRowsLimit, unitPermissions);
                        break;
                    }
                    case HISTORY: {
                        sql = this.generateHistorySqlForReplay(since, until, maxRowsLimit);
                        break;
                    }
                    default: {
                        log.error((Object)("Unkown data type: " + (Object)((Object)dataType) + ". Break!"));
                        TreeMap<Long, HashMap> treeMap = retMap;
                        return treeMap;
                    }
                }
                log.debug((Object)(method + ": Execute SQL: " + sql));
                stopwatch.start("Database access");
                statement = this.createReadOnlyForwardOnlyStatement(connection);
                resultSet = statement.executeQuery(sql);
                stopwatch.stop("Database access", true);
                log.debug((Object)(method + ": building Maps..."));
                stopwatch.start("Build DTO");
                int rowCounter = 0;
                while (resultSet.next()) {
                    if (maxRowsLimit != 0 && ++rowCounter == maxRowsLimit) {
                        log.debug((Object)(method + ": Row limit exceeded: " + maxRowsLimit));
                        break;
                    }
                    long unitId = resultSet.getLong("UNIT_ID");
                    if (!unitPermissions.contains(unitId)) continue;
                    long gdataBeginTime = resultSet.getLong("BEGIN_TIME");
                    while (completeReplayDataMap.containsKey(gdataBeginTime)) {
                        ++gdataBeginTime;
                    }
                    HashMap valueMap = this.generateReplayValueMap(unitId, gdataBeginTime, resultSet);
                    if (valueMap == null) continue;
                    completeReplayDataMap.put(gdataBeginTime, valueMap);
                    retMap.put(gdataBeginTime, valueMap);
                }
                stopwatch.stop("Build DTO", true, retMap.size());
            }
        }
        catch (SQLException e) {
            log.error((Object)(method + ": runs into"), (Throwable)e);
        }
        finally {
            this.closeQuietly(statement, resultSet, connection);
            statement = null;
            resultSet = null;
            connection = null;
        }
        stopwatch.stop("Overall", true);
        return retMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap<Long, HashMap> getCacheInitialForReplay(HashSet<Long> unitPermissions, long since) {
        String method = "getCacheInitialForReplay()";
        log.debug((Object)"getCacheInitialForReplay() called");
        Stopwatch stopwatch = new Stopwatch(GdataReplayFastLaneReader.class, "getCacheInitialForReplay()");
        stopwatch.start("Overall");
        int maxRowsLimit = this.getRowLimit();
        log.debug((Object)("getCacheInitialForReplay(): maxRowLimit=" + maxRowsLimit));
        HashMap<Long, HashMap> retMap = new HashMap<Long, HashMap>();
        if (unitPermissions == null || unitPermissions.isEmpty()) {
            log.warn((Object)"getCacheInitialForReplay(): No permissions, break.");
            stopwatch.stop("Overall", true);
            return retMap;
        }
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            connection = this.getConnection();
            if (connection != null) {
                String sql = this.generateCacheInitialSqlForReplay(since, maxRowsLimit, unitPermissions);
                log.debug((Object)("getCacheInitialForReplay(): Execute SQL: " + sql));
                stopwatch.start("Database access");
                statement = this.createReadOnlyForwardOnlyStatement(connection);
                resultSet = statement.executeQuery(sql);
                stopwatch.stop("Database access", true);
                log.debug((Object)"getCacheInitialForReplay(): building Maps...");
                stopwatch.start("Build DTO");
                int rowCounter = 0;
                while (resultSet.next()) {
                    long gdataBeginTime;
                    if (maxRowsLimit != 0 && ++rowCounter == maxRowsLimit) {
                        log.debug((Object)("getCacheInitialForReplay(): Row limit exceeded: " + maxRowsLimit));
                        break;
                    }
                    long unitId = resultSet.getLong("UNIT_ID");
                    HashMap valueMap = this.generateReplayValueMap(unitId, gdataBeginTime = resultSet.getLong("BEGIN_TIME"), resultSet);
                    if (valueMap == null) continue;
                    retMap.put(resultSet.getLong("UNIT_ID"), valueMap);
                }
                stopwatch.stop("Build DTO", true, retMap.size());
            }
        }
        catch (SQLException e) {
            log.error((Object)"getCacheInitialForReplay(): runs into", (Throwable)e);
        }
        finally {
            this.closeQuietly(statement, resultSet, connection);
            statement = null;
            resultSet = null;
            connection = null;
        }
        stopwatch.stop("Overall", true);
        return retMap;
    }

    private HashMap generateReplayValueMap(long unitId, long gdataBeginTime, ResultSet resultSet) throws SQLException {
        HashMap<String, Object> valueMap;
        String ggaRec = resultSet.getString("GGA_REC");
        String rmcRec = resultSet.getString("RMC_REC");
        if (ggaRec == null || ggaRec.length() < 50 || rmcRec == null || rmcRec.length() < 40) {
            valueMap = null;
        } else {
            int areaId = resultSet.getInt("AREA_ID");
            boolean trusted = resultSet.getBoolean("TRUSTED");
            int latMSEC = resultSet.getInt("LAT_MSEC");
            int longMSEC = resultSet.getInt("LONG_MSEC");
            valueMap = new HashMap<String, Object>();
            valueMap.put("EventType", "GeoStruct");
            valueMap.put("UnitId", unitId);
            valueMap.put("GpsGga", ggaRec);
            valueMap.put("GpsRmc", rmcRec);
            valueMap.put("GpsTrusted", trusted);
            valueMap.put("GeoBegin", gdataBeginTime);
            valueMap.put("AreaId", areaId);
            valueMap.put("GpsLatMsec", latMSEC);
            valueMap.put("GpsLongMsec", longMSEC);
            valueMap.put("ServerTime", gdataBeginTime);
        }
        return valueMap;
    }

    private String generateCacheSqlForReplay(long since, long until, int maxRowsLimit, HashSet<Long> unitPermissions) {
        SelectQuery query = new SelectQuery();
        query.addColumns(new Column[]{GdataDefinitions.col_Cache_UnitId, GdataDefinitions.col_Cache_BeginTime, GdataDefinitions.col_Cache_RmcRec, GdataDefinitions.col_Cache_GgaRec, GdataDefinitions.col_Cache_AreaId, GdataDefinitions.col_Cache_Trusted, GdataDefinitions.col_Cache_LongMsec, GdataDefinitions.col_Cache_LatMsec});
        ComboCondition whereCondition = new ComboCondition(ComboCondition.Op.AND);
        whereCondition.addCondition((Condition)new BinaryCondition(BinaryCondition.Op.GREATER_THAN, (Object)GdataDefinitions.col_Cache_BeginTime, (Object)since));
        whereCondition.addCondition((Condition)new BinaryCondition(BinaryCondition.Op.LESS_THAN_OR_EQUAL_TO, (Object)GdataDefinitions.col_Cache_BeginTime, (Object)until));
        whereCondition.addCondition((Condition)new InCondition((Object)GdataDefinitions.col_Cache_UnitId, unitPermissions));
        if (this.databaseType == DatabaseType.Oracle && maxRowsLimit != 0) {
            whereCondition.addCondition((Condition)new CustomCondition((SqlObject)new CustomSql((Object)("ROWNUM <= " + maxRowsLimit))));
        }
        query.addCondition((Condition)whereCondition);
        String sql = ((SelectQuery)query.validate()).toString();
        if (maxRowsLimit != 0) {
            StringBuilder limitBuilder = new StringBuilder();
            switch (this.databaseType) {
                case MSSQL: {
                    limitBuilder.append("SELECT TOP ");
                    limitBuilder.append(maxRowsLimit);
                    limitBuilder.append(sql.substring(6));
                    sql = limitBuilder.toString();
                    break;
                }
                case MySQL: {
                    limitBuilder.append(sql);
                    limitBuilder.append(" LIMIT ");
                    limitBuilder.append(maxRowsLimit);
                    sql = limitBuilder.toString();
                }
            }
        }
        return sql;
    }

    private String generateHistorySqlForReplay(long since, long until, int maxRowsLimit) {
        SelectQuery query = new SelectQuery(true);
        query.addColumns(new Column[]{GdataDefinitions.col_History_UnitId, GdataDefinitions.col_History_BeginTime, GdataDefinitions.col_History_RmcRec, GdataDefinitions.col_History_GgaRec, GdataDefinitions.col_History_AreaId, GdataDefinitions.col_History_Trusted, GdataDefinitions.col_History_LongMsec, GdataDefinitions.col_History_LatMsec});
        query.addJoin(SelectQuery.JoinType.LEFT_OUTER, (Table)GdataDefinitions.tbl_HistoryHelper, (Table)GdataDefinitions.tbl_History, (Column)GdataDefinitions.col_HistoryHelper_Id, (Column)GdataDefinitions.col_History_Id);
        ComboCondition whereCondition = new ComboCondition(ComboCondition.Op.AND);
        whereCondition.addCondition((Condition)new BinaryCondition(BinaryCondition.Op.LESS_THAN_OR_EQUAL_TO, (Object)GdataDefinitions.col_HistoryHelper_DayStamp, (Object)(until / 86400000L)));
        whereCondition.addCondition((Condition)new BinaryCondition(BinaryCondition.Op.GREATER_THAN_OR_EQUAL_TO, (Object)GdataDefinitions.col_HistoryHelper_DayStamp, (Object)(since / 86400000L)));
        whereCondition.addCondition((Condition)new BinaryCondition(BinaryCondition.Op.LESS_THAN, (Object)GdataDefinitions.col_History_BeginTime, (Object)until));
        whereCondition.addCondition((Condition)new BinaryCondition(BinaryCondition.Op.GREATER_THAN, (Object)GdataDefinitions.col_History_EndTime, (Object)since));
        if (this.databaseType == DatabaseType.Oracle && maxRowsLimit != 0) {
            whereCondition.addCondition((Condition)new CustomCondition((SqlObject)new CustomSql((Object)("ROWNUM <= " + maxRowsLimit))));
        }
        query.addCondition((Condition)whereCondition);
        query.addOrdering((Column)GdataDefinitions.col_History_BeginTime, OrderObject.Dir.ASCENDING);
        String sql = ((SelectQuery)query.validate()).toString();
        if (maxRowsLimit != 0) {
            StringBuilder limitBuilder = new StringBuilder();
            switch (this.databaseType) {
                case MSSQL: {
                    limitBuilder.append("SELECT DISTINCT TOP ");
                    limitBuilder.append(maxRowsLimit);
                    limitBuilder.append(sql.substring(15));
                    sql = limitBuilder.toString();
                    break;
                }
                case MySQL: {
                    limitBuilder.append(sql);
                    limitBuilder.append(" LIMIT ");
                    limitBuilder.append(maxRowsLimit);
                    sql = limitBuilder.toString();
                }
            }
        }
        return sql;
    }

    private String generateCacheInitialSqlForReplay(long since, int maxRowsLimit, HashSet<Long> unitPermissions) {
        SelectQuery query = new SelectQuery();
        query.addColumns(new Column[]{GdataDefinitions.col_Cache_UnitId, GdataDefinitions.col_Cache_BeginTime, GdataDefinitions.col_Cache_RmcRec, GdataDefinitions.col_Cache_GgaRec, GdataDefinitions.col_Cache_AreaId, GdataDefinitions.col_Cache_Trusted, GdataDefinitions.col_Cache_LongMsec, GdataDefinitions.col_Cache_LatMsec});
        ComboCondition whereCondition = new ComboCondition(ComboCondition.Op.AND);
        whereCondition.addCondition((Condition)new BinaryCondition(BinaryCondition.Op.LESS_THAN_OR_EQUAL_TO, (Object)GdataDefinitions.col_Cache_BeginTime, (Object)since));
        whereCondition.addCondition((Condition)new InCondition((Object)GdataDefinitions.col_Cache_UnitId, unitPermissions));
        if (this.databaseType == DatabaseType.Oracle && maxRowsLimit != 0) {
            whereCondition.addCondition((Condition)new CustomCondition((SqlObject)new CustomSql((Object)("ROWNUM <= " + maxRowsLimit))));
        }
        query.addCondition((Condition)whereCondition);
        String sql = ((SelectQuery)query.validate()).toString();
        if (maxRowsLimit != 0) {
            StringBuilder limitBuilder = new StringBuilder();
            switch (this.databaseType) {
                case MSSQL: {
                    limitBuilder.append("SELECT TOP ");
                    limitBuilder.append(maxRowsLimit);
                    limitBuilder.append(sql.substring(6));
                    sql = limitBuilder.toString();
                    break;
                }
                case MySQL: {
                    limitBuilder.append(sql);
                    limitBuilder.append(" LIMIT ");
                    limitBuilder.append(maxRowsLimit);
                    sql = limitBuilder.toString();
                }
            }
        }
        return sql;
    }
}

