/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.web.data.fastlanereader.base;

import de.proveo.util.database.DatabaseType;
import de.proveo.util.database.DatabaseUtil;
import de.proveo.util.service.ServiceFactory;
import de.proveo.wwt.logic.ejb.general.config.ConfigurationClient;
import de.proveo.wwt.logic.web.data.query.definitions.GdataDefinitions;
import de.proveo.wwt.logic.web.data.query.definitions.KeepaliveDefinitions;
import de.proveo.wwt.logic.web.data.query.definitions.MeasurementDefinitions;
import de.proveo.wwt.logic.web.data.query.definitions.NotifyDefinitions;
import de.proveo.wwt.logic.web.data.query.definitions.ScanmanMsgDefinitions;
import de.proveo.wwt.logic.web.data.query.definitions.StateDefinitions;
import de.proveo.wwt.logic.web.data.query.definitions.StateSummaryDefinitions;
import de.proveo.wwt.logic.web.data.query.definitions.UseDefinitions;
import de.proveo.wwt.logic.web.data.query.interfaces.IReportTableDefinitions;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FastLaneBase {
    protected static final int DEFAULT_FETCH_SIZE = 2500;
    protected int currentFetchSize;
    private static final Log log = LogFactory.getLog(FastLaneBase.class);
    private DataSource dataSource;
    protected DatabaseType databaseType;
    protected static final long TIMESTAMP_ERROR = -1L;
    protected static HashMap<HistoryTable, IReportTableDefinitions> tableMap = new HashMap();

    public DatabaseType getDatabaseType() {
        return this.databaseType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FastLaneBase() {
        Connection connection = null;
        try {
            this.dataSource = ServiceFactory.getInstance().getDataSource();
            connection = this.dataSource.getConnection();
            this.databaseType = DatabaseUtil.getDatabaseType((Connection)connection);
        }
        catch (NamingException e) {
            log.error((Object)"runs into: ", (Throwable)e);
        }
        catch (SQLException e) {
            log.error((Object)"runs into: ", (Throwable)e);
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException e) {
                log.error((Object)"runs into: ", (Throwable)e);
            }
        }
    }

    protected Connection getConnection() throws SQLException {
        return this.dataSource.getConnection();
    }

    protected Statement createReadOnlyStatement(Connection connection) throws SQLException {
        Statement statement = connection.createStatement(1004, 1007);
        this.setDefaultStatementSettings(statement);
        return statement;
    }

    protected Statement createReadOnlyForwardOnlyStatement(Connection connection) throws SQLException {
        Statement statement = connection.createStatement(1003, 1007);
        this.setDefaultStatementSettings(statement);
        return statement;
    }

    protected Statement createStatement(Connection connection) throws SQLException {
        Statement statement = connection.createStatement(1005, 1008);
        this.setDefaultStatementSettings(statement);
        return statement;
    }

    private void setDefaultStatementSettings(Statement statement) throws SQLException {
        ConfigurationClient configurationClient = new ConfigurationClient();
        try {
            this.currentFetchSize = Integer.parseInt(configurationClient.getParameter("fetchSize", String.valueOf(2500)));
        }
        catch (Exception e) {
            log.warn((Object)("Error retrieving fetch size for FastLaneReader. Defaulting to " + String.valueOf(2500)));
            this.currentFetchSize = 2500;
        }
        statement.setFetchSize(this.currentFetchSize);
    }

    protected static final String appendStrings(String ... strings) {
        if (strings == null || strings.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i != strings.length; ++i) {
            if (strings[i] == null) continue;
            sb.append(strings[i]);
        }
        return sb.toString();
    }

    protected static final String appendStringsToLowerCase(String ... strings) {
        return FastLaneBase.appendStrings(strings).toLowerCase();
    }

    static {
        tableMap.put(HistoryTable.GDATA_HISTORY, new GdataDefinitions());
        tableMap.put(HistoryTable.STATE_HISTORY, new StateDefinitions());
        tableMap.put(HistoryTable.NOTIFY_HISTORY, new NotifyDefinitions());
        tableMap.put(HistoryTable.USE_HISTORY, new UseDefinitions());
        tableMap.put(HistoryTable.KEEPALIVE_HISTORY, new KeepaliveDefinitions());
        tableMap.put(HistoryTable.STATE_SUMMARY, new StateSummaryDefinitions());
        tableMap.put(HistoryTable.SCANMAN_MSG_HISTORY, new ScanmanMsgDefinitions());
        tableMap.put(HistoryTable.MEASUREMENT_HISTORY, new MeasurementDefinitions());
    }

    public static enum HistoryTable {
        GDATA_HISTORY,
        STATE_HISTORY,
        NOTIFY_HISTORY,
        USE_HISTORY,
        KEEPALIVE_HISTORY,
        STATE_SUMMARY,
        SCANMAN_MSG_HISTORY,
        MEASUREMENT_HISTORY;

    }
}

