/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.web.data.fastlanereader;

import de.proveo.wwt.datamodel.unit.model.UnitModel;
import de.proveo.wwt.logic.app.util.Stopwatch;
import de.proveo.wwt.logic.web.common.dto.UnitDTO;
import de.proveo.wwt.logic.web.data.fastlanereader.base.FastLaneReader;
import de.proveo.wwt.logic.web.hierarchicalData.unitTree.UnitTreeComparator;
import de.proveo.wwt.logic.web.hierarchicalData.unitTree.dto.UnitNodeType;
import de.proveo.wwt.logic.web.hierarchicalData.unitTree.dto.UnitTreeNode;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UnitTreeFastLaneReader
extends FastLaneReader {
    private static final Log log = LogFactory.getLog(UnitTreeFastLaneReader.class);
    protected static final String SQL_UNIT_INFORMATION = "SELECT um.deleted AS DELETED, um.serial_number AS SERIAL_NUMBER, um.device_type AS DEVICE_TYPE, um.imei AS IMEI, um.airportmap_visible AS AIRPORTMAP_VISIBLE, um.IS_BASIC AS IS_BASIC, um.unit_id AS UNIT_ID, um.body_number AS BODY_NUMBER, um.registration_number AS REGISTRATION_NUMBER, um.brand AS BRAND, um.model_type AS MODEL_TYPE, um.deleted AS DELETED, ui.name AS NAME, ui.image_name AS IMAGE_NAME, uti.name AS TYPE_NAME, uti.image_name AS TYPE_IMAGE_NAME, uti.img_type_id AS img_type_id, itd.name AS img_type_name FROM unit_model um LEFT JOIN unit_identity ui ON um.unit_id = ui.unit_id LEFT JOIN unit_typeidentity uti ON um.unit_type_id = uti.id LEFT JOIN img_type_defn itd ON uti.img_type_id = itd.id";
    protected static final String SQL_ROOT_NODES = "SELECT um.unit_id AS unit_id FROM unit_model um LEFT JOIN unitmodel_x_unitmodel uxu ON um.unit_id = uxu.unit_id WHERE uxu.group_id IS NULL ORDER BY um.unit_id";
    protected static final String SQL_NON_ROOT_NODES = "SELECT um.unit_id AS unit_id, uxu.group_id AS group_id FROM unit_model um JOIN unitmodel_x_unitmodel uxu ON um.unit_id = uxu.unit_id";
    protected static final String SQL_UNIT_ID = "UNIT_ID";
    protected static final String SQL_GROUP_ID = "GROUP_ID";
    protected static final int ROOT_NODE_ID = 1;

    public UnitTreeNode buildUnitTree(boolean hideDeleted, boolean airportVisibleOnly) {
        log.debug((Object)"buildUnitTree()");
        Stopwatch stopwatch = new Stopwatch(UnitTreeFastLaneReader.class, "buildUnitTree");
        stopwatch.start("Overall");
        HashMap<Long, UnitDTO> units = this.getUnits(hideDeleted, airportVisibleOnly);
        UnitTreeNode treeRoot = null;
        if (units != null && !units.isEmpty()) {
            treeRoot = new UnitTreeNode();
            List<Long> rootNodes = this.getRootNodes();
            HashMap<Long, List<Long>> nonRootNodes = this.getNonRootNodes();
            int rootNodeCount = rootNodes.size();
            for (int rootIdx = 0; rootIdx != rootNodeCount; ++rootIdx) {
                long rootId = rootNodes.get(rootIdx);
                UnitDTO unitDto = units.get(rootId);
                if (unitDto == null) continue;
                UnitTreeNode rootNode = UnitTreeFastLaneReader.buildUnitTreeNode(unitDto);
                treeRoot.addChild(rootNode);
                this.addChildren(rootNode, nonRootNodes, units);
            }
            Collections.sort(treeRoot.getChildren(), new UnitTreeComparator());
        }
        stopwatch.stop("Overall", true);
        return treeRoot;
    }

    protected void addChildren(UnitTreeNode parentNode, HashMap<Long, List<Long>> nodeMap, HashMap<Long, UnitDTO> dtoMap) {
        List<Long> children = nodeMap.get(((UnitDTO)parentNode.getData()).getUnitId());
        if (children != null) {
            int childrenCount = children.size();
            for (int i = 0; i != childrenCount; ++i) {
                UnitDTO unitDto = dtoMap.get(children.get(i));
                if (unitDto == null) continue;
                UnitTreeNode currentNode = UnitTreeFastLaneReader.buildUnitTreeNode(unitDto);
                parentNode.addChild(currentNode);
                this.addChildren(currentNode, nodeMap, dtoMap);
            }
            Collections.sort(parentNode.getChildren(), new UnitTreeComparator());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<Long> getRootNodes() {
        log.debug((Object)"getRootNodes()");
        Stopwatch stopwatch = new Stopwatch(UnitTreeFastLaneReader.class, "getRootNodes");
        stopwatch.start("Overall");
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        ArrayList<Long> rootNodes = new ArrayList<Long>();
        try {
            connection = this.getConnection();
            statement = this.createReadOnlyForwardOnlyStatement(connection);
            log.debug((Object)"executed SQL: SELECT um.unit_id AS unit_id FROM unit_model um LEFT JOIN unitmodel_x_unitmodel uxu ON um.unit_id = uxu.unit_id WHERE uxu.group_id IS NULL ORDER BY um.unit_id");
            resultSet = statement.executeQuery(SQL_ROOT_NODES);
            int unitIdColumnIdx = resultSet.findColumn(SQL_UNIT_ID);
            while (resultSet.next()) {
                rootNodes.add(resultSet.getLong(unitIdColumnIdx));
            }
        }
        catch (SQLException e) {
            log.error((Object)"Runs into: ", (Throwable)e);
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (SQLException e) {
                log.error((Object)"runs into: ", (Throwable)e);
            }
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException e) {
                log.error((Object)"runs into: ", (Throwable)e);
            }
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException e) {
                log.error((Object)"runs into: ", (Throwable)e);
            }
        }
        stopwatch.stop("Overall", true);
        return rootNodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HashMap<Long, List<Long>> getNonRootNodes() {
        log.debug((Object)"getNonRootNodes()");
        Stopwatch stopwatch = new Stopwatch(UnitTreeFastLaneReader.class, "getNonRootNodes");
        stopwatch.start("Overall");
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        HashMap<Long, List<Long>> nonRootNodes = new HashMap<Long, List<Long>>();
        try {
            connection = this.getConnection();
            statement = this.createReadOnlyForwardOnlyStatement(connection);
            log.debug((Object)"executed SQL: SELECT um.unit_id AS unit_id, uxu.group_id AS group_id FROM unit_model um JOIN unitmodel_x_unitmodel uxu ON um.unit_id = uxu.unit_id");
            resultSet = statement.executeQuery(SQL_NON_ROOT_NODES);
            int unitIdColumnIdx = resultSet.findColumn(SQL_UNIT_ID);
            int groupIdColumnIdx = resultSet.findColumn(SQL_GROUP_ID);
            while (resultSet.next()) {
                long groupId = resultSet.getLong(groupIdColumnIdx);
                long unitId = resultSet.getLong(unitIdColumnIdx);
                List<Long> currentList = nonRootNodes.get(groupId);
                if (currentList == null) {
                    currentList = new ArrayList<Long>();
                    currentList.add(unitId);
                    nonRootNodes.put(groupId, currentList);
                    continue;
                }
                currentList.add(unitId);
            }
        }
        catch (SQLException e) {
            log.error((Object)"Runs into: ", (Throwable)e);
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (SQLException e) {
                log.error((Object)"runs into: ", (Throwable)e);
            }
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException e) {
                log.error((Object)"runs into: ", (Throwable)e);
            }
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException e) {
                log.error((Object)"runs into: ", (Throwable)e);
            }
        }
        stopwatch.stop("Overall", true);
        return nonRootNodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HashMap<Long, UnitDTO> getUnits(boolean hideDeleted, boolean airportMapFiltered) {
        log.debug((Object)"getUnits()");
        Stopwatch stopwatch = new Stopwatch(UnitTreeFastLaneReader.class, "getUnits");
        stopwatch.start("Overall");
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        HashMap<Long, UnitDTO> result = new HashMap<Long, UnitDTO>();
        try {
            connection = this.getConnection();
            statement = this.createReadOnlyForwardOnlyStatement(connection);
            log.debug((Object)"executed SQL: SELECT um.deleted AS DELETED, um.serial_number AS SERIAL_NUMBER, um.device_type AS DEVICE_TYPE, um.imei AS IMEI, um.airportmap_visible AS AIRPORTMAP_VISIBLE, um.IS_BASIC AS IS_BASIC, um.unit_id AS UNIT_ID, um.body_number AS BODY_NUMBER, um.registration_number AS REGISTRATION_NUMBER, um.brand AS BRAND, um.model_type AS MODEL_TYPE, um.deleted AS DELETED, ui.name AS NAME, ui.image_name AS IMAGE_NAME, uti.name AS TYPE_NAME, uti.image_name AS TYPE_IMAGE_NAME, uti.img_type_id AS img_type_id, itd.name AS img_type_name FROM unit_model um LEFT JOIN unit_identity ui ON um.unit_id = ui.unit_id LEFT JOIN unit_typeidentity uti ON um.unit_type_id = uti.id LEFT JOIN img_type_defn itd ON uti.img_type_id = itd.id");
            resultSet = statement.executeQuery(SQL_UNIT_INFORMATION);
            while (resultSet.next()) {
                boolean deleted = resultSet.getBoolean("DELETED");
                boolean airportMapVisible = resultSet.getBoolean("AIRPORTMAP_VISIBLE");
                boolean basic = resultSet.getBoolean("IS_BASIC");
                if (hideDeleted && deleted || airportMapFiltered && basic && !airportMapVisible) continue;
                UnitDTO unitDTO = this.buildUnitDTO(resultSet);
                UnitModel umv = unitDTO.getUnitModel();
                umv.setAirportmapVisible(airportMapVisible);
                umv.setBasic(basic);
                result.put(umv.getUnitId(), unitDTO);
            }
        }
        catch (SQLException e) {
            log.error((Object)"Runs into: ", (Throwable)e);
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (SQLException e) {
                log.error((Object)"runs into: ", (Throwable)e);
            }
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException e) {
                log.error((Object)"runs into: ", (Throwable)e);
            }
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException e) {
                log.error((Object)"runs into: ", (Throwable)e);
            }
        }
        stopwatch.stop("Overall", true);
        return result;
    }

    protected static UnitTreeNode buildUnitTreeNode(UnitDTO unitDto) {
        return new UnitTreeNode(unitDto.getUnitModel(), unitDto.getUnitIdentity(), unitDto.getUnitTypeIdentity());
    }

    public void test() {
        this._deleteGroup(10240);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _removeAllUnitGroups() {
        Connection connection = null;
        Statement statement = null;
        Statement preparedStatement = null;
        try {
            connection = this.getConnection();
            statement = this.createStatement(connection);
            statement.executeUpdate("TRUNCATE unit_model_x_unit_group");
            statement.executeUpdate("TRUNCATE unit_group");
            preparedStatement = connection.prepareStatement("INSERT INTO unit_group(id, name, lft, rgt) VALUES(?, ?, ?, ?)");
            preparedStatement.setInt(1, 1);
            preparedStatement.setString(2, "Root");
            preparedStatement.setInt(3, 1);
            preparedStatement.setInt(4, 2);
            preparedStatement.executeUpdate();
        }
        catch (SQLException e) {
            log.error((Object)"Runs into: ", (Throwable)e);
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException e) {
                log.error((Object)"runs into: ", (Throwable)e);
            }
            try {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
            }
            catch (SQLException e) {
                log.error((Object)"runs into: ", (Throwable)e);
            }
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException e) {
                log.error((Object)"runs into: ", (Throwable)e);
            }
        }
    }

    public void _initializeTree() {
        UnitTreeNode root = this.buildUnitTree(false, false);
        List<UnitTreeNode> allGroups = root.getSubnodes(UnitNodeType.Group);
        for (UnitTreeNode node : allGroups) {
            Long unitId = ((UnitDTO)((UnitTreeNode)node.getParent()).getData()).getUnitId();
            int parentGroupId = unitId == null ? 1 : unitId.intValue();
            int groupId = ((UnitDTO)node.getData()).getUnitId().intValue();
            this._createGroup(parentGroupId, groupId, ((UnitDTO)node.getData()).getUnitName());
            for (UnitTreeNode childNode : node.getChildren()) {
                if (!childNode.isBasic()) continue;
                this._addUnitToGroup(groupId, ((UnitDTO)childNode.getData()).getUnitId());
            }
        }
        this._addOrphanUnitsToRoot();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _addOrphanUnitsToRoot() {
        Statement statement = null;
        Connection connection = null;
        try {
            connection = this.getConnection();
            statement = this.createStatement(connection);
            statement.executeUpdate("INSERT INTO unit_model_x_unit_group(unit_id, unit_group_id) SELECT um.unit_id, 1 FROM unit_model um WHERE um.unit_id NOT IN(SELECT DISTINCT umxug.unit_id FROM unit_model_x_unit_group umxug) AND um.is_basic = 1;");
        }
        catch (SQLException e) {
            log.error((Object)"Runs into: ", (Throwable)e);
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException e) {
                log.error((Object)"runs into: ", (Throwable)e);
            }
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException e) {
                log.error((Object)"runs into: ", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _createGroup(int parentGroupId, int groupId, String name) {
        PreparedStatement preparedStatement = null;
        Statement updateStatement = null;
        Connection connection = null;
        try {
            connection = this.getConnection();
            preparedStatement = connection.prepareStatement("SELECT rgt FROM unit_group WHERE id = ?");
            preparedStatement.setInt(1, parentGroupId);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                int right = resultSet.getInt(1);
                updateStatement = connection.prepareStatement("UPDATE unit_group SET rgt = rgt + 2 WHERE rgt >= ?");
                updateStatement.setInt(1, right);
                updateStatement.executeUpdate();
                updateStatement = connection.prepareStatement("UPDATE unit_group SET lft = lft + 2 WHERE lft >= ?");
                updateStatement.setInt(1, right);
                updateStatement.executeUpdate();
                updateStatement = connection.prepareStatement("INSERT INTO unit_group(id, name, lft, rgt) VALUES(?, ?, ?, ? + 1);");
                updateStatement.setInt(1, groupId);
                updateStatement.setString(2, name);
                updateStatement.setInt(3, right);
                updateStatement.setInt(4, right);
                updateStatement.executeUpdate();
            }
        }
        catch (SQLException e) {
            log.error((Object)"Runs into: ", (Throwable)e);
        }
        finally {
            try {
                if (updateStatement != null) {
                    updateStatement.close();
                }
            }
            catch (SQLException e) {
                log.error((Object)"runs into: ", (Throwable)e);
            }
            try {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
            }
            catch (SQLException e) {
                log.error((Object)"runs into: ", (Throwable)e);
            }
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException e) {
                log.error((Object)"runs into: ", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _deleteGroup(int groupId) {
        PreparedStatement preparedStatement = null;
        Connection connection = null;
        try {
            connection = this.getConnection();
            preparedStatement = connection.prepareStatement("UPDATE unit_model_x_unit_group SET unit_group_id = ? WHERE unit_group_id IN (SELECT ug.id FROM unit_group ug, unit_group ug2 WHERE ug2.id = ? AND ug.rgt <= ug2.rgt AND ug.lft >= ug2.lft) AND unit_id NOT IN (SELECT * FROM (SELECT umxug.unit_id FROM unit_model_x_unit_group umxug WHERE unit_group_id = ?) x)");
            preparedStatement.setInt(1, 1);
            preparedStatement.setInt(2, groupId);
            preparedStatement.setInt(3, 1);
            preparedStatement.executeUpdate();
            preparedStatement = connection.prepareStatement("DELETE FROM unit_model_x_unit_group WHERE unit_group_id IN (SELECT ug.id FROM unit_group ug, unit_group ug2 WHERE ug2.id = ? AND ug.rgt <= ug2.rgt AND ug.lft >= ug2.lft)");
            preparedStatement.setInt(1, groupId);
            preparedStatement.executeUpdate();
            preparedStatement = connection.prepareStatement("SELECT lft, rgt FROM unit_group WHERE id = ?");
            preparedStatement.setInt(1, groupId);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                int left = resultSet.getInt(1);
                int right = resultSet.getInt(2);
                int width = right - left + 1;
                preparedStatement = connection.prepareStatement("DELETE FROM unit_group WHERE lft BETWEEN ? AND ?");
                preparedStatement.setInt(1, left);
                preparedStatement.setInt(2, right);
                preparedStatement.executeUpdate();
                preparedStatement = connection.prepareStatement("UPDATE unit_group SET rgt = rgt - ? WHERE rgt > ?");
                preparedStatement.setInt(1, width);
                preparedStatement.setInt(2, right);
                preparedStatement.executeUpdate();
                preparedStatement = connection.prepareStatement("UPDATE unit_group SET lft = lft - ? WHERE lft > ?");
                preparedStatement.setInt(1, width);
                preparedStatement.setInt(2, right);
                preparedStatement.executeUpdate();
            }
        }
        catch (SQLException e) {
            log.error((Object)"Runs into: ", (Throwable)e);
        }
        finally {
            try {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
            }
            catch (SQLException e) {
                log.error((Object)"runs into: ", (Throwable)e);
            }
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException e) {
                log.error((Object)"runs into: ", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _addUnitToGroup(int groupId, long unitId) {
        PreparedStatement preparedStatement = null;
        Connection connection = null;
        try {
            connection = this.getConnection();
            preparedStatement = connection.prepareStatement("INSERT INTO unit_model_x_unit_group(unit_id, unit_group_id) VALUES (?, ?)");
            preparedStatement.setLong(1, unitId);
            preparedStatement.setInt(2, groupId);
            preparedStatement.executeUpdate();
        }
        catch (SQLException e) {
            log.error((Object)"Runs into: ", (Throwable)e);
        }
        finally {
            try {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
            }
            catch (SQLException e) {
                log.error((Object)"runs into: ", (Throwable)e);
            }
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException e) {
                log.error((Object)"runs into: ", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _removeUnitFromGroup(int groupId, long unitId) {
        PreparedStatement preparedStatement = null;
        Connection connection = null;
        try {
            connection = this.getConnection();
            preparedStatement = connection.prepareStatement("SELECT COUNT(*) > 1 FROM unit_model_x_unit_group umxug WHERE unit_id = ?");
            preparedStatement.setLong(1, unitId);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                if (resultSet.getInt(1) == 1) {
                    preparedStatement = connection.prepareStatement("DELETE FROM unit_model_x_unit_group WHERE unit_group_id = ? AND unit_id = ?");
                    preparedStatement.setInt(1, groupId);
                    preparedStatement.setLong(2, unitId);
                    preparedStatement.executeUpdate();
                } else {
                    preparedStatement = connection.prepareStatement("UPDATE unit_model_x_unit_group SET unit_group_id = 1 WHERE unit_group_id = ? AND unit_id = ?");
                    preparedStatement.setInt(1, groupId);
                    preparedStatement.setLong(2, unitId);
                    preparedStatement.executeUpdate();
                }
            }
        }
        catch (SQLException e) {
            log.error((Object)"Runs into: ", (Throwable)e);
        }
        finally {
            try {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
            }
            catch (SQLException e) {
                log.error((Object)"runs into: ", (Throwable)e);
            }
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException e) {
                log.error((Object)"runs into: ", (Throwable)e);
            }
        }
    }

    public UnitTreeNode _buildUnitTree(boolean hideDeleted, boolean airportVisibleOnly) {
        log.debug((Object)"buildUnitTree()");
        Stopwatch stopwatch = new Stopwatch(UnitTreeFastLaneReader.class, "buildUnitTree");
        stopwatch.start("Overall");
        UnitTreeNode treeRoot = this._buildTreeStructure();
        HashMap<Long, UnitDTO> units = this.getUnits(hideDeleted, airportVisibleOnly);
        if (units != null && units.size() != 0) {
            Collections.sort(treeRoot.getChildren(), new UnitTreeComparator());
        }
        stopwatch.stop("Overall", true);
        return treeRoot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UnitTreeNode _buildTreeStructure() {
        Statement preparedStatement = null;
        Statement statement = null;
        Connection connection = null;
        UnitTreeNode treeRoot = new UnitTreeNode();
        HashMap<Integer, UnitTreeNode> nodeMap = new HashMap<Integer, UnitTreeNode>();
        nodeMap.put(1, treeRoot);
        try {
            connection = this.getConnection();
            statement = this.createStatement(connection);
            ResultSet resultSet = statement.executeQuery("SELECT node.id, node.name, (SELECT ug.id FROM unit_group ug WHERE ug.lft < node.lft AND ug.rgt > node.rgt ORDER BY ug.rgt - node.rgt ASC LIMIT 1) AS parent FROM unit_group node WHERE node.id <> 1 ORDER BY node.rgt - node.lft DESC");
            while (resultSet.next()) {
                int groupId = resultSet.getInt(1);
                String groupName = resultSet.getString(2);
                int parentId = resultSet.getInt(3);
                UnitTreeNode node = new UnitTreeNode();
            }
        }
        catch (SQLException e) {
            log.error((Object)"Runs into: ", (Throwable)e);
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException e) {
                log.error((Object)"runs into: ", (Throwable)e);
            }
            try {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
            }
            catch (SQLException e) {
                log.error((Object)"runs into: ", (Throwable)e);
            }
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException e) {
                log.error((Object)"runs into: ", (Throwable)e);
            }
        }
        return treeRoot;
    }
}

