/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.web.data.fastlanereader;

import de.proveo.wwt.datamodel.role.Role;
import de.proveo.wwt.logic.app.util.Stopwatch;
import de.proveo.wwt.logic.web.data.fastlanereader.base.FastLaneReader;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MasterDataFastLaneReader
extends FastLaneReader {
    private static final Log log = LogFactory.getLog(MasterDataFastLaneReader.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Role> getAllRolesForUser(String userName) {
        log.debug((Object)"getAllRolesForUserFastLaneRead called");
        Stopwatch stopwatch = new Stopwatch(FastLaneReader.class, "getAllRolesForUserFastLaneRead");
        stopwatch.start("Overall");
        ArrayList<Role> roleSummary = new ArrayList<Role>();
        Connection connection = null;
        Statement statement = null;
        try {
            stopwatch.start("Database access");
            connection = this.getConnection();
            statement = this.createReadOnlyForwardOnlyStatement(connection);
            String sqlUsername = MasterDataFastLaneReader.appendStrings("'", userName, "'");
            String sql = MasterDataFastLaneReader.generateAllRolesForUserSql(sqlUsername);
            log.debug((Object)("Executed SQL: " + sql));
            ResultSet resultSet = statement.executeQuery(sql);
            stopwatch.stop("Database access", true);
            stopwatch.start("Build DTO");
            while (resultSet.next()) {
                Role value = new Role();
                value.setRoleName(resultSet.getString("ROLE_NAME"));
                roleSummary.add(value);
            }
            stopwatch.stop("Build DTO", true, roleSummary.size());
        }
        catch (SQLException e) {
            log.error((Object)"runs into: ", (Throwable)e);
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException e) {
                log.error((Object)"runs into: ", (Throwable)e);
            }
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException e) {
                log.error((Object)"runs into: ", (Throwable)e);
            }
        }
        stopwatch.stop("Overall", true);
        return roleSummary;
    }

    private static String generateAllRolesForUserSql(String username) {
        String sql = MasterDataFastLaneReader.appendStrings("SELECT r.ROLE_NAME FROM role r WHERE r.id IN (SELECT id_role FROM account_x_role WHERE id_account IN (SELECT id FROM account WHERE account.username = ", username, ")) OR r.id IN (SELECT id_role FROM groupident_x_role WHERE id_groupident IN (SELECT id_groupident FROM account_x_groupident WHERE id_account IN (SELECT id FROM account WHERE account.username = ", username, "))) OR r.id IN (SELECT id_sectionrole FROM role_x_role WHERE id_role IN (SELECT id_role FROM groupident_x_role WHERE id_groupident IN (SELECT id_groupident FROM account_x_groupident WHERE id_account IN (SELECT id FROM account WHERE account.username = ", username, ")))) OR r.id IN (SELECT id_sectionrole FROM role_x_role WHERE id_role IN (SELECT id_role FROM account_x_role WHERE id_account IN (SELECT id FROM account WHERE account.username = ", username, ")))");
        return sql.toLowerCase();
    }
}

