/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.web.currentData;

import de.proveo.ejb.annotations.tags.Business;
import de.proveo.ejb.annotations.tags.JndiLocalBinding;
import de.proveo.ejb.annotations.tags.JndiRemoteBinding;
import de.proveo.wwt.datamodel.area.Area;
import de.proveo.wwt.datamodel.geo.GdataCache;
import de.proveo.wwt.datamodel.keepalive.KeepAliveCache;
import de.proveo.wwt.datamodel.scanmanmsg.ScanmanMsgCache;
import de.proveo.wwt.datamodel.state.StateCache;
import de.proveo.wwt.datamodel.unit.model.UnitModel;
import de.proveo.wwt.datamodel.use.UseCache;
import de.proveo.wwt.logic.app.util.Stopwatch;
import de.proveo.wwt.logic.ejb.dataIn.notify.NotifyFacadeLocal;
import de.proveo.wwt.logic.ejb.dataIn.scanmanmsg.ScanmanMsgFacadeLocal;
import de.proveo.wwt.logic.ejb.dataIn.use.UseOutFacadeLocal;
import de.proveo.wwt.logic.ejb.general.area.AreaInFacadeLocal;
import de.proveo.wwt.logic.ejb.general.config.ConfigurationLocal;
import de.proveo.wwt.logic.ejb.general.config.ConfigurationParameterNotFoundException;
import de.proveo.wwt.logic.ejb.general.unit.facade.UnitFacadeLocal;
import de.proveo.wwt.logic.ejb.geo.GdataFacadeLocal;
import de.proveo.wwt.logic.ejb.keepalive.KeepAliveOutFacadeLocal;
import de.proveo.wwt.logic.ejb.state.CurrentStateFacadeLocal;
import de.proveo.wwt.logic.web.common.dataSelection.ReportSelectionDTO;
import de.proveo.wwt.logic.web.common.dataSelection.UnitReportSelectionDTO;
import de.proveo.wwt.logic.web.common.dataSelection.filter.AbstractDataFilter;
import de.proveo.wwt.logic.web.common.dataSelection.filter.IDataFilter;
import de.proveo.wwt.logic.web.common.dto.DTOFactory;
import de.proveo.wwt.logic.web.common.dto.DTOListBase;
import de.proveo.wwt.logic.web.common.dto.DTOListFactory;
import de.proveo.wwt.logic.web.common.dto.ReportDTOListBase;
import de.proveo.wwt.logic.web.common.dto.UnitContainerListBase;
import de.proveo.wwt.logic.web.common.helper.UnitListFactory;
import de.proveo.wwt.logic.web.currentData.CurrentDataFacadeLocal;
import de.proveo.wwt.logic.web.currentData.CurrentDataFacadeRemote;
import de.proveo.wwt.logic.web.currentData.dto.CurrentAllDTO;
import de.proveo.wwt.logic.web.currentData.dto.InfomanReportDTO;
import de.proveo.wwt.logic.web.data.enumerations.ExtendedDTOData;
import de.proveo.wwt.logic.web.data.fastlanereader.report.GdataFastLaneReader;
import de.proveo.wwt.logic.web.data.fastlanereader.report.KeepAliveFastLaneReader;
import de.proveo.wwt.logic.web.data.fastlanereader.report.StateFastLaneReader;
import de.proveo.wwt.logic.web.data.fastlanereader.report.UseFastLaneReader;
import de.proveo.wwt.logic.web.historyData.dto.KeepAliveDTO;
import de.proveo.wwt.logic.web.historyData.dto.PositionDTO;
import de.proveo.wwt.logic.web.historyData.dto.StateDTO;
import de.proveo.wwt.logic.web.historyData.dto.StateDTOList;
import de.proveo.wwt.logic.web.historyData.dto.UseDTO;
import de.proveo.wwt.logic.web.security.PermissionCheckerLocal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.ejb.EJB;
import javax.ejb.Local;
import javax.ejb.Remote;
import javax.ejb.Stateless;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@Stateless(name="CurrentDataFacade")
@Remote(value={CurrentDataFacadeRemote.class})
@Local(value={CurrentDataFacadeLocal.class})
@JndiLocalBinding(localJndiBinding="rts/CurrentDataFacade")
@JndiRemoteBinding(remoteJndiBinding="rts/CurrentDataFacade")
public class CurrentDataFacadeBean
implements CurrentDataFacadeLocal,
CurrentDataFacadeRemote {
    private static final Log log = LogFactory.getLog(CurrentDataFacadeBean.class);
    private static final String CONFIG_PARAM_NAME_TIMEOUT = "infoman.keepalive.timeout";
    private static final int DEFAULT_KEEPALIVE_TIMEOUT = 10800000;
    @EJB
    private ConfigurationLocal configuration = null;
    @EJB
    private PermissionCheckerLocal permissionCheckerLocal = null;
    @EJB
    private KeepAliveOutFacadeLocal keepAliveFacade = null;
    @EJB
    private UnitFacadeLocal unitFacade = null;
    @EJB
    private NotifyFacadeLocal notifyFacade = null;
    @EJB
    private CurrentStateFacadeLocal currentStateFacade = null;
    @EJB
    private AreaInFacadeLocal areaFacade = null;
    @EJB
    private GdataFacadeLocal gdataFacade = null;
    @EJB
    private UseOutFacadeLocal useOutFacade = null;
    @EJB
    private ScanmanMsgFacadeLocal scanmanMsgFacade = null;
    private long timeout;

    @PostConstruct
    public void ejbCreate() {
        try {
            String timeOutStr = this.configuration.getParameter(CONFIG_PARAM_NAME_TIMEOUT);
            this.timeout = Long.parseLong(timeOutStr);
            this.timeout *= 60000L;
        }
        catch (ConfigurationParameterNotFoundException e) {
            log.error((Object)"configuration parameter 'infoman.keepalive.timeout' not found. User default.", (Throwable)e);
            this.timeout = 10800000L;
        }
        catch (NumberFormatException e) {
            log.error((Object)"wrong value for 'infoman.keepalive.timeout'. Runs into", (Throwable)e);
            this.timeout = 10800000L;
        }
    }

    @Override
    @Business(viewType="both")
    public StateDTOList getCurrentStateData(ReportSelectionDTO selectionDTO, int stateModelId, Integer stateFilterId, ExtendedDTOData[] extData) {
        Stopwatch stopwatch = new Stopwatch(CurrentDataFacadeBean.class, "getCurrentStateData");
        stopwatch.start("overallDuration");
        if (log.isDebugEnabled()) {
            log.debug((Object)"getCurrentStateData called ");
        }
        StateDTOList stateDtoList = DTOListFactory.buildStateDTOList(selectionDTO, stateModelId);
        stopwatch.start("Database access");
        new StateFastLaneReader().getCache((DTOListBase<StateDTO>)stateDtoList, selectionDTO, (Integer)stateModelId, stateFilterId, extData);
        stopwatch.stop("Database access", false, stateDtoList.size());
        this.permissionCheckerLocal.checkDTOList(stateDtoList);
        stopwatch.stop("overallDuration", false);
        stopwatch.logAll();
        return stateDtoList;
    }

    @Override
    @Business(viewType="both")
    public ReportDTOListBase<PositionDTO> getCurrentPositionData(ReportSelectionDTO selectionDTO, ExtendedDTOData[] extData) {
        Stopwatch stopwatch = new Stopwatch(CurrentDataFacadeBean.class, "Overall");
        stopwatch.start("Overall");
        if (log.isDebugEnabled()) {
            log.debug((Object)"getCurrentPositionData called ");
        }
        ReportDTOListBase<PositionDTO> list = DTOListFactory.buildReportDTOListBase(selectionDTO);
        new GdataFastLaneReader().getCache(list, selectionDTO, extData);
        this.permissionCheckerLocal.checkDTOList(list);
        stopwatch.stop("Overall", false);
        stopwatch.logAll();
        return list;
    }

    @Override
    @Business(viewType="both")
    public ReportDTOListBase<KeepAliveDTO> getCurrentKeepAliveData(ReportSelectionDTO selectionDTO, ExtendedDTOData[] extData) {
        ReportDTOListBase<KeepAliveDTO> list = DTOListFactory.buildReportDTOListBase(selectionDTO);
        if (log.isDebugEnabled()) {
            log.debug((Object)"getCurrentKeepAliveData called");
        }
        new KeepAliveFastLaneReader().getCache(list, selectionDTO, extData);
        for (KeepAliveDTO dto : list) {
            dto.setTimedOut(this.getKeepAliveTimedOut(dto));
        }
        this.permissionCheckerLocal.checkDTOList(list);
        return list;
    }

    @Override
    @Business(viewType="both")
    public UnitContainerListBase<InfomanReportDTO> getScanmanMessages(Long unitId) {
        InfomanReportDTO dto = null;
        KeepAliveCache keepAlive = null;
        UnitContainerListBase<InfomanReportDTO> list = DTOListFactory.buildUnitContainerListBase(null);
        ArrayList<ScanmanMsgCache> caches = new ArrayList();
        Collection<UnitModel> unitBasicModels = UnitListFactory.generateUnitModelList(unitId);
        for (UnitModel unitModel : unitBasicModels) {
            Long id = unitModel.getUnitId();
            keepAlive = this.keepAliveFacade.findByUnitId(id);
            caches = this.scanmanMsgFacade.findCacheByUnit(id);
            dto = DTOFactory.buildInfomanReportDTO(unitModel, keepAlive, caches);
            list.add(dto);
        }
        return list;
    }

    @Override
    @Business(viewType="both")
    public UnitContainerListBase<InfomanReportDTO> getCurrentScanmanMessageData(ReportSelectionDTO selectionDTO) {
        UnitContainerListBase<InfomanReportDTO> list = DTOListFactory.buildUnitContainerListBase(selectionDTO);
        InfomanReportDTO dto = null;
        KeepAliveCache keepAlive = null;
        ArrayList<ScanmanMsgCache> caches = new ArrayList();
        Collection<UnitModel> unitBasicModels = UnitListFactory.generateUnitModelList((UnitReportSelectionDTO)selectionDTO);
        for (UnitModel unitModel : unitBasicModels) {
            Long id = unitModel.getUnitId();
            keepAlive = this.keepAliveFacade.findByUnitId(id);
            caches = this.scanmanMsgFacade.findCacheByUnit(id);
            dto = DTOFactory.buildInfomanReportDTO(unitModel, keepAlive, caches);
            list.add(dto);
        }
        return list;
    }

    @Override
    @Business(viewType="both")
    public ReportDTOListBase<UseDTO> getCurrentUseData(ReportSelectionDTO selectionDTO, ExtendedDTOData[] extData) {
        ReportDTOListBase<UseDTO> list = DTOListFactory.buildReportDTOListBase(selectionDTO);
        new UseFastLaneReader().getCache(list, selectionDTO, extData);
        return list;
    }

    @Override
    @Deprecated
    @Business(viewType="both")
    public ReportDTOListBase<UseDTO> getCurrentUseData(Long unitId, boolean useGroupHistory, ExtendedDTOData[] extData) {
        ReportDTOListBase<UseDTO> list = null;
        list = DTOListFactory.buildReportDTOListBase(null);
        new UseFastLaneReader().getCache(list, unitId, useGroupHistory, extData);
        this.permissionCheckerLocal.checkDTOList(list);
        return list;
    }

    @Override
    @Deprecated
    @Business(viewType="both")
    public UnitContainerListBase<CurrentAllDTO> getAllCurrentData(Long unitID) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("getAllCurrentData with unitModelId=" + unitID));
        }
        UnitContainerListBase<CurrentAllDTO> list = null;
        Collection<UnitModel> unitBasicModels = UnitListFactory.generateUnitModelList(unitID, true);
        UnitContainerListBase<CurrentAllDTO> allDTOList = DTOListFactory.buildUnitContainerListBase(null);
        list = this.createCurrentAllDTOList(allDTOList, unitBasicModels, null);
        return list;
    }

    @Override
    @Business(viewType="both")
    public UnitContainerListBase<CurrentAllDTO> getAllCurrentData(ReportSelectionDTO selectionDTO) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"getAllCurrentData called");
        }
        UnitContainerListBase<CurrentAllDTO> list = null;
        Collection<UnitModel> unitBasicModels = UnitListFactory.generateUnitModelList((UnitReportSelectionDTO)selectionDTO);
        UnitContainerListBase<CurrentAllDTO> allDTOList = DTOListFactory.buildUnitContainerListBase(selectionDTO);
        list = this.createCurrentAllDTOList(allDTOList, unitBasicModels, selectionDTO.getDataFilters());
        return list;
    }

    private UnitContainerListBase<CurrentAllDTO> createCurrentAllDTOList(UnitContainerListBase<CurrentAllDTO> list, Collection<UnitModel> coll, List<IDataFilter> dataFilters) {
        CurrentAllDTO dto = null;
        Map<Integer, Area> areas = this.getAllAreas();
        if (coll.size() > 0) {
            for (UnitModel unitModel : coll) {
                GdataCache gdataCache;
                if (unitModel != null && unitModel.getDeleted()) continue;
                dto = DTOFactory.buildCurrentAllDTO(unitModel);
                KeepAliveCache keepAliveCache = unitModel.getKeepAliveCache();
                if (keepAliveCache != null) {
                    dto.setKeepAliveCache(keepAliveCache);
                    dto.setTimedOut(this.getKeepAliveTimedOut(keepAliveCache));
                }
                if ((gdataCache = unitModel.getCurrentGdataCache()) != null) {
                    Integer areaId = gdataCache.getAreaId();
                    Area currentArea = areaId != null ? areas.get(areaId) : null;
                    String areaName = "";
                    if (currentArea != null) {
                        areaName = currentArea.getArea();
                    }
                    dto.setPosition(gdataCache, areaName);
                }
                List<StateCache> stateCaches = unitModel.getCurrentStateCaches();
                for (StateCache stateCache : stateCaches) {
                    dto.setState(stateCache);
                }
                UseCache useCache = unitModel.getUseCache();
                if (useCache != null) {
                    dto.setUseCache(useCache);
                }
                if (!AbstractDataFilter.checkCurrentAllDTO(dto, dataFilters)) continue;
                list.add(dto);
            }
        }
        this.permissionCheckerLocal.checkDTOList(list);
        return list;
    }

    private Map<Integer, Area> getAllAreas() {
        HashMap<Integer, Area> areaMap = new HashMap<Integer, Area>();
        List<Area> areas = this.areaFacade.findAll();
        for (Area area : areas) {
            areaMap.put(area.getAreaId(), area);
        }
        return areaMap;
    }

    private boolean getKeepAliveTimedOut(KeepAliveCache kaCacheValue) {
        Long currentTime = new Date().getTime();
        Long keepAliveTime = kaCacheValue.getReceiveTime();
        return currentTime <= keepAliveTime + this.timeout;
    }

    private boolean getKeepAliveTimedOut(KeepAliveDTO dto) {
        return System.currentTimeMillis() > dto.getReceiveTime() + this.timeout;
    }
}

