/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.web.common.helper;

import de.proveo.wwt.datamodel.unit.model.UnitModel;
import de.proveo.wwt.logic.ejb.general.unit.facade.UnitFacadeLocal;
import de.proveo.wwt.logic.web.common.dataSelection.UnitReportSelectionDTO;
import de.proveo.wwt.logic.web.common.dataSelection.filter.IUnitFilter;
import de.proveo.wwt.logic.web.common.dataSelection.filter.UnitTypeFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UnitListFactory {
    private static final Log logger = LogFactory.getLog(UnitListFactory.class);
    private static UnitFacadeLocal unitFacadeLocal;

    public static Collection<UnitModel> generateUnitModelList(UnitReportSelectionDTO selectionDTO) {
        return UnitListFactory.generateUnitModelList(selectionDTO, true);
    }

    public static Collection<UnitModel> generateUnitModelList(UnitReportSelectionDTO selectionDTO, boolean withRelation) {
        ArrayList<UnitModel> result = new ArrayList<UnitModel>();
        HashMap<Long, UnitModel> unitBasicModels = new HashMap<Long, UnitModel>();
        for (Long unit : selectionDTO.getUnitIds()) {
            for (UnitModel m : UnitListFactory.generateUnitModelList(unit, withRelation)) {
                unitBasicModels.put(m.getUnitId(), m);
            }
        }
        if (selectionDTO.getUnitFilters().isEmpty()) {
            result.addAll(unitBasicModels.values());
        } else {
            for (UnitModel m : unitBasicModels.values()) {
                for (IUnitFilter filter : selectionDTO.getUnitFilters()) {
                    if (!(filter instanceof UnitTypeFilter) || m.getUnitTypeIdentity() != null && !filter.getObjects().contains(m.getUnitTypeIdentity().getId())) continue;
                    result.add(m);
                }
            }
        }
        return result;
    }

    public static Collection<UnitModel> generateUnitModelList(Long unitId) {
        return UnitListFactory.generateUnitModelList(unitId, false);
    }

    public static Collection<UnitModel> generateUnitModelList(Long unitId, boolean withRelation) {
        if (unitId != null && unitId == -1L) {
            return null;
        }
        List<UnitModel> coll = null;
        UnitModel unitModel = null;
        try {
            if (unitFacadeLocal == null) {
                InitialContext initialContext = new InitialContext();
                unitFacadeLocal = (UnitFacadeLocal)initialContext.lookup("rts/UnitFacade/local");
            }
            if (unitId == null) {
                coll = withRelation ? unitFacadeLocal.findNonDeletedByIsBasic(true) : unitFacadeLocal.findyByIsBasic(true);
            } else {
                coll = new ArrayList<UnitModel>();
                unitModel = unitFacadeLocal.getUnitModel(unitId);
                UnitListFactory.generateUnitModelList(unitModel, coll);
            }
        }
        catch (NamingException e) {
            logger.error((Object)"runs into", (Throwable)e);
        }
        return coll;
    }

    private static Collection<UnitModel> generateUnitModelList(UnitModel unitModel, Collection<UnitModel> unitModels) {
        boolean isBasic = unitModel.getBasic();
        if (!isBasic) {
            List<UnitModel> coll = unitModel.getChildModel();
            for (UnitModel childUnit : coll) {
                UnitListFactory.generateUnitModelList(childUnit, unitModels);
            }
        } else if (!unitModels.contains(unitModel)) {
            unitModels.add(unitModel);
        }
        return unitModels;
    }
}

