/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.web.common.dto;

import de.proveo.wwt.logic.web.common.dataSelection.ReportSelectionDTO;
import de.proveo.wwt.logic.web.common.dto.DTOListBase;
import de.proveo.wwt.logic.web.common.dto.UnitDTO;
import de.proveo.wwt.logic.web.common.dto.interfaces.IUnitContainer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UnitContainerListBase<T extends IUnitContainer>
extends DTOListBase<T> {
    private List<UnitDTO> removedUnitsList = new ArrayList<UnitDTO>();
    public Map<Long, UnitDTO> involvedUnitMap = new HashMap<Long, UnitDTO>();
    public HashMap<Long, UnitDTO> involvedDeletedUnitMap = new HashMap();

    public UnitContainerListBase() {
    }

    public UnitContainerListBase(ReportSelectionDTO selectionDTO) {
        super(selectionDTO);
    }

    public T getFirst(long unitId) {
        for (IUnitContainer unit : this) {
            if (unitId != unit.getUnit().getUnitId()) continue;
            return (T)unit;
        }
        return null;
    }

    @Override
    public boolean add(T e) {
        if (e != null && e.getUnit() != null) {
            this.addUnitToInvolvedMap(e.getUnit());
        }
        return super.add(e);
    }

    public boolean removeUnAuthorizedData(IUnitContainer dto) {
        if (super.remove(dto)) {
            UnitDTO unitDTO = dto.getUnit().copy();
            this.removedUnitsList.add(unitDTO);
            this.removeFromInvolvedMap(unitDTO);
            return true;
        }
        return false;
    }

    public boolean isInsufficientPermissions() {
        return this.removedUnitsList != null;
    }

    public int getRemovedDataCount() {
        return this.removedUnitsList == null ? 0 : this.removedUnitsList.size();
    }

    public boolean isAllDataRemoved() {
        return this.removedUnitsList != null && this.size() == 0;
    }

    public Map<Long, UnitDTO> getInvolvedUnitMap() {
        return this.involvedUnitMap;
    }

    public HashMap<Long, UnitDTO> getInvolvedDeletedUnitMap() {
        return this.involvedDeletedUnitMap;
    }

    private void addUnitToInvolvedMap(UnitDTO unitDTO) {
        if (unitDTO == null) {
            return;
        }
        if (unitDTO.getUnitModel().getDeleted()) {
            this.involvedDeletedUnitMap.put(unitDTO.getUnitId(), unitDTO);
        } else {
            this.involvedUnitMap.put(unitDTO.getUnitId(), unitDTO);
        }
    }

    private void removeFromInvolvedMap(UnitDTO unitDTO) {
        if (unitDTO == null) {
            return;
        }
        if (unitDTO.getUnitModel().getDeleted()) {
            this.involvedDeletedUnitMap.remove(unitDTO.getUnitId());
        } else {
            this.involvedUnitMap.remove(unitDTO.getUnitId());
        }
    }

    public void clearInvolvedUnitMaps() {
        this.involvedUnitMap.clear();
        this.involvedDeletedUnitMap.clear();
        this.removedUnitsList.clear();
    }

    public List<UnitDTO> getRemovedUnitsList() {
        return this.removedUnitsList;
    }

    public void setRemovedUnitsList(ArrayList<UnitDTO> removedUnitsList) {
        this.removedUnitsList = removedUnitsList;
    }

    public void copyUnitLists(UnitContainerListBase<?> list) {
        if (list != null) {
            this.involvedDeletedUnitMap = list.getInvolvedDeletedUnitMap();
            this.involvedUnitMap = list.getInvolvedUnitMap();
            this.removedUnitsList = list.getRemovedUnitsList();
        }
    }
}

