/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.web.common.dto;

import de.proveo.wwt.logic.web.common.dto.interfaces.IUnitContainer;
import java.util.Comparator;

public class UnitContainerComparator
implements Comparator<IUnitContainer> {
    private CompareType[] types;
    private boolean ascending = true;

    public UnitContainerComparator(CompareType ... types) {
        this.types = types;
    }

    public UnitContainerComparator(boolean ascending, CompareType ... types) {
        this.types = types;
        this.ascending = ascending;
    }

    @Override
    public int compare(IUnitContainer o1, IUnitContainer o2) {
        return this.comp(o1, o2) * (this.ascending ? 1 : -1);
    }

    private int comp(IUnitContainer o1, IUnitContainer o2) {
        if (o1 == null || o2 == null) {
            return o1 == null ? -1 : 1;
        }
        if (o1.getUnit() == null || o2.getUnit() == null) {
            return o1.getUnit() == null ? -1 : 1;
        }
        int result = 0;
        int index = 0;
        while (result == 0 && index != this.types.length) {
            result = this.comp(o1, o2, this.types[index++]);
        }
        return result;
    }

    private int comp(IUnitContainer o1, IUnitContainer o2, CompareType type) {
        switch (type) {
            case UNIT_ID: {
                if (o1.getUnit().getUnitId() == null || o2.getUnit().getUnitId() == null) {
                    return o1.getUnit().getUnitId() == null ? -1 : 1;
                }
                return o1.getUnit().getUnitId().compareTo(o2.getUnit().getUnitId());
            }
            case UNIT_NAME: {
                if (o1.getUnit().getUnitName() == null || o2.getUnit().getUnitName() == null) {
                    return o1.getUnit().getUnitId() == null ? -1 : 1;
                }
                return o1.getUnit().getUnitName().compareTo(o2.getUnit().getUnitName());
            }
            case UNIT_BASIC: {
                return Boolean.valueOf(o1.getUnit().isBasic()).compareTo(o2.getUnit().isBasic());
            }
        }
        return o1.getUnit().compareTo(o2.getUnit());
    }

    public static enum CompareType {
        UNIT_ID,
        UNIT_NAME,
        UNIT_BASIC;

    }
}

