/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.web.common.dataSelection;

import de.proveo.wwt.logic.web.common.dataSelection.filter.IDataFilter;
import de.proveo.wwt.logic.web.common.dataSelection.filter.ITimeFilter;
import de.proveo.wwt.logic.web.common.dto.DTOBase;
import java.util.ArrayList;
import java.util.List;
import org.joda.time.Interval;

public abstract class ReportSelectionDTO
extends DTOBase {
    protected Interval interval;
    protected List<ITimeFilter> timeFilters = new ArrayList<ITimeFilter>();
    protected List<IDataFilter> dataFilters = new ArrayList<IDataFilter>();

    public ReportSelectionDTO(Interval interval) {
        this.interval = interval;
    }

    public abstract boolean isBasic();

    public abstract int getCount();

    public abstract boolean isAllSelected();

    public abstract ReportSelectionDTO copy();

    public abstract String getName();

    public List<IDataFilter> getDataFilters() {
        return this.dataFilters;
    }

    public void removeAllDataFilters() {
        this.dataFilters.clear();
    }

    public void addDataFilter(IDataFilter filter) {
        this.dataFilters.add(filter);
    }

    public void removeAllTimeFilters() {
        this.timeFilters.clear();
    }

    public void addTimeFilter(ITimeFilter filter) {
        this.timeFilters.add(filter);
    }

    public List<ITimeFilter> getTimeFilters() {
        return this.timeFilters;
    }

    public void setInterval(Interval interval) {
        this.interval = interval;
    }

    public Interval getInterval() {
        return this.interval;
    }

    public void setBeginTime(Long beginTime) {
        if (beginTime != null && this.interval != null) {
            this.interval = new Interval(beginTime.longValue(), this.interval.getEndMillis());
        }
    }

    public void setEndTime(Long endTime) {
        if (endTime != null && this.interval != null) {
            this.interval = new Interval(this.interval.getStartMillis(), endTime.longValue());
        }
    }

    public Long getBeginTime() {
        if (this.interval == null) {
            return null;
        }
        return this.interval.getStartMillis();
    }

    public Long getEndTime() {
        if (this.interval == null) {
            return null;
        }
        return this.interval.getEndMillis();
    }

    public boolean isFactsReport() {
        return this.interval != null;
    }
}

