/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.web.admin;

import de.proveo.ejb.annotations.tags.Business;
import de.proveo.ejb.annotations.tags.JndiLocalBinding;
import de.proveo.ejb.annotations.tags.JndiRemoteBinding;
import de.proveo.util.observable.wrapper.PermissionVO;
import de.proveo.util.observable.wrapper.SerializableEventWrapper;
import de.proveo.wwt.datamodel.account.Account;
import de.proveo.wwt.datamodel.unit.model.UnitModel;
import de.proveo.wwt.datamodel.unit.typeIdentity.UnitTypeIdentity;
import de.proveo.wwt.logic.ejb.dataIn.informant.InformantFacadeLocal;
import de.proveo.wwt.logic.web.admin.PermissionUpdateNotifyLocal;
import de.proveo.wwt.logic.web.admin.PermissionUpdateNotifyRemote;
import de.proveo.wwt.logic.web.common.dto.UnitDTO;
import java.util.ArrayList;
import java.util.List;
import javax.ejb.EJB;
import javax.ejb.Local;
import javax.ejb.Remote;
import javax.ejb.Stateless;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@Stateless(name="PermissionUpdateNotify")
@Local(value={PermissionUpdateNotifyLocal.class})
@Remote(value={PermissionUpdateNotifyRemote.class})
@JndiLocalBinding(localJndiBinding="rts/PermissionUpdateNotify")
@JndiRemoteBinding(remoteJndiBinding="rts/PermissionUpdateNotify")
public class PermissionUpdateNotifyBean
implements PermissionUpdateNotifyLocal,
PermissionUpdateNotifyRemote {
    private static final Log log = LogFactory.getLog(PermissionUpdateNotifyBean.class);
    @EJB
    private InformantFacadeLocal informantFacadeLocal = null;

    @Override
    @Business(viewType="both")
    public void sendPermissionChangedJMSMessage(List<Account> accounts) {
        log.debug((Object)"Permissions changed");
        if (accounts != null) {
            List<PermissionVO> permissionVOList = this.getPermissionVOList(accounts, false, false, false, false);
            this.sendMessage(permissionVOList);
        } else {
            log.error((Object)"List 'accounts' is null!");
        }
    }

    @Override
    @Business(viewType="both")
    public void sendPermissionChangedJMSMessage(Account account) {
        if (account != null) {
            ArrayList<Account> accounts = new ArrayList<Account>();
            accounts.add(account);
            this.sendPermissionChangedJMSMessage(accounts);
        }
    }

    @Override
    @Business(viewType="local")
    public void sendPermissionChangedJMSMessageByUserNames(List<String> usernames) {
        log.debug((Object)"Permissions changed");
        if (usernames != null) {
            List<PermissionVO> permissionVOList = this.getPermissionVOListByUserNames(usernames, false, false, false, false);
            this.sendMessage(permissionVOList);
        } else {
            log.error((Object)"List 'usernames' is null!");
        }
    }

    @Override
    @Business(viewType="local")
    public void sendUserDeletedJMSMessage(List<Account> accounts) {
        log.debug((Object)"Permissions changed: User deleted!");
        if (accounts != null) {
            List<PermissionVO> permissionVOList = this.getPermissionVOList(accounts, true, false, false, false);
            this.sendMessage(permissionVOList);
        } else {
            log.error((Object)"List 'accounts' is null!");
        }
    }

    @Override
    @Business(viewType="local")
    public void sendRoleChangedJMSMessage(List<Account> accounts) {
        log.debug((Object)"Permissions changed: Role changed!");
        if (accounts != null) {
            List<PermissionVO> permissionVOList = this.getPermissionVOList(accounts, false, true, false, false);
            this.sendMessage(permissionVOList);
        } else {
            log.error((Object)"List 'accounts' is null!");
        }
    }

    @Override
    @Business(viewType="local")
    public void sendRoleChangedJMSMessageByUserNames(List<String> usernames) {
        log.debug((Object)"Permissions changed: Role changed!");
        if (usernames != null) {
            List<PermissionVO> permissionVOList = this.getPermissionVOListByUserNames(usernames, false, true, false, false);
            this.sendMessage(permissionVOList);
        } else {
            log.error((Object)"List 'usernames' is null!");
        }
    }

    @Override
    @Business(viewType="local")
    public void sendUserPwChangedJMSMessage(List<Account> accounts) {
        log.debug((Object)"Permissions changed: Pw changed!");
        if (accounts != null) {
            List<PermissionVO> permissionVOList = this.getPermissionVOList(accounts, false, false, true, false);
            this.sendMessage(permissionVOList);
        } else {
            log.error((Object)"'accounts' is null!");
        }
    }

    @Override
    @Business(viewType="local")
    public void sendUserBlockOutJMSMessage(List<Account> accounts) {
        log.debug((Object)"Permissions changed: User BlockOut!");
        if (accounts != null) {
            List<PermissionVO> permissionVOList = this.getPermissionVOList(accounts, false, false, false, true);
            this.sendMessage(permissionVOList);
        } else {
            log.error((Object)"'accounts' is null!");
        }
    }

    @Override
    @Business(viewType="local")
    public void sendUnitTypeChangedJMSMessage(UnitTypeIdentity unitType, List<UnitModel> unitModels) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"sendUnitTypeChangedJMSMessage!");
        }
        UnitModel unitModel = null;
        ArrayList<Long> listAffectedUnitIds = new ArrayList<Long>();
        for (int index = 0; index < unitModels.size(); ++index) {
            unitModel = unitModels.get(index);
            if (unitModel == null) continue;
            listAffectedUnitIds.add(unitModel.getUnitId());
        }
        SerializableEventWrapper eventWrapper = new SerializableEventWrapper();
        eventWrapper.set_typeOfEvent("UnitTypeNotifyMessage");
        eventWrapper.setSystemTime(System.currentTimeMillis());
        eventWrapper.setUnitTypeValue((Object)unitType);
        eventWrapper.setLongList(listAffectedUnitIds);
        this.informantFacadeLocal.notify(eventWrapper, "UnitTypeNotifyMessage");
    }

    @Override
    @Business(viewType="local")
    public void sendStateModelChangedJMSMessage(Object object, String messageType) {
        if (messageType == null || !messageType.equals("StateModelCreateMessage") && !messageType.equals("StateModelUpdateMessage") && !messageType.equals("StateModelRemoveMessage")) {
            log.error((Object)("Unknown message type: " + messageType));
            return;
        }
        SerializableEventWrapper eventWrapper = new SerializableEventWrapper();
        eventWrapper.set_typeOfEvent(messageType);
        eventWrapper.setUnitTypeValue(object);
        eventWrapper.setSystemTime(System.currentTimeMillis());
        this.informantFacadeLocal.notify(eventWrapper, messageType);
    }

    @Override
    @Business(viewType="local")
    public void sendMeasurementChangedJMSMessage(Object object, String messageType) {
        if (messageType == null || !messageType.equals("MeasurementCreateMessage") && !messageType.equals("MeasurementUpdateMessage") && !messageType.equals("MeasurementRemoveMessage")) {
            log.error((Object)("Unknown message type: " + messageType));
            return;
        }
        SerializableEventWrapper eventWrapper = new SerializableEventWrapper();
        eventWrapper.set_typeOfEvent(messageType);
        eventWrapper.setUnitTypeValue(object);
        eventWrapper.setSystemTime(System.currentTimeMillis());
        this.informantFacadeLocal.notify(eventWrapper, messageType);
    }

    private List<PermissionVO> getPermissionVOList(List<Account> accounts, boolean deleted, boolean roleChanged, boolean pwChanged, boolean blockedOut) {
        ArrayList<PermissionVO> permissionVOList = new ArrayList<PermissionVO>();
        for (Account accountValue : accounts) {
            PermissionVO permissionVO = new PermissionVO();
            permissionVO.setUserName(accountValue.getUsername());
            permissionVO.setUserDeleted(deleted);
            permissionVO.setRoleChanged(roleChanged);
            permissionVO.setUserPwChanged(pwChanged);
            permissionVO.setBlockOutUser(blockedOut);
            permissionVOList.add(permissionVO);
            log.debug((Object)("------> " + accountValue.getUsername()));
        }
        return permissionVOList;
    }

    private List<PermissionVO> getPermissionVOListByUserNames(List<String> userNames, boolean deleted, boolean roleChanged, boolean pwChanged, boolean blockedOut) {
        ArrayList<PermissionVO> permissionVOList = new ArrayList<PermissionVO>();
        for (String userName : userNames) {
            PermissionVO permissionVO = new PermissionVO();
            permissionVO.setUserName(userName);
            permissionVO.setUserDeleted(deleted);
            permissionVO.setRoleChanged(roleChanged);
            permissionVO.setUserPwChanged(pwChanged);
            permissionVO.setBlockOutUser(blockedOut);
            permissionVOList.add(permissionVO);
            log.debug((Object)("------> " + userName));
        }
        return permissionVOList;
    }

    @Override
    @Business(viewType="local")
    public void sendAirportMapFlagChangedMessage(Long unitID, boolean airportMapVisibleHasBeenSet) {
        PermissionVO permissionVO = new PermissionVO();
        permissionVO.setAirportMapVisible(unitID, airportMapVisibleHasBeenSet);
        permissionVO.setUserName("");
        permissionVO.setUserDeleted(false);
        permissionVO.setRoleChanged(false);
        permissionVO.setUserPwChanged(false);
        permissionVO.setBlockOutUser(false);
        permissionVO.setUnitsMoved(false);
        this.sendMessage(permissionVO);
    }

    private void sendMessage(List<PermissionVO> permissionVOList) {
        SerializableEventWrapper eventWrapper = new SerializableEventWrapper();
        eventWrapper.set_typeOfEvent("ViewPermissionUpdateMessage");
        eventWrapper.setSystemTime(System.currentTimeMillis());
        eventWrapper.setPermissionVOList(permissionVOList);
        this.informantFacadeLocal.notify(eventWrapper, "ViewPermissionUpdateMessage");
    }

    private void sendMessage(PermissionVO permissionVO) {
        ArrayList<PermissionVO> permissionVOList = new ArrayList<PermissionVO>();
        permissionVOList.add(permissionVO);
        this.sendMessage(permissionVOList);
    }

    @Override
    @Business(viewType="local")
    public void sendAirportMapUnitChangedMessage(UnitDTO unitDto, boolean airportmapVisibleHasBeenSet) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"sendAirportMapUnitChangedMessage!");
        }
        ArrayList<UnitDTO> list = new ArrayList<UnitDTO>();
        list.add(unitDto);
        SerializableEventWrapper eventWrapper = new SerializableEventWrapper();
        if (airportmapVisibleHasBeenSet) {
            eventWrapper.set_typeOfEvent("UnitNotifyMapflagMessage");
        } else {
            eventWrapper.set_typeOfEvent("UnitNotifyMessage");
        }
        eventWrapper.setSystemTime(System.currentTimeMillis());
        eventWrapper.setValueList(list);
        this.informantFacadeLocal.notify(eventWrapper, "UnitNotifyMessage");
    }

    @Override
    @Business(viewType="local")
    public void sendAirportMapUnitDeletedChangedMessage(UnitDTO unitDto) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"sendAirportMapUnitDeletedChangedMessage!");
        }
        ArrayList<UnitDTO> list = new ArrayList<UnitDTO>();
        list.add(unitDto);
        SerializableEventWrapper eventWrapper = new SerializableEventWrapper();
        eventWrapper.set_typeOfEvent("UnitDeletedChangedNotifyMessage");
        eventWrapper.setSystemTime(System.currentTimeMillis());
        eventWrapper.setValueList(list);
        this.informantFacadeLocal.notify(eventWrapper, "UnitDeletedChangedNotifyMessage");
    }

    @Override
    @Business(viewType="local")
    public void sendAirportMapUnitsMovedMessage() {
        PermissionVO permissionVO = new PermissionVO();
        permissionVO.setUserName("");
        permissionVO.setUserDeleted(false);
        permissionVO.setRoleChanged(false);
        permissionVO.setUserPwChanged(false);
        permissionVO.setBlockOutUser(false);
        permissionVO.setUnitsMoved(true);
        this.sendMessage(permissionVO);
    }
}

