/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.statesum;

import de.proveo.ejb.annotations.tags.Business;
import de.proveo.ejb.annotations.tags.JndiLocalBinding;
import de.proveo.ejb.annotations.tags.JndiRemoteBinding;
import de.proveo.wwt.datamodel.statesum.StateSummary;
import de.proveo.wwt.logic.app.keepalive.event.KeepAliveEvent;
import de.proveo.wwt.logic.ejb.dataOut.raw.StateStamp;
import de.proveo.wwt.logic.ejb.general.config.ConfigurationLocal;
import de.proveo.wwt.logic.ejb.general.unit.facade.UnitFacadeLocal;
import de.proveo.wwt.logic.ejb.state.StateOutFacadeLocal;
import de.proveo.wwt.logic.ejb.state.exception.NoStateFoundException;
import de.proveo.wwt.logic.ejb.statesum.StateSummaryDAO;
import de.proveo.wwt.logic.ejb.statesum.StateSummaryFacadeLocal;
import de.proveo.wwt.logic.ejb.statesum.StateSummaryFacadeRemote;
import de.proveo.wwt.logic.web.data.fastlanereader.report.StateSummaryFastLaneReader;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.annotation.PostConstruct;
import javax.ejb.EJB;
import javax.ejb.EJBTransactionRolledbackException;
import javax.ejb.Local;
import javax.ejb.Remote;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.annotation.ejb.PoolClass;
import org.jboss.annotation.ejb.TransactionTimeout;
import org.jboss.ejb3.StrictMaxPool;

@Stateless(name="StateSummaryFacade")
@Remote(value={StateSummaryFacadeRemote.class})
@Local(value={StateSummaryFacadeLocal.class})
@JndiLocalBinding(localJndiBinding="rts/StateSummaryFacade")
@JndiRemoteBinding(remoteJndiBinding="rts/StateSummaryFacade")
@PoolClass(value=StrictMaxPool.class, maxSize=30, timeout=10000L)
public class StateSummaryFacadeBean
implements StateSummaryFacadeLocal,
StateSummaryFacadeRemote {
    private static final Log log = LogFactory.getLog(StateSummaryFacadeBean.class);
    public static final String CONFIG_PERIOD_TYPES = "statesummary.period.types";
    public static final String CONFIG_EXCLUSION_STATES = "statesummary.exclusion.states";
    public static final String DEF_PERIOD_TYPES = "0";
    public static final String DEF_EXCLUSION_STATES = "-1";
    public static final String CONFIG_PARAM_DELIMITER = ",";
    @EJB
    private ConfigurationLocal config = null;
    @EJB
    private StateOutFacadeLocal stateOutFacade = null;
    private Set<Long> exclusionStates;
    private int[] periodTypes;
    @PersistenceContext(unitName="rts")
    private EntityManager em = null;
    private StateSummaryDAO stateSummaryDAO;
    private StateSummaryFastLaneReader stateSummaryFastLaneReader;
    @EJB
    private UnitFacadeLocal unitFacadeLocal = null;

    @PostConstruct
    public void initImpl() {
        this.stateSummaryDAO = StateSummaryDAO.newInstance(this.em);
        this.stateSummaryFastLaneReader = new StateSummaryFastLaneReader();
        String periodTypesString = this.config.getParameter(CONFIG_PERIOD_TYPES, DEF_PERIOD_TYPES);
        Collection<String> periodTypeTokens = this.getTokensFromConfigurationString(periodTypesString, CONFIG_PARAM_DELIMITER);
        Iterator<String> iter = periodTypeTokens.iterator();
        int[] tempPeriodTypes = new int[periodTypeTokens.size()];
        int i = 0;
        while (iter.hasNext()) {
            String periodTypeString = iter.next();
            try {
                int periodType;
                tempPeriodTypes[i] = periodType = Integer.valueOf(periodTypeString).intValue();
                ++i;
            }
            catch (NumberFormatException e) {
                log.error((Object)"runs into", (Throwable)e);
            }
        }
        this.periodTypes = new int[i];
        System.arraycopy(tempPeriodTypes, 0, this.periodTypes, 0, i);
        if (log.isDebugEnabled()) {
            log.debug((Object)("got " + i + " periodTypes from configuration"));
        }
        this.exclusionStates = new HashSet<Long>();
        String exclusionStatesString = this.config.getParameter(CONFIG_EXCLUSION_STATES, DEF_EXCLUSION_STATES);
        Collection<String> exclusionStateTokens = this.getTokensFromConfigurationString(exclusionStatesString, CONFIG_PARAM_DELIMITER);
        for (String exclusionState : exclusionStateTokens) {
            try {
                this.exclusionStates.add(Long.valueOf(exclusionState));
            }
            catch (NumberFormatException e) {
                log.error((Object)"runs into", (Throwable)e);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("got " + this.exclusionStates.size() + " exclusionStates from configuration -> " + this.exclusionStates));
        }
    }

    @Override
    @Business(viewType="both")
    public Set<StateSummary> getStateSummaryValues(long unitId, int periodType, long beginTime, long endTime) {
        HashSet<StateSummary> stateSummaryValues = new HashSet<StateSummary>();
        Collection<StateSummary> stateSummaries = this.stateSummaryFastLaneReader.getStateSummary(unitId, null, beginTime, endTime, periodType, false);
        for (StateSummary stateSummary : stateSummaries) {
            stateSummaryValues.add(stateSummary);
        }
        return stateSummaryValues;
    }

    @Override
    @Business(viewType="both")
    public Long getStateSummaryDuration(long unitId, int periodType, int stateModelId, int stateId, long beginTime, long endTime) {
        Long duration = this.stateSummaryDAO.getSumDuration(unitId, periodType, stateModelId, stateId, beginTime, endTime);
        return duration;
    }

    @Override
    @Business(viewType="both")
    public Long getMaxBeginTime(long unitId, int periodType) {
        return this.stateSummaryDAO.getMaxBeginTime(unitId, periodType);
    }

    @Override
    @Business(viewType="both")
    public Long getMinBeginTime(long unitId) {
        return this.stateSummaryDAO.getMinBeginTime(unitId);
    }

    @Override
    @Business(viewType="both")
    public boolean insertStateSummaryValue(StateSummary stateSummary) {
        try {
            Long grouphistoryId = this.unitFacadeLocal.getGrouphistoryId(stateSummary.getPk().getUnitId(), stateSummary.getPk().getBeginTime());
            if (grouphistoryId == null && this.stateSummaryDAO.countEntriesForUnitIdPeriodTypeStateModelAndState(stateSummary.getPk().getUnitId(), stateSummary.getPk().getPeriodType(), stateSummary.getPk().getStateModelId(), stateSummary.getPk().getStateId()).intValue() == 0) {
                long endTime = this.rollPeriod(stateSummary.getPk().getBeginTime(), 1, stateSummary.getPk().getPeriodType());
                grouphistoryId = this.unitFacadeLocal.getGrouphistoryId(stateSummary.getPk().getUnitId(), endTime);
            }
            stateSummary.setGroupHistoryId(grouphistoryId);
            this.stateSummaryDAO.createEntity(stateSummary);
        }
        catch (Exception e) {
            log.error((Object)"runs into", (Throwable)e);
            return false;
        }
        return true;
    }

    @Override
    @Business(viewType="both")
    @TransactionAttribute(value=TransactionAttributeType.REQUIRED)
    @TransactionTimeout(value=3600)
    public void handleEvent(KeepAliveEvent keepAliveEvent) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("handleEvent() - " + keepAliveEvent));
        }
        long startTime = System.currentTimeMillis();
        for (int i = 0; i < this.periodTypes.length; ++i) {
            this.summarizeStates(keepAliveEvent, this.periodTypes[i]);
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("handleEvent() - duration " + (System.currentTimeMillis() - startTime) + " ms"));
        }
    }

    private void summarizeStates(KeepAliveEvent keepAliveEvent, int periodType) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("summarizeStates('" + keepAliveEvent + "', '" + periodType + "')"));
        }
        long unitId = keepAliveEvent.getUnitId();
        long eventTime = keepAliveEvent.getCreateTimestamp();
        long currentPeriodTime = this.rollPeriod(eventTime, -1, periodType);
        Long maxBeginTime = this.getMaxBeginTime(unitId, periodType);
        if (maxBeginTime == null) {
            maxBeginTime = 0L;
        }
        if (maxBeginTime == 0L) {
            maxBeginTime = this.rollPeriod(currentPeriodTime, -1, periodType);
        }
        if (currentPeriodTime == maxBeginTime) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("StateSummary is already up to date for unitId '" + unitId + "', beginTime=" + currentPeriodTime + " and period type '" + periodType + "'"));
            }
            return;
        }
        long begin = this.rollPeriod(maxBeginTime, 1, periodType);
        long end = this.rollPeriod(begin, 1, periodType);
        while (begin <= currentPeriodTime) {
            this.writeStateSummary(unitId, periodType, begin, end);
            begin = end;
            end = this.rollPeriod(begin, 1, periodType);
        }
    }

    private void writeStateSummary(long unitId, int periodType, long begin, long end) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("writeStateSummary('" + unitId + "', '" + periodType + "', '" + begin + "', '" + end + "')"));
        }
        long startTime = System.currentTimeMillis();
        Set stateEntries = this.getStateEntries(unitId, begin, end, periodType);
        Map<Object, Object> stateModels = new HashMap();
        switch (periodType) {
            case 0: {
                log.debug((Object)("periodType: " + periodType + " -> this.summarizeStateStamps()"));
                stateModels = this.summarizeStateStamps(unitId, periodType, begin, stateEntries);
                break;
            }
            default: {
                log.debug((Object)("periodType: " + periodType + " -> this.summarizeStateSummaryValues"));
                stateModels = this.summarizeStateSummaryValues(unitId, periodType, begin, stateEntries);
            }
        }
        long duration = System.currentTimeMillis() - startTime;
        if (log.isDebugEnabled()) {
            log.debug((Object)("writeStateSummary duration " + duration + " ms for summarizing " + stateEntries.size() + " StateStamps for unitId " + unitId));
            startTime = System.currentTimeMillis();
        }
        Iterator<Object> iter = stateModels.keySet().iterator();
        while (iter.hasNext()) {
            int stateModelId = (Integer)iter.next();
            HashMap stateModel = (HashMap)stateModels.get(stateModelId);
            for (Integer stateId : stateModel.keySet()) {
                if (this.exclusionStates.contains(stateId)) continue;
                StateSummary value = (StateSummary)((Object)stateModel.get(stateId));
                this.insertStateSummaryValue(value);
            }
        }
        if (log.isDebugEnabled()) {
            duration = System.currentTimeMillis() - startTime;
            log.debug((Object)("writeStateSummary duration " + duration + " ms for creating " + stateEntries.size() + " Entities for unitId " + unitId));
        }
    }

    private Set getStateEntries(long unitId, long begin, long end, int periodType) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("getStateEntries('" + unitId + "', '" + begin + "', '" + end + "', '" + periodType + "');"));
        }
        Set<Object> unitEvents = new HashSet<StateSummary>();
        switch (periodType) {
            case 0: {
                try {
                    unitEvents = this.stateOutFacade.getUnitEvents(unitId, begin, end);
                }
                catch (NoStateFoundException e) {
                    log.debug((Object)"No states found in timeframe");
                }
                catch (EJBTransactionRolledbackException e) {
                    log.error((Object)("Unit : " + unitId + " begin " + begin + " end " + end), (Throwable)e);
                }
                break;
            }
            default: {
                unitEvents.addAll(this.getStateSummaryValues(unitId, 0, begin, end));
            }
        }
        return unitEvents;
    }

    private Map<Integer, Map<Integer, StateSummary>> summarizeStateStamps(long unitId, int periodType, long begin, Set<StateStamp> stateStamps) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("summarizeStateStamps('" + unitId + "', '" + periodType + "', '" + begin + "', 'stateStamps');"));
        }
        HashMap<Integer, Map<Integer, StateSummary>> stateModels = new HashMap<Integer, Map<Integer, StateSummary>>();
        for (StateStamp stateStamp : stateStamps) {
            StateSummary summarizedStateSummaryValue;
            HashMap stateModel;
            int currentStateModelId = stateStamp.getStateModelId();
            if (stateModels.containsKey(currentStateModelId)) {
                stateModel = (HashMap)stateModels.get(currentStateModelId);
            } else {
                stateModel = new HashMap();
                stateModels.put(currentStateModelId, stateModel);
            }
            int currentStateId = stateStamp.getStateId();
            if (stateModel.containsKey(currentStateId)) {
                summarizedStateSummaryValue = (StateSummary)((Object)stateModel.get(currentStateId));
            } else {
                summarizedStateSummaryValue = new StateSummary();
                StateSummary.PK pk = new StateSummary.PK();
                pk.setUnitId(unitId);
                pk.setPeriodType(periodType);
                pk.setStateModelId(currentStateModelId);
                pk.setStateId(currentStateId);
                pk.setBeginTime(begin);
                summarizedStateSummaryValue.setDuration(0L);
                summarizedStateSummaryValue.setPk(pk);
                stateModel.put(currentStateId, summarizedStateSummaryValue);
            }
            summarizedStateSummaryValue.setDuration(summarizedStateSummaryValue.getDuration() + stateStamp.getDuration());
        }
        return stateModels;
    }

    private Map<Integer, Map<Integer, StateSummary>> summarizeStateSummaryValues(long unitId, int periodType, long begin, Set<StateSummary> stateSummaryValues) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("summarizeStateSummaryValues('" + unitId + "', '" + periodType + "', '" + begin + "', 'stateSummaryValues');"));
        }
        HashMap<Integer, Map<Integer, StateSummary>> stateModels = new HashMap<Integer, Map<Integer, StateSummary>>();
        for (StateSummary singleStateSummaryValue : stateSummaryValues) {
            StateSummary summarizedStateSummaryValue;
            HashMap stateModel;
            int currentStateModelId = singleStateSummaryValue.getPk().getStateModelId();
            if (stateModels.containsKey(currentStateModelId)) {
                stateModel = (HashMap)stateModels.get(currentStateModelId);
            } else {
                stateModel = new HashMap();
                stateModels.put(currentStateModelId, stateModel);
            }
            int currentStateId = singleStateSummaryValue.getPk().getStateId();
            if (stateModel.containsKey(currentStateId)) {
                summarizedStateSummaryValue = (StateSummary)((Object)stateModel.get(currentStateId));
            } else {
                summarizedStateSummaryValue = new StateSummary();
                StateSummary.PK pk = new StateSummary.PK();
                pk.setUnitId(unitId);
                pk.setPeriodType(periodType);
                pk.setStateModelId(currentStateModelId);
                pk.setStateId(currentStateId);
                pk.setBeginTime(begin);
                summarizedStateSummaryValue.setDuration(0L);
                summarizedStateSummaryValue.setPk(pk);
                stateModel.put(currentStateId, summarizedStateSummaryValue);
            }
            summarizedStateSummaryValue.setDuration(summarizedStateSummaryValue.getDuration() + singleStateSummaryValue.getDuration());
        }
        return stateModels;
    }

    private long rollPeriod(long time, int amount, int periodType) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date(time));
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        if (periodType == 0) {
            cal.add(5, amount);
        } else if (periodType == 1) {
            cal.add(3, amount);
            cal.set(7, 2);
        } else if (periodType == 2) {
            cal.add(2, amount);
            cal.set(5, 1);
        } else if (periodType == 3) {
            cal.add(1, amount);
            cal.set(2, 0);
            cal.set(5, 1);
        } else {
            log.error((Object)("unknown period type '" + periodType + "'"));
        }
        return cal.getTimeInMillis();
    }

    private Collection<String> getTokensFromConfigurationString(String string, String delim) {
        Vector<String> tokens = new Vector<String>();
        StringTokenizer tokenizer = new StringTokenizer(string, delim);
        while (tokenizer.hasMoreTokens()) {
            tokens.add(tokenizer.nextToken());
        }
        return tokens;
    }
}

