/*
 * Decompiled with CFR 0.152.
 */
package de.proveo.wwt.logic.ejb.statesum;

import de.proveo.util.observable.wrapper.SerializableEventWrapper;
import de.proveo.wwt.logic.app.keepalive.event.KeepAliveEvent;
import de.proveo.wwt.logic.ejb.statesum.StateSummaryFacadeLocal;
import java.io.Serializable;
import javax.annotation.PostConstruct;
import javax.ejb.ActivationConfigProperty;
import javax.ejb.EJB;
import javax.ejb.MessageDriven;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@MessageDriven(name="StateSummarize", activationConfig={@ActivationConfigProperty(propertyName="destinationType", propertyValue="javax.jms.Topic"), @ActivationConfigProperty(propertyName="destination", propertyValue="topic/proveoDataProviderTopic"), @ActivationConfigProperty(propertyName="messageSelector", propertyValue="TypeOfInterest='KeepAlive'"), @ActivationConfigProperty(propertyName="transactionTimeout", propertyValue="3600"), @ActivationConfigProperty(propertyName="maxSession", propertyValue="1")})
public class StateSummarizeBean
implements MessageListener {
    private static final long serialVersionUID = 2496601723151295734L;
    private static final Log log = LogFactory.getLog(StateSummarizeBean.class);
    @EJB
    private StateSummaryFacadeLocal stateSummaryFacade = null;

    @PostConstruct
    public void ejbCreate() {
    }

    public void onMessage(Message msg) {
        long startTime;
        block7: {
            if (log.isTraceEnabled()) {
                log.trace((Object)"onMessage(msg)");
            }
            startTime = System.currentTimeMillis();
            if (msg instanceof ObjectMessage) {
                try {
                    SerializableEventWrapper wrapper;
                    String typeOfEvent;
                    Serializable obj = ((ObjectMessage)msg).getObject();
                    if (!(obj instanceof SerializableEventWrapper) || !"KeepAlive".equals(typeOfEvent = (wrapper = (SerializableEventWrapper)obj).get_typeOfEvent())) break block7;
                    log.debug((Object)"got KEEP_ALIVE_EVENT");
                    Object cache = wrapper.get_cacheValue();
                    if (cache instanceof KeepAliveEvent) {
                        this.handleEvent((KeepAliveEvent)cache);
                        break block7;
                    }
                    log.warn((Object)("unknown object received: " + cache.getClass()));
                }
                catch (JMSException e) {
                    log.error((Object)"runs into", (Throwable)e);
                }
            } else {
                log.error((Object)("recieved unknown message: " + msg));
            }
        }
        if (log.isDebugEnabled()) {
            long duration = System.currentTimeMillis() - startTime;
            log.debug((Object)("StateSummarizeBean duration: " + duration + " ms"));
        }
    }

    private void handleEvent(KeepAliveEvent keepAliveEvent) {
        this.stateSummaryFacade.handleEvent(keepAliveEvent);
    }
}

